(function () {

    'use strict';
    angular.module('sys.app.orderspurchases.detail')
        .controller('DetailOrderPurchasesCtrl', DetailOrderPurchasesCtrl);

    DetailOrderPurchasesCtrl.$inject = ['$scope', '$stateParams', '$state', 'RESTService', 'EventsFactory', '$http', 'notifyAlert','_', 'HelperFactory', '$timeout', 'ORDER', 'SEARCH', 'AlertFactory', 'ConfigPagination', '$uibModal'];

    function DetailOrderPurchasesCtrl($scope, $stateParams, $state, RESTService, EventsFactory, $http, notifyAlert,_, HelperFactory, $timeout, ORDER, SEARCH, AlertFactory, ConfigPagination, $uibModal) {

        var quantity_default = 1;
        $scope.subtotal = 0;
        $scope.total_order= 0;
        $scope.client = null;
        $scope.text = null;

        try {
            $scope.check_order = $stateParams.entity.order;

            if (!_.isNull($scope.check_order.id)) {
                $scope.entity = $stateParams.entity.order;
                $scope.order = $stateParams.entity.order;

                if ($scope.order.id != 0) {
                    $scope.products = $stateParams.entity.detail;
                }
            }
        }
        catch (e) {
            $state.transitionTo('purchase.orderspurchases', null, {'reload': true});
            console.log(e);
            return false;
        };

        init()

        function init() {

            // RESTService.all('config/tax', null, function (response) {
            //     $scope.igv = response.results[0].percentage;
            // });

            RESTService.all('config/currency', null, function (response) {
                $scope.currency = response.results;
                $scope.currencySelected = response.results[0];
            });
        }


        $scope.edit = function (source) {
            delete $scope.allData;
            RESTService.get('order/edit', source.id, function (response) {
                $state.transitionTo("purchase.orderspurchases.edit", {
                    'id': source.id,
                    entity: response.data
                }, {'reload': "purchase.orderspurchases.edit", 'cache': false});
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };

        $scope.delete = function (item) {
            var options = {
                title: "Cuidado!!",
                message: "El pedido ' "+item.code+" ' será eliminado",
                cancel: "Cancelar",
                confirm: "Eliminar"
            };
            AlertFactory.confirm(options, function () {
                RESTService.deleted('order/delete', item.id, function (response) {
                    notifyAlert.success("El item se ha eliminado con éxito!!");
                    var obj = {"text": $scope.text};
                    $state.transitionTo('purchase.orderspurchases', {entity: obj}, {'reload': true});
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });

            })
        };

        $scope.sendEmailOrderPurchase = function (item) {
            swal({
                title: '<span class="f-s-16">Enviar por correo el orden de compra<span class="text-success bold">N° '+item.code+'</span></span>',
                input: 'email',
                inputValue: "ejem@gmail.com",
                inputPlaceholder: "Ingrese correo, Ejem: cliente@gmail.com",
                showCancelButton: true,
                confirmButtonColor: "#30419b",
                confirmButtonText: "<i class='fas fa-envelope m-r-5'></i>Confirmar envío",
                cancelButtonText: "Cancelar"
            }).then(function (email) {
                if(email.value){
                    $("#loading_object").show();
                    $.ajax({
                        url: '/send/email/proforma/'+ item.id,
                        type: 'GET',
                        data: {
                            email:email.value
                        },
                        success: function(response) {
                            $("#loading_object").hide();
                            swal({
                                type: 'success',
                                title:'Excelente !!',
                                html:response.msg
                            })
                        },
                        error: (function (error) {
                            $("#loading_object").hide();
                            swal({
                                type: 'error',
                                title:'Hubo un error !!',
                                html: "Hubo un error al realizar el envío. Para mayor información consulte a su administrador." + error
                            })
                        })
                    });
                }
            });
        };

        $scope.printOrderPurchase = function (item) {
            window.open('/print/order/purchase/document/'+ item.id);
        };


        $scope.close = function () {
            $state.transitionTo('purchase.orderspurchases', null, {'reload': true});
        }

    }

})();

