(function () {
    'use strict';
    angular.module('sys.app.orderspurchases')
        .controller('OrderPurchasesCtrl', OrderPurchasesCtrl);

    OrderPurchasesCtrl.$inject =['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory', '$http', '$timeout', 'notifyAlert', 'SEARCH', 'loadingAlert', '$uibModal', 'ORDER'];

    function OrderPurchasesCtrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $http, $timeout, notifyAlert, SEARCH, loadingAlert, $uibModal, ORDER) {

        $scope.entity = {};
        $scope.text= null;
        $scope.currentPage = 1;

        $scope.status = ORDER.STATUS;
        $scope.statusSelected = ORDER.STATUS[0];

        var object = "";

        init();

        function init() {
            object = "search=" + $scope.text + '&page=' + $scope.currentPage+'&statusDelivered='+$scope.statusSelected.id;
            RESTService.all('order/purchase/list', object + '&export=0', function (response) {
                $scope.allData = response.results;
                $scope.totalItems = response.total;
                $scope.itemsPerPage = response.paginate_by;
            }, function (error) {
                console.log('ERROR');
                return false;
            });

        }

        $scope.edit = function (source) {
            delete $scope.allData;
            RESTService.get('order/purchase/edit', source.id, function (response) {
                $state.transitionTo("purchase.orderspurchases.edit", {
                    'id': source.id,
                    entity: response.data
                }, {'reload': "purchase.orderspurchases.edit", 'cache': false});
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };


        $scope.detail = function (source) {
            delete $scope.allData;
            RESTService.get('order/purchase/detail', source.id, function (response) {
                $state.transitionTo("purchase.orderspurchases.detail", {
                    'id': source.id,
                    entity: response.data
                }, {'reload': "purchase.orderspurchases.detail", 'cache': false});
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };


        $scope.searchAction = function (text) {
            $scope.text = text;
            $scope.currentPage = 1;
            if (text.length >= SEARCH.MIN_LETTERS || text.length == 0) {
                delete $scope.allData;
                init();
            }
        };

        $scope.pageChanged = function(page) {
            $scope.currentPage = page;
            delete $scope.allData;
            init();
        };

        $scope.selectedStatus = function (item) {
            $scope.statusSelected = item;
            init();
        };


        $scope.new = function () {
            var source = {'order': {'id':0 }};
            $state.transitionTo('purchase.orderspurchases.new', {entity: source}, {
                'reload': 'purchase.orderspurchases.new',
                'cache': false
            });
            delete $scope.allData;
        };

        $scope.refresh = function () {
            delete $scope.allData;
            $state.transitionTo('purchase.orderspurchases', {entity: null}, {'reload': true});
        };

        $scope.delete = function (item) {
            var options = {
                title: "Cuidado!!",
                message: "El pedido ' "+item.code+" ' será eliminado",
                cancel: "Cancelar",
                confirm: "Eliminar"
            };
            AlertFactory.confirm(options, function () {
                RESTService.deleted('order/delete', item.id, function (response) {
                    notifyAlert.success("El item se ha eliminado con éxito!!");
                    var obj = {"text": $scope.text};
                    $state.transitionTo('purchase.orderspurchases', {entity: obj}, {'reload': true});
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });

            })
        };

        $scope.associateSale = function (sale_id) {
            RESTService.get('sales/detail', sale_id, function (response) {
                var obj = {'data': response.data};
                $uibModal.open({
                    animation: true,
                    templateUrl: '../../templates/sales/sale/modaldetail.html',
                    controller: 'ModalDetailSaleCtrl',
                    size: 'modal-dialog modal-lg',
                    backdrop: 'static',
                    appendTo: angular.element(document.querySelector('#wrapper')),
                    resolve: {
                        PARAM: function () {
                            return obj;
                        }
                    }
                });
            });
        };

        $scope.printOrderPurchase = function (item) {
            window.open('/print/order/purchase/document/'+ item.id);
        };

    }
})();


