(function () {

    'use strict';
    angular.module('sys.app.providers.new')
        .controller('NewProvidersCtrl', NewProvidersCtrl);

    NewProvidersCtrl.$inject = ['$scope', '$stateParams', '$state', 'RESTService','notifyAlert', '_', 'HelperFactory', 'ConfigPagination', '$timeout', 'fileReader', 'CLIENT', 'TYPE_DOCUMENT'];

    function NewProvidersCtrl($scope, $stateParams, $state, RESTService, notifyAlert, _, HelperFactory, ConfigPagination, $timeout, fileReader, CLIENT, TYPE_DOCUMENT) {

        $('[data-toggle="tooltip"]').tooltip();

        try {
            if (!_.isNull($stateParams.entity.id)) {
                $scope.entity = $stateParams.entity.data;
                $scope.provider = $stateParams.entity.data;

                if ($scope.provider.id != 0) {//$scope.unitElements
                    $scope.txt_title = 'Editar';
                    $scope.action = 'edit';
                    $scope.provider.fullname = $scope.entity.fullname;
                    $scope.provider.document = $scope.entity.document;
                    $scope.provider.tradename = $scope.entity.tradename;
                    $scope.provider.telephone = $scope.entity.telephone;
                    $scope.provider.email = $scope.entity.email;
                    $scope.provider.address = $scope.entity.address;
                    $scope.provider.url_image = $scope.entity.urlImageBase;

                    $scope.ubigeo = $stateParams.entity.ubigeo;
                }
                else
                {
                    $scope.txt_title = 'Registrar';
                    $scope.action = 'create';
                    $scope.provider = {
                        'fullname': null,
                        'document': null,
                        'tradename': null,
                        'cellphone': null,
                        'telephone': null,
                        'email': null,
                        'address':null,
                        'url_image':null,
                        'date_birthday':null
                    };

                    $scope.ubigeo = false;
                }
            }
        }
        catch (e) {
            $state.transitionTo('purchase.providers', null, {'reload': true});
            console.log(e);
            return false;
        }

        init()

        function init() {

            $scope.service_alert = false;

            $scope.type_dni = TYPE_DOCUMENT['DNI'];
            $scope.type_ruc = TYPE_DOCUMENT['RUC'];
            $scope.max_length_document = 11;


            checkUbigeo();

            angular.element(document.querySelector('#provider_document')).focus();
        }

        function checkUbigeo() {
            if($scope.ubigeo){
                $("#departmentSelected").html('');
                $("#provinceSelected").html('');
                $("#districtSelected").html('');

                $scope.is_required_ubigeo = true;

                $scope.departments = $scope.ubigeo.departments;
                $scope.provinces = $scope.ubigeo.provinces;
                $scope.districts = $scope.ubigeo.districts;

                $timeout(function () {
                    $scope.departmentSelected = ConfigPagination.searchById($scope.ubigeo.department_id,$scope.ubigeo.departments);
                    $scope.provinceSelected = ConfigPagination.searchById($scope.ubigeo.province_id,$scope.ubigeo.provinces);
                    $scope.districtSelected = ConfigPagination.searchById($scope.ubigeo.district_id,$scope.ubigeo.districts);
                }, 100);

                return true;
            }
            else{
                RESTService.all('ubigeo/departments', null, function (response) {
                    var last = response.results.length;
                    $scope.departments = response.results;
                    response.results[last] = {id: 0, code:'0', name:'Seleccione', value:0}
                    $scope.departmentSelected = response.results[last];
                    $scope.is_required_ubigeo = false;
                });
                return false;
            }
        }

        $scope.$on("fileProgress", function(e, progress) {
            $scope.progress = progress.loaded / progress.total;
        });

        $scope.changeTypeDocument = function () {
            $scope.provider.document = null;
            if($scope.typeDocumentSelected.id == $scope.type_ruc.id){
               $scope.max_length_document = $scope.type_ruc.max_length;
            }
            else if($scope.typeDocumentSelected.id == $scope.type_dni.id)
                $scope.max_length_document = $scope.type_dni.max_length;
            else{
                $scope.max_length_document = 20;
            }
        }

        $scope.changeDepartment = function () {
            if($scope.departmentSelected.code == '0'){
                $("#provinceSelected").html('')
                $("#districtSelected").html('')
                delete $scope.provinceSelected;
                delete $scope.districtSelected;
                $scope.is_required_ubigeo = false;
            }
            else{
                $scope.is_required_ubigeo = true;
                getProvinces($scope.departmentSelected.code);
            }
        }

        $scope.changeDepartment = function () {
            if($scope.departmentSelected.code == '0'){
                $("#provinceSelected").html('')
                $("#districtSelected").html('')
                delete $scope.provinceSelected;
                delete $scope.districtSelected;
                $scope.is_required_ubigeo = false;
            }
            else{
                $scope.is_required_ubigeo = true;
                getProvinces($scope.departmentSelected.code);
            }
        }

        $scope.changeProvince = function () {
            if($scope.provinceSelected.code == '0'){
                $("#districtSelected").html('')
                delete $scope.districtSelected;
            }
            else{
                getDistricts($scope.provinceSelected.code);
            }
        }

        $scope.changeDistrict= function () {
            if($scope.districtSelected.code == '0'){
                delete $scope.districtSelected;
            }
        }

        function getProvinces(department_id) {
            RESTService.get('ubigeo/provinces', department_id, function (response) {
                $("#provinceSelected").html('')
                $("#districtSelected").html('')
                delete $scope.districtSelected;

                var last = response.results.length;
                response.results[last] = {id: 0, code:'0', name:'Seleccione', value:0}
                $scope.provinces = response.results;
                $scope.provinceSelected = response.results[last];
            });
        }

        function getDistricts(province_id) {
            delete $scope.districtSelected;
            RESTService.get('ubigeo/districts', province_id, function (response) {
                $("#districtSelected").html('')

                var last = response.results.length;
                response.results[last] = {id: 0, code:'0', name:'Seleccione', value:0}
                $scope.districts = response.results;
                $scope.districtSelected = response.results[last];
            });
        }


        $scope.save = function () {
            if (validate()) {

                $scope.provider['is_required_ubigeo'] = $scope.is_required_ubigeo;

                // ubigeo data
                if($scope.is_required_ubigeo) {
                    $scope.provider['department_id'] = $scope.departmentSelected.code;
                    $scope.provider['province_id'] = $scope.provinceSelected.code;
                    $scope.provider['district_id'] = $scope.districtSelected.code;
                }

                if($scope.action == 'create'){
                    RESTService.save('providers/save', $scope.provider, function (result) {
                        notifyAlert.success("Registro realizado con éxito!!");
                        $state.transitionTo('purchase.providers', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
                else if($scope.action == 'edit'){
                    RESTService.updated('providers/update', $scope.provider.id, $scope.provider, function (result) {
                        notifyAlert.success("Registro actualizado con éxito!!");
                        $state.transitionTo('purchase.providers', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
            }
        };

        function validate() {
            if (_.isNull($scope.provider.fullname) || _.isEmpty($scope.provider.fullname)) {
                HelperFactory.show_AlertFactory('Debe ingresar la razón social del proveedor');
                angular.element(document.querySelector('#provider_fullname')).focus();
                return false;
            }
            if (_.isNull($scope.provider.document) || _.isEmpty($scope.provider.document)) {
                HelperFactory.show_AlertFactory('Debe ingresar el N° de RUC del proveedor');
                angular.element(document.querySelector('#provider_document')).focus();
                return false;
            }

            if($scope.is_required_ubigeo){
                if ($scope.districtSelected.code == 0 || _.isEmpty($scope.districtSelected.code)) {
                    HelperFactory.show_AlertFactory('Debe seleccionar un distrito');
                    angular.element(document.querySelector('#districtSelected')).focus();
                    return false;
                }
            }

            return true;
        };

        $scope.close = function () {
            $state.transitionTo('purchase.providers', null, {'reload': true});
        };

        // extract data by document
        $scope.extractDni = function () {
            $scope.service_alert = false;
            RESTService.get('services/dni', $scope.provider.document, function (response) {
                if(response.success == true){
                    $scope.service_alert = true;
                    $scope.service_message = 'Los datos del cliente se extrajeron correctamente ';
                    replaceExtractDniData(response.data);
                }else{
                    notifyAlert.warning(response.message);
                }
            }, function (error) {
                return false;
            });

        }

        $scope.extractRuc = function () {
            $scope.service_alert = false;
            RESTService.get('services/ruc', $scope.provider.document, function (response) {
                if(response.success == true){
                    $scope.service_alert = true;
                    $scope.service_message = 'El cliente se encuentra '+ response.data.status+ ' y '+ response.data.condition;
                    replaceExtractRucData(response.data);
                }else{
                    notifyAlert.warning(response.message);
                }
            }, function (error) {
                return false;
            });
        }

        function replaceExtractRucData(data) {
            $scope.provider.fullname = data.name;
            $scope.provider.address = data.address;
            $scope.ubigeo = data.ubigeo;
            checkUbigeo();
        }

        function replaceExtractDniData(data) {
            $scope.provider.fullname = data.fullname;
            $scope.provider.date_birthday = data.date_of_birthday;
        }

        // =============
    }

})();