(function () {
    'use strict';
    angular.module('sys.app.providers')
        .controller('ProvidersCtrl', ProvidersCtrl);

    ProvidersCtrl.$inject = ['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory','$timeout', 'notifyAlert', 'SEARCH'];

    function ProvidersCtrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $timeout, notifyAlert, SEARCH) {

        $scope.entity = {};
        $scope.text= null;
        $scope.currentPage = 1;
        var object = "";

        init();

        function init() {
            object = "search=" + $scope.text + '&page=' + $scope.currentPage;
            RESTService.all('providers/list', object + '&export=0', function (response) {

                $scope.allData = response.results;
                $scope.totalItems = response.total;
                $scope.itemsPerPage = response.paginate_by;

            }, function (error) {
                console.log('ERROR');
                return false;
            });
        }


        $scope.searchAction = function (text) {
            $scope.text = text;
            $scope.currentPage = 1;
            if (text.length >= SEARCH.MIN_LETTERS || text.length == 0) {
                delete $scope.allData;
                init();
            }
        };

        $scope.refresh = function () {
            delete $scope.allData;
            $state.transitionTo('purchase.providers', {entity: null}, {'reload': true});
        };

        // functions new product
        $scope.new = function () {
            var provider = {'id': 0}
            var source = {'data': provider};

            $state.transitionTo('purchase.providers.new', {entity: source}, {
                'reload': 'purchase.providers.new',
                'cache': false
            });
            delete $scope.allData;
        };

        $scope.edit = function (source) {
            RESTService.get('providers/edit', source.id, function (response) {
                $state.transitionTo("purchase.providers.edit", {
                    'id': source.id,
                    entity: response
                }, {'reload': "purchase.providers.edit", 'cache': false});
                delete $scope.allData;
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };

        $scope.pageChanged = function(page) {
            $scope.currentPage = page;
            delete $scope.allData;
            // console.log('Page changed to: ' + $scope.currentPage);
            init();
        };

        $scope.delete = function (item) {
            var options = {
                title: "Cuidado!!",
                message: "El registro ' "+item.description+" ' será eliminado",
                cancel: "Cancelar",
                confirm: "Eliminar"
            };
            AlertFactory.confirm(options, function () {
                RESTService.deleted('providers/delete', item.id, function (response) {
                    notifyAlert.success("El item se ha eliminado con éxito!!");
                    var obj = {"text": $scope.text};
                    $state.transitionTo('purchase.providers', {entity: obj}, {'reload': true});
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });

            })

        };
    }
})();



