(function () {

    'use strict';
    angular.module('sys.app.purchases.detail')
        .controller('DetailPurchasesCtrl', DetailPurchasesCtrl);

    DetailPurchasesCtrl.$inject = ['$scope', '$stateParams', '$state', 'RESTService', 'EventsFactory', '$http', 'notifyAlert','_', 'HelperFactory', '$timeout', 'ORDER', 'SEARCH', 'AlertFactory', 'ConfigPagination', '$uibModal'];

    function DetailPurchasesCtrl($scope, $stateParams, $state, RESTService, EventsFactory, $http, notifyAlert,_, HelperFactory, $timeout, ORDER, SEARCH, AlertFactory, ConfigPagination, $uibModal) {

        try {
            $scope.check_purchase = $stateParams.entity.purchase;

            if (!_.isNull($scope.check_purchase.id)) {
                $scope.entity = $stateParams.entity.purchase;
                $scope.purchase = $stateParams.entity.purchase;

                if ($scope.purchase.id != 0) {
                    $scope.products = $stateParams.entity.detail;
                }
            }
        }
        catch (e) {
            $state.transitionTo('purchase.purchases', null, {'reload': true});
            console.log(e);
            return false;
        }

        init()

        function init() {

            RESTService.all('config/tax', null, function (response) {
                $scope.igv = response.results[0].percentage;
            });

            RESTService.all('config/currency', null, function (response) {
                $scope.currency = response.results;
                $scope.currencySelected = response.results[0];
                $scope.purchase.exchange_currency = $scope.currencySelected.exchange_rate;
                currencySelected($scope.purchase.currency_id);
            });
        }

        function currencySelected(id) {
            if(!_.isUndefined(id)){
                $scope.currencySelected = ConfigPagination.searchById(id,$scope.currency);
            }
        }


        $scope.delete = function (item) {
            var options = {
                title: "Cuidado!!",
                message: "La compra N° ' "+item.code+" ' será eliminada",
                cancel: "Cancelar",
                confirm: "Eliminar"
            };
            AlertFactory.confirm(options, function () {
                RESTService.deleted('purchases/delete', item.id, function (response) {
                    notifyAlert.success("El item se ha eliminado con éxito!!");
                    var obj = {"text": $scope.text};
                    $state.transitionTo('purchase.purchases', {entity: obj}, {'reload': true});

                }, function (error) {
                    console.log('ERROR');
                    return false;
                });

            })
        };

        $scope.close = function () {
            $state.transitionTo('purchase.purchases', null, {'reload': true});
        }


    }

})();

