(function () {

    'use strict';
    angular.module('sys.app.purchases.new')
        .controller('NewPurchasesCtrl', NewPurchasesCtrl);

    NewPurchasesCtrl.$inject = ['$scope', '$stateParams', '$state', 'RESTService', 'notifyAlert', '_', 'HelperFactory', 'ConfigPagination', '$timeout', 'fileReader', '$uibModal', 'PAYMENT_METHOD', 'TRANSACTION', 'AlertFactory'];

    function NewPurchasesCtrl($scope, $stateParams, $state, RESTService, notifyAlert, _, HelperFactory, ConfigPagination, $timeout, fileReader, $uibModal, PAYMENT_METHOD, TRANSACTION, AlertFactory) {

        $scope.provider = null;
        $scope.subtotal = 0;
        $scope.total_igv = 0;
        $scope.total_purchase = 0;

        $scope.paymethod_cash = PAYMENT_METHOD['cash'];
        $scope.paymethod_deposit = PAYMENT_METHOD['deposit'];

        $scope.sale_cash = TRANSACTION.TYPES[0];
        $scope.sale_credit = TRANSACTION.TYPES[1];

        $scope.intervalDates = TRANSACTION.INTERVALS;
        $scope.intervalDateSelected = TRANSACTION.INTERVALS[0];

        $scope.bankaccounts = [];

        try {

            $scope.check_purchase = $stateParams.entity.purchase;

            if (!_.isNull($scope.check_purchase.id)) {
                $scope.entity = $stateParams.entity.purchase;
                $scope.purchase = $stateParams.entity.purchase;

                if ($scope.purchase.id != 0) {//$scope.unitElements
                    $scope.txt_title = 'Editar';
                    $scope.action = 'edit';
                    $scope.purchase.date_purchase = $scope.entity.date_purchase;
                }
                else {
                    $scope.txt_title = 'Registrar';
                    $scope.action = 'create';

                    $scope.products = [];

                    $scope.purchase = {
                        'nro_voucher': null,
                        'date_purchase': null,
                        'exchange_currency': null,
                        'nro_guidereference': null,
                        'observation': null,
                        'is_igv': false,
                        'affect_moneybox': true,
                        'reference_operation': null,
                    };

                    $scope.schedule = {
                        'number_quota':null,
                        'first_date_schedule':null
                    };

                    $scope.ubigeo = false;
                }
            }
        }
        catch (e) {
            $state.transitionTo('purchase.purchases', null, {'reload': true});
            console.log(e);
            return false;
        }

        init();

        function init() {

            RESTService.all('config/typetransaction', null, function (response) {
                $scope.transactions = response.results;
                $scope.transactionSelected = response.results[0];
                // typeProductSelected($scope.product.type_product);
            });

            RESTService.all('config/tax', null, function (response) {
                $scope.igv = response.results[0].percentage;
            });

            RESTService.all('config/currency', null, function (response) {
                $scope.currency = response.results;
                $scope.currencySelected = response.results[0];
                $scope.purchase.exchange_currency = $scope.currencySelected.exchange_rate;
            });

            RESTService.all('config/paymentmethod', null, function (response) {
                $scope.paymentmethods = response.results;
                $scope.paymentSelected = response.results[0];
                // paymentSelected($scope.expense.paymentmethod_id);
            });

            RESTService.all('config/typevoucher/purchase', null, function (response) {
                $scope.typevouchers = response.results;
                $scope.typeVoucherSelected = response.results[0];
            });

            RESTService.all('warehouses/branchoffice', null, function (response) {
                $scope.warehouses = response.results;
                $scope.warehousesSelected = response.results[0];
            });

            $timeout(function () {
                $('#date_purchase').datepicker({
                    dateFormat: 'yy-mm-dd',
                    autoclose: true,
                });

                $('[data-toggle="tooltip"]').tooltip();

                angular.element(document.querySelector('#search_provider_value')).focus();
            }, 100);
        }

        $scope.changeTypeTransacation = function (transaction) {
            if (transaction.id == $scope.sale_cash.id) {// venta al contado
                $scope.purchase.affect_moneybox = true;
            }
            else if (transaction.id == $scope.sale_credit.id) {
                $scope.purchase.affect_moneybox = false;

                $timeout(function () {
                    $('#first_date_schedule').datepicker({
                        dateFormat: 'yy-mm-dd',
                        autoclose: true,
                        minDate: new Date(),
                    });

                    $('[data-toggle="tooltip"]').tooltip();

                }, 100);

            }
        }

        $scope.changeCurrency = function (item) {
            $scope.currencySelected = item;
            $scope.purchase.exchange_currency = $scope.currencySelected.exchange_rate;
        };

        $scope.changePurchaseIgv = function (igv) {
            if ($scope.products.length > 0) {
                if (igv) {
                    for (var i in $scope.products) {
                        var item = $scope.products[i];
                        var index = $scope.products.indexOf(item);
                        var igv = ((item.subtotal * $scope.igv) / 100).toFixed(2);
                        var total = Number(item.subtotal) + Number(igv);
                        $scope.products[index].igv = igv;
                        $scope.products[index].total = total;
                        $scope.products[index].is_igv = true;
                    }
                } else {
                    for (var i in $scope.products) {
                        var item = $scope.products[i];
                        var index = $scope.products.indexOf(item);
                        var igv = 0;
                        var total = Number(item.subtotal) + Number(igv);
                        $scope.products[index].igv = igv;
                        $scope.products[index].total = total;
                        $scope.products[index].is_igv = false;
                    }
                }
                $timeout(function () {
                    sum_items();
                }, 300);
            }
        };

        $scope.recalculate_quantity = function (count, product, $index) {
            var check_quantity = angular.element(document.querySelector('#quantity' + $index)).val();
            var q_ = check_quantity;

            angular.element(document.querySelector('#quantity' + $index)).val(q_);

            var quantity = angular.element(document.querySelector('#quantity' + $index)).val();

            if (!_.isNaN(quantity * 1)) {
                var index = $scope.products.indexOf(product);
                var subtotal = (Number(quantity) * Number($scope.products[index].price));
                var igv = 0;
                if ($scope.purchase.is_igv) {
                    igv = ((subtotal * $scope.igv) / 100).toFixed(2);
                }

                var total = Number(subtotal) + Number(igv);

                $scope.products[index].quantity = quantity;
                $scope.products[index].subtotal = subtotal;
                $scope.products[index].igv = igv;
                $scope.products[index].total = total;

                $timeout(function () {
                    sum_items();
                }, 300);
            }
        };

        $scope.recalculate_price = function (price, product, $index) {
            var check_price = angular.element(document.querySelector('#price' + $index)).val();
            var q_ = check_price;

            angular.element(document.querySelector('#price' + $index)).val(q_);

            var price_get = angular.element(document.querySelector('#price' + $index)).val();

            if (!_.isNaN(price_get * 1)) {
                var index = $scope.products.indexOf(product);

                var subtotal = (Number(product.quantity) * Number(price_get)).toFixed(2);
                var igv = 0;
                if ($scope.purchase.is_igv) {
                    igv = ((subtotal * $scope.igv) / 100).toFixed(2);
                }
                var total = Number(subtotal) + Number(igv);
                $scope.products[index].price = Number(price_get);
                $scope.products[index].subtotal = subtotal;
                $scope.products[index].igv = igv;
                $scope.products[index].total = total;
                $timeout(function () {
                    sum_items();
                }, 300);
            }
        };

        $scope.recalculate_igv = function (igv, product, $index) {
            console.log(igv);
        };

        $scope.change_unitmeasure = function (unitSelected, product, $index) {
            var check_unit = angular.element(document.querySelector('#unitSelected' + $index)).val();
            var pos = $scope.products.indexOf(product);
            $scope.products[pos].unit_id = check_unit;
        };

        $scope.change_date_expiration = function (check, product, $index) {
            var pos = $scope.products.indexOf(product);
            $scope.products[pos].date_expiration = null;
            $("#expiration_date"+$index).val('');
            if(check){
                $("#expiration_date"+$index).removeAttr('disabled');
                $scope.products[pos].check_date_expiration = true;
                $timeout(function () {
                    dateExpiration(product);
                }, 100);
            }
            else{
                $("#expiration_date"+$index).attr('disabled', 'disabled');
                $scope.products[pos].check_date_expiration = false;
            }
        }

        $scope.change_is_igv = function (is_igv_, product, $index) {
            var igv = 0;
            var index = $scope.products.indexOf(product);
            var subtotal = (Number(product.quantity) * Number(product.price)).toFixed(2);

            if(is_igv_ == true){
                igv = ((product.subtotal * $scope.igv) / 100).toFixed(2);

            }

            var total = Number(subtotal) + Number(igv);

            $scope.products[index].is_igv = is_igv_;
            $scope.products[index].igv = igv;
            $scope.products[index].total = total;

            $timeout(function () {
                sum_items();
            }, 300);
        }

        $scope.removeItem = function ($event, product, $index) {
            $event.preventDefault();
            var index = $scope.products.indexOf(product);
            $scope.products.splice(index, 1)
            $timeout(function () {
                sum_items();
            }, 300);
            notifyAlert.info("El producto " + product.description + ' ha sido removido del detalle');
        };

        $scope.selectedProduct = function (response) {
            if (!_.isUndefined(response)) {
                var item = response.originalObject;
                var unique = ifExistProduct(item);

                if (unique) {
                    item.unit_id = 0;
                    item.quantity = null;
                    item.price = null;
                    item.subtotal = 0;
                    item.igv = null;
                    item.total = 0;
                    item.is_igv = false;

                    item.check_date_expiration = false;
                    if(item.is_control_expiration){
                        item.check_date_expiration = true;
                    }

                    if($scope.purchase.is_igv){
                        var igv = ((item.subtotal * $scope.igv) / 100).toFixed(2);
                        var total = Number(item.subtotal) + Number(igv);

                        item.igv = igv;
                        item.total = total;
                        item.is_igv = true;
                    }

                    $scope.products.push(item);

                    $timeout(function () {
                        sum_items();
                    }, 300);

                    var last = $scope.products.length;
                    $timeout(function () {
                        angular.element(document.querySelector('#quantity' + Number(last - 1))).focus();
                        listUnitMeasureProduct(last, item);
                        // set expiration date
                        dateExpiration(item);

                    }, 50);
                    $scope.$broadcast('angucomplete-alt:clearInput', 'search_product');
                }
                else {
                    notifyAlert.warning('El producto ' + item.description + ' ya se encuentra agregado');
                }
            }
        }

        function dateExpiration(item) {
            var index = $scope.products.indexOf(item);
            $scope.products[index].date_expiration = null;
            $('#expiration_date'+index).daterangepicker({
                singleDatePicker: true,
                autoUpdateInput: false,
                showDropdowns: true,
                minDate: new Date(),
                locale: {
                    format: 'YYYY-MM-DD'
                }
            }, function (chosen_date) {
                $(this.element[0]).val(chosen_date.format('YYYY-MM-DD'));
                var check_index = $scope.products.indexOf(item);
                $scope.products[check_index].date_expiration = chosen_date.format('YYYY-MM-DD');
            });

        };

        function listUnitMeasureProduct(pos, product) {
            var index = pos - 1;
            var units = product.unitsmeasure;

            $("#unitSelected" + index).html('');
            $.each(units, function (i, item) {
                $("#unitSelected" + index).append($('<option>', {
                    value: item.id,
                    text : item.description + ' ('+item.equivalence+')'
                }));
            });

            $("#unitSelected" + index).val(units[0].id);
            // $("#unitSelected" + index).attr('disabled', 'disabled');

            var pos = $scope.products.indexOf(product);
            $scope.products[pos].unit_id = units[0].id;
        }

        function ifExistProduct(obj) {
            var cart = $scope.products;
            var is_unique = true;
            for (var key in cart) {
                if (cart[key].id === Number(obj.id)) {
                    is_unique = false;
                    break;
                }
            }
            return is_unique;
        }

        $scope.click_input_quantity = function (msg, $event) {
            var el = event.target;
            el.select();
        };

        $scope.click_input_price = function (msg, $event) {
            var el = event.target;
            el.select();
        };

        $scope.click_input_igv = function (msg, $event) {
            var el = event.target;
            el.select();
        };

        $scope.selectedProvider = function (response) {
            if (!_.isUndefined(response)) {
                var data = response.originalObject;
                $scope.provider = data.id;
                angular.element(document.querySelector('#search_provider_value')).attr('disabled', 'disabled');
            }
        };

        $scope.removeProvider = function () {
            angular.element(document.querySelector('#search_provider_value')).removeAttr('disabled').focus();
            $scope.provider = null;
            $scope.$broadcast('angucomplete-alt:clearInput', 'search_provider');
        };

        function sum_items() {
            $scope.subtotal = 0;
            $scope.total_igv = 0;
            $scope.total_purchase = 0;
            for (var i in $scope.products) {
                var item = $scope.products[i];
                $scope.subtotal = (Number($scope.subtotal) + Number(item.price) * Number(item.quantity)).toFixed(2);
                $scope.total_igv = (Number($scope.total_igv) + Number(item.igv)).toFixed(2);
            }

            $scope.total_purchase = (Number($scope.subtotal) + Number($scope.total_igv)).toFixed(2);
            $scope.text_amount = numero.letras($scope.total_order);
        }

        $scope.changePayment = function (item) {
            $scope.paymentSelected = item;
            if(item.id == $scope.paymethod_deposit.id){
                RESTService.all('accountbanks/search/all', null, function (response) {
                    $scope.bankaccounts = response.results;
                    $scope.bankaccounts_exists = false;
                    if($scope.bankaccounts.length>0){
                        $scope.bankaccounts_exists = true;
                        $scope.bankAccountSelected = response.results[0];
                    }
                });
            }
        };


        $scope.save = function () {
            if (validate()) {

                var data = {};
                $scope.purchase['provider_id'] = $scope.provider;
                $scope.purchase['warehouse_id'] = $scope.warehousesSelected.id;
                $scope.purchase['typetransaction_id'] = $scope.transactionSelected.id;
                $scope.purchase['currency_id'] = $scope.currencySelected.id;
                $scope.purchase['typevoucher_id'] = $scope.typeVoucherSelected.id;
                $scope.purchase['igv'] = $scope.total_igv;
                $scope.purchase['subtotal'] = $scope.subtotal;
                $scope.purchase['total'] = $scope.total_purchase;

                $scope.purchase['paymentmethod_id'] = $scope.paymentSelected.id;

                var accountbank_id = null;
                if($scope.bankaccounts.length > 0){
                    if($scope.paymentSelected.id == $scope.paymethod_deposit.id){
                        accountbank_id = $scope.bankAccountSelected.id;
                    }
                };

                $scope.purchase['accountbank_id'] = accountbank_id ;

                data.purchase = $scope.purchase;
                data.detail = $scope.products;

                var options = {
                    title: "¡Atención!",
                    message: "¿Esta seguro(a) de confirmar la compra?",
                    cancel: "Cancelar",
                    confirm: "Confirmar"
                };

                if($scope.transactionSelected.id == $scope.sale_credit.id){
                    options.message = "¿Esta seguro(a) de confirmar la compra al crédito?";
                    $scope.schedule['interval_schedule'] = $scope.intervalDateSelected.id;

                    data.schedule = $scope.schedule;
                }


                AlertFactory.confirmWarning(options, function () {
                    if ($scope.action == 'create') {
                        RESTService.save('purchases/save', data, function (result) {
                            notifyAlert.success("Registro realizado con éxito!!");
                            $state.transitionTo('purchase.purchases', null, {'reload': true});
                        }, function (error) {
                            console.log('ERROR');
                            return false;
                        });
                    }
                    else if ($scope.action == 'edit') {
                        RESTService.updated('purchases/update', $scope.provider.id, $scope.provider, function (result) {
                            notifyAlert.success("Registro actualizado con éxito!!");
                            $state.transitionTo('purchase.purchases', null, {'reload': true});
                        }, function (error) {
                            console.log('ERROR');
                            return false;
                        });
                    }
                });


                // var obj = {'data': data};
                //
                // $uibModal.open({
                //     animation: true,
                //     templateUrl: '../../templates/purchase/purchases/confirmpurchase.html',
                //     controller: 'ExtendConfirmPurchaseCtrl',
                //     size: 'modal-dialog modal-dialog-centered modal-sm',
                //     backdrop: 'static',
                //     appendTo: angular.element(document.querySelector('#wrapper')),
                //     resolve: {
                //         PARAM: function () {
                //             return obj;
                //         }
                //     }
                // }).result.then(function (result) {
                //
                // });
            }
        };

        function validate() {
            if (_.isNull($scope.provider) || _.isUndefined($scope.provider)) {
                HelperFactory.show_AlertFactory('Debe seleccionar el proveedor');
                angular.element(document.querySelector('#search_provider_value')).focus();
                return false;
            }
            if (_.isUndefined($scope.purchase.date_purchase) || _.isNull($scope.purchase.date_purchase)) {
                HelperFactory.show_AlertFactory('Debe seleccionar la fecha de la compra');
                angular.element(document.querySelector('#date_purchase')).focus();
                return false;
            }

            if (_.isUndefined($scope.purchase.nro_voucher) || _.isNull($scope.purchase.nro_voucher)) {
                HelperFactory.show_AlertFactory('Debe ingresar el número de comprobante');
                angular.element(document.querySelector('#nro_voucher')).focus();
                return false;
            }

            if (_.isUndefined($scope.purchase.exchange_currency) || _.isNull($scope.purchase.exchange_currency)) {
                HelperFactory.show_AlertFactory('Debe ingresar el tipo de cambio de moneda');
                angular.element(document.querySelector('#exchange_currency')).focus();
                return false;
            }

            if ($scope.products.length === 0) {
                HelperFactory.show_AlertFactory('Debe ingresar por lo menos un producto al detalle de la compra');
                angular.element(document.querySelector('#search_product_value')).focus();
                return false;
            }

            // check quantity
            for (var i in $scope.products) {
                if (Number($scope.products[i].quantity) == 0 || _.isNull($scope.products[i].quantity)) {
                    HelperFactory.show_AlertFactory('La cantidad del producto ' + $scope.products[i].description + ' no puede ser igual a cero o estar vacío.');
                    angular.element(document.querySelector('#quantity' + i)).focus();
                    return false;
                }
            }

            // check price
            for (var i in $scope.products) {
                // if (Number($scope.products[i].price) == 0 || _.isNull($scope.products[i].price)) {
                //     HelperFactory.show_AlertFactory('El precio del producto ' + $scope.products[i].description + ' no puede ser igual a cero o estar vacío.');
                //     angular.element(document.querySelector('#price' + i)).focus();
                //     return false;
                // }

                if (_.isNull($scope.products[i].price)) {
                    HelperFactory.show_AlertFactory('El precio del producto ' + $scope.products[i].description + ' no puede estar vacío.');
                    angular.element(document.querySelector('#price' + i)).focus();
                    return false;
                }
            }

            return true;
        };


        $scope.addProvider = function (actionCreate) {
            var obj = {'id': 0};

            if (!actionCreate){
                obj = {
                    'id': 0,
                    entity: 'lol'
                };
            }

            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/purchase/providers/extends.html',
                controller: 'ExtendProviderCtrl',
                size: 'lg',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                if (!_.isUndefined(result)) {
                    var data = result.data;
                    $scope.provider = data.id;
                    $timeout(function () {
                        angular.element(document.querySelector('#search_provider_value')).val(data.fullname);
                        angular.element(document.querySelector('#search_provider_value')).attr('disabled', 'disabled');
                    }, 50);
                }
            });
        };

        $scope.addProduct = function (actionCreate) {
            var obj = {'id': 0};
            if (!actionCreate){
                obj = {
                    'id': 0,
                    entity: null
                };
            }
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/catalog/product/extends.html',
                controller: 'ExtendCatalogProductCtrl',
                size: 'lg',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                if (!_.isUndefined(result)) {
                    var response = {};
                    response.originalObject = result.data;
                    $scope.selectedProduct(response);
                }
            });
        };


        $scope.addAccountBank = function (actionCreate) {
            var obj = {'id': 0};
            if (!actionCreate){
                obj = {
                    'id': 0,
                    entity: null
                };
            }
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/finance/accountbank/extends.html',
                controller: 'ExtendAccountBankCtrl',
                size: 'md',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                if (!_.isUndefined(result)) {
                    var data = result.data;
                    $scope.bankaccounts.push(data);
                    $scope.bankAccountSelected = data;
                    $scope.bankaccounts_exists = true;
                }
            });
        };

        $scope.close = function () {
            $state.transitionTo('purchase.purchases', null, {'reload': true});
        };
    }
})();
