(function () {
    'use strict';
    angular.module('sys.app.purchases')
        .controller('PurchasesCtrl', PurchasesCtrl);

    PurchasesCtrl.$inject = ['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory','$timeout', 'notifyAlert', 'SEARCH', '$uibModal'];

    function PurchasesCtrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $timeout, notifyAlert, SEARCH, $uibModal) {

        $scope.entity = {};
        $scope.text= null;
        $scope.currentPage = 1;
        var object = "";

        var start_range = moment().startOf('month');
        var end_range = moment().endOf('month');

        $scope.start_range = start_range;
        $scope.end_range = end_range;

        init();

        sync();

        function init() {
            object = "search=" + $scope.text + '&page=' + $scope.currentPage+
                "&start_range=" + $scope.start_range.format('YYYY-MM-DD') + '&end_range=' + $scope.end_range.format('YYYY-MM-DD');
            RESTService.all('purchases/list', object, function (response) {

                $scope.allData = response.results;
                $scope.totalItems = response.total;
                $scope.itemsPerPage = response.paginate_by;

            }, function (error) {
                console.log('ERROR');
                return false;
            });
        }

        function sync() {
            RESTService.all('config/typevoucher/purchase', null, function (response) {
                var last = response.results.length;
                $scope.typevouchers = response.results;
                response.results[last] = {id: null, description: 'TODOS', value: null};
                $scope.typeVoucherSelected = response.results[last];
            });

            $timeout(function () {
                $('#date_range').daterangepicker({
                        locale: {
                            format: 'MMM D, YYYY'
                        },
                        startDate: $scope.start_range,
                        endDate: $scope.end_range,
                        showDropdowns: true,
                    },
                    function (start, end, label) {
                        $scope.start_range = start;
                        $scope.end_range = end;
                        init();
                    }
                );
            }, 50);

        };


        $scope.searchAction = function (text) {
            $scope.text = text;
            $scope.currentPage = 1;
            if (text.length >= SEARCH.MIN_LETTERS || text.length == 0) {
                delete $scope.allData;
                init();
            }
        };

        $scope.refresh = function () {
            delete $scope.allData;
            $state.transitionTo('purchase.purchases', {entity: null}, {'reload': true});
        };

        $scope.export = function (item) {
            var obj = {
                'start_range': $scope.start_range,
                'end_range': $scope.end_range,
                'typevouchers': $scope.typevouchers,
            };
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/purchase/purchases/export.html',
                controller: 'ExportPurchaseCtrl',
                size: 'modal-dialog',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                init();
            });
        };

        $scope.detail = function (source) {
            delete $scope.allData;
            RESTService.get('purchases/detail', source.id, function (response) {
                $state.transitionTo("purchase.purchases.detail", {
                    'id': source.id,
                    entity: response.data
                }, {'reload': "purchase.purchases.detail", 'cache': false});
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };

        $scope.new = function () {
            var source = {'purchase': {'id':0 }};

            $state.transitionTo('purchase.purchases.new', {entity: source}, {
                'reload': 'purchase.purchases.new',
                'cache': false
            });
            delete $scope.allData;
        };

        $scope.edit = function (source) {
            delete $scope.allData;
            RESTService.get('purchases/edit', source.id, function (response) {
                $state.transitionTo("purchase.purchases.edit", {
                    'id': source.id,
                    entity: response.data
                }, {'reload': "purchase.purchases.edit", 'cache': false});
            }, function (error) {
                console.log('ERROR');
                return false;
            });

        };

        $scope.pageChanged = function(page) {
            $scope.currentPage = page;
            delete $scope.allData;
            // console.log('Page changed to: ' + $scope.currentPage);
            init();
        };

        $scope.delete = function (item) {
            var options = {
                title: "Cuidado!!",
                message: "El registro ' "+item.description+" ' será eliminado",
                cancel: "Cancelar",
                confirm: "Eliminar"
            };
            AlertFactory.confirm(options, function () {
                RESTService.deleted('purchases/delete', item.id, function (response) {
                    notifyAlert.success("El item se ha eliminado con éxito!!");
                    var obj = {"text": $scope.text};
                    $state.transitionTo('purchase.purchases', {entity: obj}, {'reload': true});
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });

            })

        };


    }
})();



