(function () {
    'use strict';
    angular.module('sys.app.raccounting')
        .controller('ReportAccountingCtrl', ReportAccountingCtrl);

    ReportAccountingCtrl.$inject = ['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory', '$http', '$timeout', 'notifyAlert', 'SEARCH', '$uibModal', 'REPORT', 'EXPORT'];

    function ReportAccountingCtrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $http, $timeout, notifyAlert, SEARCH, $uibModal, REPORT, EXPORT) {

        var start_range = moment().startOf('month');
        var end_range = moment().endOf('month');

        $scope.start_range = start_range;
        $scope.end_range = end_range;

        var object = "";

        $scope.currentPage = 1;
        $scope.warehousesSelected = {
            'id':1
        };

        $scope.text= null;


        init();

        function init() {
            $scope.limits = REPORT.LIMIT;
            $scope.limitSelected = REPORT.LIMIT[0];

            $scope.formats = EXPORT.FORMAT;
            $scope.formatSelected = EXPORT.FORMAT[0];

            // status voucher
            $scope.statusvoucher = EXPORT.STATUS_VOUCHER;
            $scope.statusSelected = EXPORT.STATUS_VOUCHER[0];

            RESTService.all('branch/branchoffices', null, function (response) {
                $scope.branchoffices = response.results;
                $scope.branchSelected = response.results[0];
            });

            $scope.year_selected = moment().format('YYYY');

            $timeout(function () {
                $('#year_selected').datetimepicker({
                    format: "YYYY",
                    viewMode: "years",
                });

                $('#date_range').daterangepicker({
                        locale: {
                            format: 'MMM D, YYYY'
                        },
                        startDate: $scope.start_range,
                        endDate: $scope.end_range,
                        showDropdowns: true,
                    },
                    function (start, end, label) {
                        $scope.start_range = start;
                        $scope.end_range = end;
                    }
                );

            }, 100);
        };

        $scope.changeFormatExport = function (item) {
            $scope.formatSelected = item;
        };

        $scope.changeTypeVoucher = function (item) {
            $scope.typeVoucherSelected = item;

            getSerieVoucher($scope.typeVoucherSelected.id);
        };

        $scope.changeSerieVoucher = function (item) {
            $scope.serieSelected = item;
        };

        $scope.changeLimitselected = function (item) {
            $scope.limitSelected = item;
        };

        $scope.changeStatusVoucher = function (item) {
            $scope.statusSelected = item;
        };

        $scope.toMerchandiseValuation = function () {
            $scope.filter_value = "merchandise_valuation";
            resetFilters();

            $timeout(function () {
                $("#filter_branchoffice").show();
                merchandiseValuation();
            }, 100);
        };

        function merchandiseValuation() {

            object = "branchoffice=" + $scope.branchSelected.id;

            RESTService.all('raccounting/merchandise_valuation', object, function (response) {

                $scope.total_merchandise = 0;
                $scope.average_movements = response.movement_average_product;
                $scope.average_purchases = response.purchase_average_product;
                $scope.stock_products = response.stock_products;

                var sum_total = 0;

                $.each(response.stock_products, function (i, item) {

                    var item_1 = $scope.average_movements[i];
                    var item_2 = $scope.average_purchases[i];
                    var divider = 0;
                    var sum = 0;

                    if(!_.isUndefined(item_1)){
                        sum = sum + Number(item_1.total_merchandise);
                        divider = divider + 1;
                    }

                    if(!_.isUndefined(item_2)){
                        sum = sum + Number(item_2.total_merchandise);
                        divider = divider + 1;
                    }

                    sum_total = sum_total + (sum/divider);
                });

                $scope.total_merchandise = sum_total;
            });
        };

        $scope.toSaleByVoucher = function () {
            $scope.filter_value = "sale_by_vouchers";
            resetFilters();
            $timeout(function () {
                // $("#filter_btn").hide();
                $("#filter_branchoffice").show();
                $("#filter_range_date").show();
                $("#filter_export").show();
                saleByVouchers();
            }, 100);
        };

        function saleByVouchers(is_export) {
            object = "branchoffice=" + $scope.branchSelected.id + '&limit='
                +"&start_range=" + $scope.start_range.format('YYYY-MM-DD') + '&end_range=' + $scope.end_range.format('YYYY-MM-DD');

            if(is_export == true){
                object = object + '&format='+$scope.formatSelected.id;
                window.open('api/raccounting/sale_by_vouchers/export?' + object);
            }
            else{
                RESTService.all('raccounting/sale_by_vouchers', object, function (response) {
                    $scope.summary_vouchers = response.results;
                });
            }
        };

        $scope.printValueKardex = function (option="pdf") {
            valueKardex(option);
        };

        $scope.toValueKardex = function () {
            $scope.filter_value = "value_kardex";
            resetFilters();
            $timeout(function () {
                $("#filter_btn").hide();
            }, 100);
        };

        function valueKardex(option) {

            // object = "start_range=" + $scope.start_range.format('YYYY-MM-DD') + '&end_range=' + $scope.end_range.format('YYYY-MM-DD') + '&format='
            //     + $scope.formatSelected.id + '&voucher=' + $scope.typeVoucherSelected.id + '&status=' + $scope.statusSelected.id;
            if(option === "pdf"){
                window.open('/api/raccounting/valued_kardex?' + object);
            }else
            {
                console.log("excel format");
                console.log(object);

                window.open('/api/raccounting/valued_kardex?' + object);
            }
        };

        $scope.toListVoucher = function () {
            $scope.filter_value = "list_vouchers";
            resetFilters();
            $timeout(function () {
                $("#filter_branchoffice").show();
                $("#filter_range_date").show();
                $("#filter_search").show();
                $("#filter_typevoucher").show();
                $("#filter_statusvoucher").show();
                $("#filter_export").show();

                RESTService.all('config/typevoucher/sale', null, function (response) {
                    var last = response.results.length;
                    $scope.typevouchers = response.results;
                    response.results[last] = {id: 0, description: 'TODOS', value: null};
                    $scope.typeVoucherSelected = response.results[last];
                    listVouchers();
                });

                // set default value series
                $scope.series = [];
                var last = $scope.series.length;
                $scope.series[last] = {id: 0, series: 'TODOS', value: null};
                $timeout(function () {
                    $scope.serieSelected = $scope.series[last];
                }, 100);

            }, 100);
        }
        function listVouchers(is_export) {
            var serie_val = null;

            if($scope.serieSelected.id != 0){
                serie_val = $scope.serieSelected.series;
            }

            object = "search=" + $scope.text + '&page=' + $scope.currentPage +"&branchoffice=" + $scope.branchSelected.id
                +"&start_range=" + $scope.start_range.format('YYYY-MM-DD') + '&end_range=' + $scope.end_range.format('YYYY-MM-DD')
                +'&voucher=' + $scope.typeVoucherSelected.id
                +'&serie=' + serie_val + '&status=' + $scope.statusSelected.id;

            if(is_export == true){
                object = object + '&format='+$scope.formatSelected.id;
                window.open('api/raccounting/list_vouchers/export?' + object);
            }
            else{
                RESTService.all('raccounting/list_vouchers', object, function (response) {
                    $scope.allData = response.results;
                    $scope.totalItems = response.total;
                    $scope.itemsPerPage = response.paginate_by;
                });
            }
        };
        function getSerieVoucher(voucher_id) {
            RESTService.get('config/voucher/serie', voucher_id, function (response) {
                var last = response.results.length;
                $scope.series = response.results;
                response.results[last] = {id: 0, series: 'TODOS', value: null};
                $timeout(function () {
                    $scope.serieSelected = response.results[last];
                }, 100);
            });
        };

        // list vouchers detail
        $scope.toListVouchersDetail = function () {
            $scope.filter_value = "list_vouchers_detail";
            resetFilters();
            $timeout(function () {
                $("#filter_branchoffice").show();
                $("#filter_range_date").show();
                // $("#filter_search").show();
                // $("#filter_typevoucher").show();
                // $("#filter_statusvoucher").show();
                $("#filter_export").show();

                RESTService.all('config/typevoucher/sale', null, function (response) {
                    var last = response.results.length;
                    $scope.typevouchers = response.results;
                    response.results[last] = {id: 0, description: 'TODOS', value: null};
                    $scope.typeVoucherSelected = response.results[last];
                    listVouchersDetail();
                });

                // set default value series
                $scope.series = [];
                var last = $scope.series.length;
                $scope.series[last] = {id: 0, series: 'TODOS', value: null};
                $timeout(function () {
                    $scope.serieSelected = $scope.series[last];
                }, 100);

            }, 100);
        }
        function listVouchersDetail(is_export) {
            var serie_val = null;

            if($scope.serieSelected.id !== 0){
                serie_val = $scope.serieSelected.series;
            }

            object = "search=" + $scope.text + '&page=' + $scope.currentPage +"&branchoffice=" + $scope.branchSelected.id
                +"&start_range=" + $scope.start_range.format('YYYY-MM-DD') + '&end_range=' + $scope.end_range.format('YYYY-MM-DD')
                +'&voucher=' + $scope.typeVoucherSelected.id
                +'&serie=' + serie_val + '&status=' + $scope.statusSelected.id;

            if(is_export == true){
                object = object + '&format='+$scope.formatSelected.id;
                window.open('api/raccounting/list_vouchers_detail/export?' + object);
            }
            else{
                RESTService.all('raccounting/list_vouchers_detail', object, function (response) {
                    $scope.allData = response.results;
                    $scope.totalItems = response.total;
                    $scope.itemsPerPage = response.paginate_by;
                });
            }
        };


        // =================

        $scope.filter = function () {
            preLoadView();
        };

        $scope.export = function () {
            preLoadView(true);
        };

        $scope.pageChanged = function(page) {
            $scope.currentPage = page;
            delete $scope.allData;
            preLoadView();
        };

        $scope.searchAction = function (text) {
            $scope.text = text;
            $scope.currentPage = 1;
            if (text.length >= SEARCH.MIN_LETTERS || text.length == 0) {
                delete $scope.allData;
                preLoadView();
            }
        };


        $scope.cleanSearch = function () {
            $timeout(function () {
                $scope.text = null;
                $scope.searchInput = null;
                angular.element(document.querySelector('#searchInput')).val('');
                angular.element(document.querySelector('#searchInput')).focus();
                preLoadView();

            }, 50);
        };


        $scope.refresh = function () {
            resetFilters();
            if($scope.filter_value === "merchandise_valuation"){
                $scope.toMerchandiseValuation();
            }
            else if($scope.filter_value === "value_kardex"){
                $scope.toValueKardex();
            }
            else if($scope.filter_value === "sale_by_vouchers"){
                $scope.toSaleByVoucher();
            }
            else if($scope.filter_value === "list_vouchers"){
                $scope.toListVoucher();
            }
            else if($scope.filter_value === "list_vouchers_detail"){
                $scope.toListVouchersDetail();
            } else {
                $scope.toSaleByVoucher();
            }
        };

        function preLoadView(verify_export) {
            var verify = false;
            if(verify_export){
                verify = true;
            }

            if($scope.filter_value === "merchandise_valuation"){
                merchandiseValuation(verify);
            }
            else if($scope.filter_value === "value_kardex"){
                valueKardex(verify);
            }
            else if($scope.filter_value === "sale_by_vouchers"){
                saleByVouchers(verify);
            }
            else if($scope.filter_value === "list_vouchers"){
                listVouchers(verify);
            }
            else if($scope.filter_value === "list_vouchers_detail"){
                listVouchersDetail(verify);
            }
            else{
                merchandiseValuation(verify);
            }
        };


        function resetFilters() {

            $("#report_empty").hide();

            $scope.currentPage = 1;
            $scope.text = null;
            $scope.searchInput = null;
            angular.element(document.querySelector('#searchInput')).val('');

            $scope.branchSelected = $scope.branchoffices[0];

            $('#formatSelected').prop('selectedIndex',0);
            $scope.formatSelected = EXPORT.FORMAT[0];
            $scope.statusSelected = EXPORT.STATUS_VOUCHER[0];

            $scope.start_range = start_range;
            $scope.end_range = end_range;

            $('#date_range').daterangepicker({
                    locale: {
                        format: 'MMM D, YYYY'
                    },
                    startDate: $scope.start_range,
                    endDate: $scope.end_range,
                    showDropdowns: true,
                },
                function (start, end, label) {
                    $scope.start_range = start;
                    $scope.end_range = end;
                }
            );

            $scope.year_selected = $scope.year_selected = moment().format('YYYY');
            $("#year_selected").val(moment().format('YYYY'));

            // hide filters
            $("#filter_branchoffice").hide();
            $("#filter_year").hide();
            $("#filter_limit").hide();
            $("#filter_range_date").hide();
            $("#filter_search").hide();
            $("#filter_typevoucher").hide();
            $("#filter_statusvoucher").hide();
            $("#filter_seriesvoucher").hide();
            $("#filter_export").hide();

            $("#filter_btn").show();
        };
    };

})();

