(function () {
    'use strict';
    angular.module('sys.app.rcatalog')
        .controller('ReportCatalogCtrl', ReportCatalogCtrl);

    ReportCatalogCtrl.$inject = ['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory', '$http', '$timeout', 'notifyAlert', 'SEARCH', '$uibModal', 'REPORT', 'EXPORT', 'HelperFactory'];

    function ReportCatalogCtrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $http, $timeout, notifyAlert, SEARCH, $uibModal, REPORT, EXPORT, HelperFactory) {

        var start_range = moment().startOf('month');
        var end_range = moment().endOf('month');

        $scope.start_range = start_range;
        $scope.end_range = end_range;

        var object = "";

        $scope.currentPage = 1;
        $scope.warehousesSelected = {
            'id': 1
        };

        $scope.text = null;
        $scope.stock_min = null;
        $scope.product = null;


        init();

        function init() {
            $scope.limits = REPORT.LIMIT;
            $scope.limitSelected = REPORT.LIMIT[0];

            $scope.formats = EXPORT.FORMAT;
            $scope.formatSelected = EXPORT.FORMAT[0];

            RESTService.all('branch/branchoffices', null, function (response) {
                $scope.branchoffices = response.results;
                $scope.branchSelected = response.results[0];
            });


            loadWarehouses();

            $scope.year_selected = moment().format('YYYY');

            $timeout(function () {
                $('#year_selected').datetimepicker({
                    format: "YYYY",
                    viewMode: "years",
                });

                $('#date_range').daterangepicker({
                    locale: {
                        format: 'MMM D, YYYY'
                    },
                    startDate: $scope.start_range,
                    endDate: $scope.end_range,
                    showDropdowns: true,
                },
                    function (start, end, label) {
                        $scope.start_range = start;
                        $scope.end_range = end;
                    }
                );
            }, 100);
        };

        function loadWarehouses() {
            RESTService.all('warehouses/branchoffice', null, function (response) {
                $scope.warehouses = response.results;
                $scope.warehousesSelected = response.results[0];
            });
        }

        $scope.changeFormatExport = function (item) {
            $scope.formatSelected = item;
        };

        $scope.changeStockMin = function (val) {
            $scope.stock_min = val;
        };

        $scope.changeLimitselected = function (limit) {
            $scope.limitSelected = limit;
        };

        $scope.selectedProduct = function (response) {
            if (!_.isUndefined(response)) {
                var data = response.originalObject;
                $scope.product = data.id;
                $scope.product_data = data;
                angular.element(document.querySelector('#search_product_value')).attr('disabled', 'disabled');
            }
        };

        $scope.removeProduct = function () {
            angular.element(document.querySelector('#search_product_value')).removeAttr('disabled').focus();
            angular.element(document.querySelector('#search_product_value')).val('');
            $scope.employee = null;
            $scope.$broadcast('angucomplete-alt:clearInput', 'search_product');
        };


        function loadProductParams() {
            loadWarehouses();
            
            RESTService.all('brand/search/all', null, function (response) {
                $scope.brands = response.results;
                $scope.brand_exists = false;
                if ($scope.brands.length > 0) {
                    $scope.brand_exists = true;
                }

                $('#brandSelected').select2();
                var last = $scope.brands.length;
                $scope.brands[last] = { id: 0, description: 'TODOS', value: null };
                $.each($scope.brands, function (i, item) {
                    $("#brandSelected").append($('<option>', {
                        value: item.id,
                        text: item.description
                    }));
                });
                $("#brandSelected").val($scope.brands[last].id);

            });

            RESTService.all('category/search/all', null, function (response) {
                $scope.categories = response.results;
                $scope.category_exists = false;
                if ($scope.categories.length > 0) {
                    $scope.category_exists = true;
                }

                $('#categorySelected').select2();
                var last = $scope.categories.length;
                $scope.categories[last] = { id: 0, description: 'TODOS', value: null };
                $.each($scope.categories, function (i, item) {
                    $("#categorySelected").append($('<option>', {
                        value: item.id,
                        text: item.description
                    }));
                });
                $("#categorySelected").val($scope.categories[last].id);

            });

            RESTService.all('line/search/all', null, function (response) {
                $scope.lines = response.results;
                $scope.line_exists = false;
                if ($scope.lines.length > 0) {
                    $scope.line_exists = true;
                }

                $('#lineSelected').select2();
                var last = $scope.lines.length;
                $scope.lines[last] = { id: 0, description: 'TODOS', value: null };
                $.each($scope.lines, function (i, item) {
                    $("#lineSelected").append($('<option>', {
                        value: item.id,
                        text: item.description
                    }));
                });
                $("#lineSelected").val($scope.lines[last].id);
            });
        };

        $scope.toCatalogProducts = function () {
            $scope.filter_value = "catalog_products";
            resetFilters();
            loadProductParams();
            $timeout(function () {
                $("#filter_search").show();
                $("#filter_export").show();
                $("#filter_catalog_brand").show();
                $("#filter_catalog_line").show();
                $("#filter_catalog_category").show();
                catalogProducts();
            }, 100);
        };

        $scope.toCatalogProductsBarcode = function () {
            $scope.filter_value = "catalog_products_barcode";
            resetFilters();
            $timeout(function () {
                $("#filter_btn").hide();
                $scope.product = null;
                angular.element(document.querySelector('#search_product_value')).focus();
            }, 100);
        };

        $scope.generateBarcode = function () {
            if (validateProductBarcode()) {
                window.open('/print/products/barcode/' + $scope.product + '/' + $("#numberLineBarcode").val());
            }
        }

        function validateProductBarcode() {

            if (_.isNull($scope.product)) {
                HelperFactory.show_AlertFactory('Debe seleccionar un producto.');
                angular.element(document.querySelector('#search_product_value')).focus();
                return false;
            }

            return true;
        }


        function catalogProducts(is_export) {
            object = "search=" + $scope.text + '&page=' + $scope.currentPage + "&brand=" + $("#brandSelected").val() + "&line=" + $("#lineSelected").val();

            if (is_export === true) {
                object = object + '&format=' + $scope.formatSelected.id;
                window.open('api/rcatalog/catalog_products/export?' + object);
            }
            else {
                RESTService.all('rcatalog/catalog_products', object, function (response) {
                    $scope.allData = response.results;
                    $scope.totalItems = response.total;
                    $scope.itemsPerPage = response.paginate_by;

                });
            }
        };

        $scope.toCatalogServices = function () {
            $scope.filter_value = "catalog_services";
            resetFilters();
            $timeout(function () {
                $("#filter_search").show();
                $("#filter_export").show();
                $("#filter_btn").hide();
                catalogServices();
            }, 100);
        };

        function catalogServices(is_export) {
            object = "search=" + $scope.text + '&page=' + $scope.currentPage;

            if (is_export == true) {
                object = object + '&format=' + $scope.formatSelected.id;
                window.open('api/rcatalog/catalog_services/export?' + object);
            }
            else {
                RESTService.all('rcatalog/catalog_services', object, function (response) {
                    $scope.allData = response.results;
                    $scope.totalItems = response.total;
                    $scope.itemsPerPage = response.paginate_by;

                });
            }
        };

        // catalog categories
        $scope.toCatalogCategories = function () {
            $scope.filter_value = "catalog_categories";
            resetFilters();
            $timeout(function () {
                $("#filter_search").show();
                $("#filter_export").show();
                $("#filter_btn").hide();
                catalogCategories();
            }, 100);
        };
        function catalogCategories(is_export) {
            object = "search=" + $scope.text + '&page=' + $scope.currentPage;
            if (is_export == true) {
                object = object + '&format=' + $scope.formatSelected.id;
                window.open('api/rcatalog/catalog_categories/export?' + object);
            }
            else {
                RESTService.all('rcatalog/catalog_categories', object, function (response) {
                    $scope.allData = response.results;
                    $scope.totalItems = response.total;
                    $scope.itemsPerPage = response.paginate_by;
                });
            }
        };

        // catalog lines
        $scope.toCatalogLines = function () {
            $scope.filter_value = "catalog_lines";
            resetFilters();
            $timeout(function () {
                $("#filter_search").show();
                $("#filter_export").show();
                $("#filter_btn").hide();
                catalogLines();
            }, 100);
        };
        function catalogLines(is_export) {
            object = "search=" + $scope.text + '&page=' + $scope.currentPage;
            if (is_export == true) {
                object = object + '&format=' + $scope.formatSelected.id;
                window.open('api/rcatalog/catalog_lines/export?' + object);
            }
            else {
                RESTService.all('rcatalog/catalog_lines', object, function (response) {
                    $scope.allData = response.results;
                    $scope.totalItems = response.total;
                    $scope.itemsPerPage = response.paginate_by;
                });
            }
        };

        // catalog brands
        $scope.toCatalogBrands = function () {
            $scope.filter_value = "catalog_brands";
            resetFilters();
            $timeout(function () {
                $("#filter_search").show();
                $("#filter_export").show();
                $("#filter_btn").hide();
                catalogBrands();
            }, 100);
        };

        function catalogBrands(is_export) {
            object = "search=" + $scope.text + '&page=' + $scope.currentPage;
            if (is_export === true) {
                object = object + '&format=' + $scope.formatSelected.id;
                window.open('api/rcatalog/catalog_brands/export?' + object);
            }
            else {
                RESTService.all('rcatalog/catalog_brands', object, function (response) {
                    $scope.allData = response.results;
                    $scope.totalItems = response.total;
                    $scope.itemsPerPage = response.paginate_by;
                });
            }
        };


        $scope.toStockProduct = function () {
            $scope.filter_value = "product_stock";
            resetFilters();
            loadProductParams();
            $timeout(function () {
                $("#filter_search").show();
                $("#filter_export").show();
                $("#filter_warehouse").show();
                $("#filter_stock_min").show();
                $("#filter_catalog_brand").show();
                $("#filter_catalog_line").show();

                stockProduct();
            }, 100);
        };

        function stockProduct(is_export) {

            object = "search=" + $scope.text + '&page=' + $scope.currentPage + '&warehouse=' + $scope.warehousesSelected.id
                + "&stock_min=" + $scope.stock_min + "&brand=" + $("#brandSelected").val() + "&line=" + $("#lineSelected").val();

            if (is_export === true) {
                object = object + '&format=' + $scope.formatSelected.id;
                window.open('api/rcatalog/product_stock/export?' + object);
            }
            else {
                RESTService.all('rcatalog/product_stock', object, function (response) {
                    $scope.allData = response.results;
                    $scope.totalItems = response.total;
                    $scope.itemsPerPage = response.paginate_by;
                });
            }
        };


        $scope.toRecordSaleProduct = function () {
            $scope.filter_value = "product_record";
            resetFilters();
            $timeout(function () {
                $("#filter_search").show();
                $("#filter_export").show();
                $("#filter_btn").hide();
                recordSaleProduct();
            }, 100);
        };


        function recordSaleProduct(is_export) {

            console.log("content record sale product");

            // object = "search=" + $scope.text +'&page=' + $scope.currentPage;
            //
            // if(is_export == true){
            //     object = object + '&format='+$scope.formatSelected.id;
            //     window.open('api/rcatalog/catalog_services/export?' + object);
            // }
            // else{
            //     RESTService.all('rcatalog/catalog_services', object, function (response) {
            //         $scope.allData = response.results;
            //         $scope.totalItems = response.total;
            //         $scope.itemsPerPage = response.paginate_by;
            //
            //     });
            // }
        };


        $scope.filter = function () {
            preLoadView();
        };

        $scope.export = function () {
            preLoadView(true);
        };

        $scope.pageChanged = function (page) {
            $scope.currentPage = page;
            delete $scope.allData;
            preLoadView();
        };

        $scope.searchAction = function (text) {
            $scope.text = text;
            $scope.currentPage = 1;
            if (text.length >= SEARCH.MIN_LETTERS || text.length == 0) {
                delete $scope.allData;
                preLoadView();
            }
        };

        $scope.cleanSearch = function () {
            $timeout(function () {
                $scope.text = null;
                $scope.searchInput = null;
                angular.element(document.querySelector('#searchInput')).val('');
                angular.element(document.querySelector('#searchInput')).focus();
                preLoadView();

            }, 50);
        };

        function preLoadView(verify_export) {
            var verify = false;
            if (verify_export) {
                verify = true;
            }

            if ($scope.filter_value === "product_stock") {
                stockProduct(verify);
            }
            else if ($scope.filter_value === "catalog_products") {
                catalogProducts(verify);
            }
            else if ($scope.filter_value === "catalog_services") {
                catalogServices(verify);
            }
            else if ($scope.filter_value === "catalog_categories") {
                catalogCategories(verify);
            }
            else if ($scope.filter_value === "catalog_lines") {
                catalogLines(verify);
            }
            else if ($scope.filter_value === "catalog_brands") {
                catalogBrands(verify);
            }
            else {
                stockProduct(verify);
            }
        };

        $scope.refresh = function () {
            resetFilters();

            if ($scope.filter_value == "product_stock") {
                $scope.toStockProduct();
            }
            else if ($scope.filter_value == "catalog_products") {
                $scope.toCatalogProducts();
            }
            else if ($scope.filter_value == "catalog_services") {
                $scope.toCatalogServices();

            } else if ($scope.filter_value === "catalog_categories") {
                $scope.toCatalogCategories();
            }
            else if ($scope.filter_value === "catalog_lines") {
                $scope.toCatalogLines();
            }
            else if ($scope.filter_value === "catalog_brands") {
                $scope.toCatalogBrands();
            }
            else {
                $scope.toStockProduct();
            }
        };

        function resetFilters() {

            $("#report_empty").hide();

            $scope.currentPage = 1;
            $scope.text = null;
            $scope.searchInput = null;
            angular.element(document.querySelector('#searchInput')).val('');

            $scope.stock_min = null;
            $("#stock_min").val('');
            $("#warehousesSelected").empty();
            $("#brandSelected").empty();
            $("#lineSelected").empty();

            $scope.branchSelected = $scope.branchoffices[0];

            $('#formatSelected').prop('selectedIndex', 0);
            $scope.formatSelected = EXPORT.FORMAT[0];

            $scope.start_range = start_range;
            $scope.end_range = end_range;

            $('#date_range').daterangepicker({
                locale: {
                    format: 'MMM D, YYYY'
                },
                startDate: $scope.start_range,
                endDate: $scope.end_range,
                showDropdowns: true,
            },
                function (start, end, label) {
                    $scope.start_range = start;
                    $scope.end_range = end;
                }
            );

            $scope.year_selected = $scope.year_selected = moment().format('YYYY');
            $("#year_selected").val(moment().format('YYYY'));

            // hide filters
            $("#filter_branchoffice").hide();
            $("#filter_year").hide();
            $("#filter_limit").hide();
            $("#filter_range_date").hide();
            $("#filter_search").hide();
            $("#filter_export").hide();
            $("#filter_warehouse").hide();
            $("#filter_stock_min").hide();
            $("#filter_catalog_brand").hide();
            $("#filter_catalog_line").hide();
            $("#filter_catalog_category").hide();

            $("#filter_btn").show();
        };

    };

})();


