(function () {
    'use strict';
    angular.module('sys.app.rmoney')
        .controller('ReportMoneyCtrl', ReportMoneyCtrl);

    ReportMoneyCtrl.$inject = ['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory', '$http', '$timeout', 'notifyAlert', 'SEARCH', '$uibModal', 'REPORT', 'EXPORT'];

    function ReportMoneyCtrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $http, $timeout, notifyAlert, SEARCH, $uibModal, REPORT, EXPORT)
    {

        var start_range = moment().startOf('month');
        var end_range = moment().endOf('month');

        $scope.start_range = start_range;
        $scope.end_range = end_range;

        var object = "";

        $scope.currentPage = 1;
        $scope.warehousesSelected = {
            'id':1
        };

        $scope.text= null;

        $scope.is_voucher_external = false;


        init();

        function init() {

            $scope.formats = EXPORT.FORMAT;
            $scope.formatSelected = EXPORT.FORMAT[0];

            RESTService.all('branch/branchoffices', null, function (response) {
                $scope.branchoffices = response.results;
                $scope.branchSelected = response.results[0];
            });


            $timeout(function () {

                $('#date_range').daterangepicker({
                        locale: {
                            format: 'MMM D, YYYY'
                        },
                        startDate: $scope.start_range,
                        endDate: $scope.end_range,
                        showDropdowns: true,
                    },
                    function (start, end, label) {
                        $scope.start_range = start;
                        $scope.end_range = end;
                    }
                );

            }, 100);
        };

        $scope.changeFormatExport = function (item) {
            $scope.formatSelected = item;
        };

        $scope.changeVoucherExternal = function (item) {
           $scope.is_voucher_external = item;
        };


        $scope.toSaleByVoucher = function () {
            $scope.filter_value = "sale_by_vouchers";
            resetFilters();
            $timeout(function () {
                // $("#filter_btn").hide();
                $("#filter_branchoffice").show();
                $("#filter_range_date").show();
                $("#filter_export").show();
                saleByVouchers();
            }, 100);
        };
        function saleByVouchers(is_export) {
            object = "branchoffice=" + $scope.branchSelected.id + '&limit='
                +"&start_range=" + $scope.start_range.format('YYYY-MM-DD') + '&end_range=' + $scope.end_range.format('YYYY-MM-DD');

            if(is_export == true){
                object = object + '&format='+$scope.formatSelected.id;
                window.open('api/raccounting/sale_by_vouchers/export?' + object);
            }
            else{
                RESTService.all('raccounting/sale_by_vouchers', object, function (response) {
                    $scope.summary_vouchers = response.results;
                });
            }
        };

        // print report expenses

        $scope.toListExpenses = function () {
            $scope.filter_value = "list_expenses";
            resetFilters();
            $timeout(function () {
                $("#filter_branchoffice").show();
                $("#filter_range_date").show();
                $("#filter_export").show();
                listExpenses();
            }, 100);
        };

        function listExpenses(is_export) {
            object = "branchoffice=" + $scope.branchSelected.id
                +"&is_voucher_external="+$scope.is_voucher_external
                +"&start_range=" + $scope.start_range.format('YYYY-MM-DD') + '&end_range=' + $scope.end_range.format('YYYY-MM-DD');

            if(is_export == true){
                object = object + '&format='+$scope.formatSelected.id;
                window.open('api/rmoney/list_expenses/export?' + object);
            }
            else{
                RESTService.all('rmoney/list_expenses', object, function (response) {
                    $scope.allData = response.results;
                    $scope.totalItems = response.total;
                    $scope.itemsPerPage = response.paginate_by;
                });
            }
        };

        // =================

        $scope.filter = function () {
            preLoadView();
        };

        $scope.export = function () {
            preLoadView(true);
        };

        $scope.pageChanged = function(page) {
            $scope.currentPage = page;
            delete $scope.allData;
            preLoadView();
        };

        $scope.searchAction = function (text) {
            $scope.text = text;
            $scope.currentPage = 1;
            if (text.length >= SEARCH.MIN_LETTERS || text.length == 0) {
                delete $scope.allData;
                preLoadView();
            }
        };

        $scope.cleanSearch = function () {
            $timeout(function () {
                $scope.text = null;
                $scope.searchInput = null;
                angular.element(document.querySelector('#searchInput')).val('');
                angular.element(document.querySelector('#searchInput')).focus();
                preLoadView();

            }, 50);
        };


        $scope.refresh = function () {
            resetFilters();
            if($scope.filter_value === "list_expenses"){
                $scope.toListExpenses();
            }
            // else if($scope.filter_value === "value_kardex"){
            //     $scope.toValueKardex();
            // }
            else {
                $scope.toListExpenses();
            }
        };

        function preLoadView(verify_export) {
            var verify = false;
            if(verify_export){
                verify = true;
            }

            if($scope.filter_value === "list_expenses"){
                listExpenses(verify);
            }
            // else if($scope.filter_value === "value_kardex"){
            //     valueKardex(verify);
            // }
            else{
                listExpenses(verify);
            }
        };

        function resetFilters() {

            $("#report_empty").hide();

            $scope.currentPage = 1;
            $scope.text = null;
            $scope.searchInput = null;
            angular.element(document.querySelector('#searchInput')).val('');

            $scope.branchSelected = $scope.branchoffices[0];

            $('#formatSelected').prop('selectedIndex',0);
            $scope.formatSelected = EXPORT.FORMAT[0];
            $scope.statusSelected = EXPORT.STATUS_VOUCHER[0];

            $scope.start_range = start_range;
            $scope.end_range = end_range;

            $('#date_range').daterangepicker({
                    locale: {
                        format: 'MMM D, YYYY'
                    },
                    startDate: $scope.start_range,
                    endDate: $scope.end_range,
                    showDropdowns: true,
                },
                function (start, end, label) {
                    $scope.start_range = start;
                    $scope.end_range = end;
                }
            );

            // hide filters
            $("#filter_branchoffice").hide();
            $("#filter_range_date").hide();
            $("#filter_search").hide();
            $("#filter_export").hide();

            $("#filter_btn").show();
        };
    };

})();

