(function () {
    'use strict';
    angular.module('sys.app.rpurchase')
        .controller('ReportPurchaseCtrl', ReportPurchaseCtrl);

    ReportPurchaseCtrl.$inject = ['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory', '$http', '$timeout', 'notifyAlert', 'SEARCH', '$uibModal', 'REPORT', 'EXPORT'];

    function ReportPurchaseCtrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $http, $timeout, notifyAlert, SEARCH, $uibModal, REPORT, EXPORT) {

        var start_range = moment().startOf('month');
        var end_range = moment().endOf('month');

        $scope.start_range = start_range;
        $scope.end_range = end_range;

        var object = "";

        $scope.currentPage = 1;
        $scope.warehousesSelected = {
            'id':1
        };

        $scope.text= null;


        init();

        function init() {
            $scope.limits = REPORT.LIMIT;
            $scope.limitSelected = REPORT.LIMIT[0];

            $scope.formats = EXPORT.FORMAT;
            $scope.formatSelected = EXPORT.FORMAT[0];

            // status voucher
            $scope.statusvoucher = EXPORT.STATUS_VOUCHER;
            $scope.statusSelected = EXPORT.STATUS_VOUCHER[0];

            RESTService.all('branch/branchoffices', null, function (response) {
                $scope.branchoffices = response.results;
                $scope.branchSelected = response.results[0];
            });

            $scope.year_selected = moment().format('YYYY');

            $timeout(function () {
                $('#year_selected').datetimepicker({
                    format: "YYYY",
                    viewMode: "years",
                });

                $('#date_range').daterangepicker({
                        locale: {
                            format: 'MMM D, YYYY'
                        },
                        startDate: $scope.start_range,
                        endDate: $scope.end_range,
                        showDropdowns: true,
                    },
                    function (start, end, label) {
                        $scope.start_range = start;
                        $scope.end_range = end;
                    }
                );

            }, 100);
        };

        $scope.changeFormatExport = function (item) {
            $scope.formatSelected = item;
        };

        $scope.changeTypeVoucher = function (item) {
            $scope.typeVoucherSelected = item;
        };

        $scope.changeLimitselected = function (item) {
            $scope.limitSelected = item;
        };

        $scope.changeStatusVoucher = function (item) {
            $scope.statusSelected = item;
        };

        $scope.toListPurchases = function () {
            $scope.filter_value = "list_purchases";
            resetFilters();
            $timeout(function () {
                $("#filter_branchoffice").show();
                $("#filter_range_date").show();
                $("#filter_search").show();
                $("#filter_typevoucher").show();
                $("#filter_statusvoucher").show();
                $("#filter_export").show();

                RESTService.all('config/typevoucher/purchase', null, function (response) {
                    var last = response.results.length;
                    $scope.typevouchers = response.results;
                    response.results[last] = {id: null, description: 'TODOS', value: null};
                    $scope.typeVoucherSelected = response.results[last];
                    listPurchases();
                });

            }, 100);
        }

        function listPurchases(is_export) {
            object = "search=" + $scope.text + '&page=' + $scope.currentPage +"&branchoffice=" + $scope.branchSelected.id
                +"&start_range=" + $scope.start_range.format('YYYY-MM-DD') + '&end_range=' + $scope.end_range.format('YYYY-MM-DD')
                +'&voucher=' + $scope.typeVoucherSelected.id + '&status=' + $scope.statusSelected.id;

            if(is_export == true){
                object = object + '&format='+$scope.formatSelected.id;
                window.open('api/rpurchase/list_purchases/export?' + object);
            }
            else{
                RESTService.all('rpurchase/list_purchases', object, function (response) {
                    $scope.allData = response.results;
                    $scope.totalItems = response.total;
                    $scope.itemsPerPage = response.paginate_by;
                });
            }
        };

        $scope.filter = function () {
            preLoadView();
        };

        $scope.export = function () {
            preLoadView(true);
        };

        $scope.pageChanged = function(page) {
            $scope.currentPage = page;
            delete $scope.allData;
            preLoadView();
        };

        $scope.searchAction = function (text) {
            $scope.text = text;
            $scope.currentPage = 1;
            if (text.length >= SEARCH.MIN_LETTERS || text.length == 0) {
                delete $scope.allData;
                preLoadView();
            }
        };


        $scope.cleanSearch = function () {
            $timeout(function () {
                $scope.text = null;
                $scope.searchInput = null;
                angular.element(document.querySelector('#searchInput')).val('');
                angular.element(document.querySelector('#searchInput')).focus();
                preLoadView();

            }, 50);
        };


        $scope.refresh = function () {
            resetFilters();
            if($scope.filter_value == "list_purchases"){
                $scope.toListPurchases();
            }
            else{
                $scope.toListPurchases();
            }
        };


        function preLoadView(verify_export) {
            var verify = false;
            if(verify_export){
                verify = true;
            }
            if($scope.filter_value == "list_purchases"){
                listPurchases(verify);
            }
            else{
                listPurchases(verify);
            }
        };


        function resetFilters() {

            $("#report_empty").hide();

            $scope.currentPage = 1;
            $scope.text = null;
            $scope.searchInput = null;
            angular.element(document.querySelector('#searchInput')).val('');

            $scope.branchSelected = $scope.branchoffices[0];

            $('#formatSelected').prop('selectedIndex',0);
            $scope.formatSelected = EXPORT.FORMAT[0];
            $scope.statusSelected = EXPORT.STATUS_VOUCHER[0];

            $scope.start_range = start_range;
            $scope.end_range = end_range;

            $('#date_range').daterangepicker({
                    locale: {
                        format: 'MMM D, YYYY'
                    },
                    startDate: $scope.start_range,
                    endDate: $scope.end_range,
                    showDropdowns: true,
                },
                function (start, end, label) {
                    $scope.start_range = start;
                    $scope.end_range = end;
                }
            );

            $scope.year_selected = $scope.year_selected = moment().format('YYYY');
            $("#year_selected").val(moment().format('YYYY'));

            // hide filters
            $("#filter_branchoffice").hide();
            $("#filter_year").hide();
            $("#filter_limit").hide();
            $("#filter_range_date").hide();
            $("#filter_search").hide();
            $("#filter_typevoucher").hide();
            $("#filter_statusvoucher").hide();

            $("#filter_export").hide();

            $("#filter_btn").show();
        };

    };

})();
