(function () {
    'use strict';
    angular.module('sys.app.rsale')
        .controller('ReportSaleCtrl', ReportSaleCtrl);

    ReportSaleCtrl.$inject = ['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory', '$http', '$timeout', 'notifyAlert', 'SEARCH', '$uibModal', 'REPORT', 'EXPORT'];

    function ReportSaleCtrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $http, $timeout, notifyAlert, SEARCH, $uibModal, REPORT, EXPORT) {

        var start_range = moment().startOf('month');
        var end_range = moment().endOf('month');

        $scope.start_range = start_range;
        $scope.end_range = end_range;

        var object = "";

        $scope.currentPage = 1;
        $scope.text= null;

        init();

        function init() {
            $scope.limits = REPORT.LIMIT;
            $scope.limitSelected = REPORT.LIMIT[0];

            $scope.formats = EXPORT.FORMAT;
            $scope.formatSelected = EXPORT.FORMAT[0];

            RESTService.all('branch/branchoffices', null, function (response) {
                $scope.branchoffices = response.results;
                $scope.branchSelected = response.results[0];
            });

            $scope.year_selected = moment().format('YYYY');

            $timeout(function () {
                $('#year_selected').datetimepicker({
                    format: "YYYY",
                    viewMode: "years",
                });

                $('#date_range').daterangepicker({
                        locale: {
                            format: 'MMM D, YYYY'
                        },
                        startDate: $scope.start_range,
                        endDate: $scope.end_range,
                        showDropdowns: true,
                    },
                    function (start, end, label) {
                        $scope.start_range = start;
                        $scope.end_range = end;
                    }
                );

            }, 100);
        }

        $scope.changeFormatExport = function (item) {
            $scope.formatSelected = item;
        };

        function historySaleByMonth() {

            object = "branchoffice=" + $scope.branchSelected.id + '&year=' + $("#year_selected").val();

            RESTService.all('rsale/history_sale_month', object, function (response) {

                graphSaleByMonth(response.graph_sale_month);
            });

            function graphSaleByMonth(summary_data) {

                var obj_months = [
                    {number_month: 1,name: "Ene",value:0},
                    {number_month: 2,name: "Feb",value:0},
                    {number_month: 3,name: "Mar",value:0},
                    {number_month: 4,name: "Abr",value:0},
                    {number_month: 5,name: "May",value:0},
                    {number_month: 6,name: "Jun",value:0},
                    {number_month: 7,name: "Jul",value:0},
                    {number_month: 8,name: "Agos",value:0},
                    {number_month: 9,name: "Set",value:0},
                    {number_month: 10,name: "Oct",value:0},
                    {number_month: 11,name: "Nov",value:0},
                    {number_month: 12,name: "Dec",value:0},
                ];

                var categories = [];
                var series = [];

                $.each(summary_data, function (i, item) {
                    obj_months.map(function(obj, index){
                        if(obj.number_month == item.number_month){
                            obj_months[index].value = parseFloat(item.total_month);
                        }
                    });
                });


                $.each(obj_months, function (i, item) {
                    categories.push(item.name);
                    series.push(item.value);
                });

                Highcharts.chart('container', {
                    title: {
                        text: 'Gráfico de ventas mensuales año '+$("#year_selected").val()
                    },

                    xAxis: {
                        categories: categories
                    },
                    yAxis: {
                        title: {
                            text: 'Total S/.'
                        },
                        labels: {
                            formatter: function () {
                                return this.value;
                            }
                        }
                    },

                    series: [
                        {
                            name: 'Total S/',
                            marker: {
                                symbol: 'square'
                            },
                            data: series,
                            showInLegend: false

                        }
                    ]
                });
            }
        };

        function historyClientVip() {
            object = "branchoffice=" + $scope.branchSelected.id + '&limit=' + $scope.limitSelected.id
                +"&start_range=" + $scope.start_range.format('YYYY-MM-DD') + '&end_range=' + $scope.end_range.format('YYYY-MM-DD');
            RESTService.all('rsale/history_client_vip', object, function (response) {
                $scope.clients_vip = response.results;
            });
        }

        function historyEmployeeSale() {
            object = "branchoffice=" + $scope.branchSelected.id +"&start_range=" + $scope.start_range.format('YYYY-MM-DD') + '&end_range=' + $scope.end_range.format('YYYY-MM-DD');

            RESTService.all('rsale/history_employee_sale', object, function (response) {
                $scope.employee_sale = response.results;
            });
        }

        $scope.toHistoryClientVip = function () {
            $scope.filter_value = "history_client_vip";
            resetFilters();

            $timeout(function () {
                $("#filter_branchoffice").show();
                $("#filter_limit").show();
                $("#filter_range_date").show();
                historyClientVip();
            }, 100);
        };

        $scope.toHistoryEmployeeSale = function () {
            $scope.filter_value = "history_employee_sale";
            resetFilters();
            $timeout(function () {
                $("#filter_branchoffice").show();
                // $("#filter_limit").show();
                $("#filter_range_date").show();
                historyEmployeeSale();
            }, 100);
        };

        $scope.toHistorySaleByMonth = function () {
            $scope.filter_value = "history_sale_month";
            resetFilters();

            $timeout(function () {
                $("#filter_branchoffice").show();
                $("#filter_year").show();
                historySaleByMonth();
            }, 100);
        }

        // sale clients
        $scope.toSaleClients = function () {
            $scope.filter_value = "sale_clients";
            resetFilters();
            $timeout(function () {
                $("#filter_search").show();
                $("#filter_export").show();
                saleClients();
            }, 100);
        };
        function saleClients(is_export) {
            object = "search=" + $scope.text +'&page=' + $scope.currentPage;
            if(is_export){
                object = object + '&format='+$scope.formatSelected.id;
                window.open('api/rsale/sale_clients/export?' + object);
            }
            else{
                RESTService.all('rsale/sale_clients', object, function (response) {
                    $scope.allData = response.results;
                    $scope.totalItems = response.total;
                    $scope.itemsPerPage = response.paginate_by;
                });
            }
        };

        // sale summary line
        $scope.toSaleSummaryLine = function () {
            $scope.filter_value = "sale_summary_line";
            resetFilters();
            $timeout(function () {
                $("#filter_search").show();
                $("#filter_export").show();
                $("#filter_range_date").show();
                saleSummaryLine();
            }, 100);
        };
        function saleSummaryLine(is_export) {
            object = "search=" + $scope.text +'&page=' + $scope.currentPage
                +"&branchoffice=" + $scope.branchSelected.id+"&start_range=" + $scope.start_range.format('YYYY-MM-DD') + '&end_range=' + $scope.end_range.format('YYYY-MM-DD');

            if(is_export){
                object = object + '&format='+$scope.formatSelected.id;
                window.open('api/rsale/sale_utility_product/export?' + object);
            }
            else{
                RESTService.all('rsale/sale_summary_line', object, function (response) {
                    $scope.allData = response.results;
                    $scope.totalItems = response.total;
                    $scope.itemsPerPage = response.paginate_by;
                });
            }
        };


        // sale utility products
        $scope.toSaleUtilityProduct = function () {
            $scope.filter_value = "sale_utility_product";
            resetFilters();
            $timeout(function () {
                $("#filter_search").show();
                $("#filter_export").show();
                $("#filter_range_date").show();
                saleUtilityProduct();
            }, 100);
        };
        function saleUtilityProduct(is_export) {
            object = "search=" + $scope.text +'&page=' + $scope.currentPage
               +"&branchoffice=" + $scope.branchSelected.id+"&start_range=" + $scope.start_range.format('YYYY-MM-DD') + '&end_range=' + $scope.end_range.format('YYYY-MM-DD');

            if(is_export){
                object = object + '&format='+$scope.formatSelected.id;
                window.open('api/rsale/sale_utility_product/export?' + object);
            }
            else{
                RESTService.all('rsale/sale_utility_product', object, function (response) {
                    $scope.allData = response.results;
                    $scope.totalItems = response.total;
                    $scope.itemsPerPage = response.paginate_by;
                });
            }
        };

        // ==============


        $scope.filter = function () {
            preLoadView();
        };

        $scope.export = function () {
            preLoadView(true);
        };

        $scope.pageChanged = function(page) {
            $scope.currentPage = page;
            delete $scope.allData;
            preLoadView();
        };

        $scope.searchAction = function (text) {
            $scope.text = text;
            $scope.currentPage = 1;
            if (text.length >= SEARCH.MIN_LETTERS || text.length == 0) {
                delete $scope.allData;
                preLoadView();
            }
        };

        $scope.cleanSearch = function () {
            $timeout(function () {
                $scope.text = null;
                $scope.searchInput = null;
                angular.element(document.querySelector('#searchInput')).val('');
                angular.element(document.querySelector('#searchInput')).focus();
                preLoadView();

            }, 50);
        };

        function preLoadView(verify_export) {
            var verify = false;
            if(verify_export){
                verify = true;
            }
            if($scope.filter_value === "history_sale_month"){
                historySaleByMonth(verify);
            }
            else if($scope.filter_value === "history_client_vip"){
                historyClientVip(verify);
            }
            else if($scope.filter_value === "history_employee_sale"){
                historyEmployeeSale(verify);
            }
            else if($scope.filter_value === "sale_clients"){
                saleClients(verify);
            }
            else if($scope.filter_value === "sale_utility_product"){
                saleUtilityProduct(verify);
            }
            else if($scope.filter_value === "sale_summary_line"){
                saleSummaryLine(verify);
            }
            else{
                historySaleByMonth(verify);
            }
        };

        $scope.refresh = function () {
            resetFilters();

            if($scope.filter_value === "history_sale_month"){
                $scope.toHistorySaleByMonth();
            }
            else if($scope.filter_value === "history_client_vip"){
                $scope.toHistoryClientVip();
            }
            else if($scope.filter_value === "history_employee_sale"){
                $scope.toHistoryEmployeeSale();
            }
            else if($scope.filter_value === "sale_clients"){
                $scope.toSaleClients();
            }
            else if($scope.filter_value === "sale_utility_product"){
                $scope.toSaleUtilityProduct();
            }
            else if($scope.filter_value === "sale_summary_line"){
                $scope.toSaleSummaryLine();
            }
            else{
                $scope.toHistorySaleByMonth();
            }
        };

        function resetFilters() {

            $("#report_empty").hide();

            delete $scope.currentPage;
            delete $scope.allData;

            $scope.currentPage = 1;
            $scope.text = null;
            $scope.searchInput = null;

            angular.element(document.querySelector('#searchInput')).val('');

            $scope.branchSelected = $scope.branchoffices[0];

            $('#limitSelected').prop('selectedIndex',0);
            $scope.limitSelected = REPORT.LIMIT[0];

            $scope.start_range = start_range;
            $scope.end_range = end_range;

            $('#date_range').daterangepicker({
                    locale: {
                        format: 'MMM D, YYYY'
                    },
                    startDate: $scope.start_range,
                    endDate: $scope.end_range,
                    showDropdowns: true,
                },
                function (start, end, label) {
                    $scope.start_range = start;
                    $scope.end_range = end;
                }
            );

            $scope.year_selected = $scope.year_selected = moment().format('YYYY');
            $("#year_selected").val(moment().format('YYYY'));

            // hide filters
            $("#filter_branchoffice").hide();
            $("#filter_year").hide();
            $("#filter_limit").hide();
            $("#filter_range_date").hide();

            $("#filter_search").hide();
            $("#filter_export").hide();
        };

        $scope.changeLimitselected = function (limit) {
            $scope.limitSelected = limit;
        };

        function limitSelected(id) {
            if(!_.isUndefined(id)){
                $scope.limitSelected = ConfigPagination.searchById(id,$scope.limits);
            }
        };

    };

})();
