(function () {

    'use strict';
    angular.module('sys.app.categoryfood.new')
        .controller('NewCategoryFoodCtrl', NewCategoryFoodCtrl);

    NewCategoryFoodCtrl.$inject = ['$scope', '$stateParams', '$state', 'RESTService', 'notifyAlert', '$rootScope', '_', 'HelperFactory'];

    function NewCategoryFoodCtrl($scope, $stateParams, $state, RESTService, notifyAlert, $rootScope, _, HelperFactory) {

        try {
            if (!_.isNull($stateParams.entity.id)) {
                $scope.entity = $stateParams.entity;
                $scope.brand = $stateParams.entity;
                if ($scope.brand.id != 0) {//$scope.unitElements
                    $scope.txt_title = 'Editar'
                    $scope.action = 'edit';
                    $scope.brand.description = $scope.entity.description;
                    $scope.brand.url_image = $scope.entity.urlImageBase;
                }
                else {
                    $scope.txt_title = 'Registrar';
                    $scope.action = 'create';
                    $scope.brand = {
                        'description': null,
                        'url_image':null,
                    };
                }
            }
        }
        catch (e) {
            $state.transitionTo('restaurant.categoryfood', null, {'reload': true});
            console.log(e);
            return false;
        }

        init()

        function init() {
            angular.element(document.querySelector('#brand_description')).focus();
        }

        $scope.$on("fileProgress", function(e, progress) {
            $scope.progress = progress.loaded / progress.total;
        });


        $scope.save = function () {
            if (validate()) {
                if($scope.action == 'create'){
                    RESTService.save('categoryfood/save', $scope.brand, function (result) {
                        notifyAlert.success("Registro realizado con éxito!!");
                        $state.transitionTo('restaurant.categoryfood', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
                else if($scope.action == 'edit'){
                    RESTService.updated('categoryfood/update', $scope.brand.id, $scope.brand, function (result) {
                        notifyAlert.success("Registro actualizado con éxito!!");
                        $state.transitionTo('restaurant.categoryfood', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
            }
        };

        function validate() {
            if (_.isNull($scope.brand.description) || _.isEmpty($scope.brand.description)) {
                HelperFactory.show_AlertFactory('Debe ingresar la descripción de la marca');
                angular.element(document.querySelector('#brand_description')).focus();
                return false;
            }

            return true;
        };

        $scope.close = function () {
            $state.transitionTo('restaurant.categoryfood', null, {'reload': true});
        };
    }

})();

