(function () {
    'use strict';
    angular.module('sys.app.client')
        .controller('ClientCtrl', ClientCtrl);

    ClientCtrl.$inject = ['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory', '$timeout', 'notifyAlert', 'SEARCH'];

    function ClientCtrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $timeout, notifyAlert, SEARCH){

        $scope.entity = {};
        $scope.text= null;
        $scope.currentPage = 1;
        var object = "";

        init();

        function init() {
            object = "search=" + $scope.text + '&page=' + $scope.currentPage;
            RESTService.all('client/list', object + '&export=0', function (response) {

                $scope.allData = response.results;
                $scope.totalItems = response.total;
                $scope.itemsPerPage = response.paginate_by;
            }, function (error) {
                console.log('ERROR');
                return false;
            });

        }

        $scope.searchAction = function (text) {
            $scope.text = text;
            $scope.currentPage = 1;
            if (text.length >= SEARCH.MIN_LETTERS || text.length == 0) {
                delete $scope.allData;
                init();
            }
        };

        $scope.refresh = function () {
            delete $scope.allData;
            $state.transitionTo('sales.clients', {entity: null}, {'reload': true});
        };

        // functions new product
        $scope.new = function () {
            var client = {'id': 0}
            var source = {'data': client};
            $state.transitionTo('sales.clients.new', {entity: source}, {
                'reload': 'sales.clients.new',
                'cache': false
            });
            delete $scope.allData;
        };

        $scope.edit = function (source) {
            RESTService.get('client/edit', source.id, function (response) {
                $state.transitionTo("sales.clients.edit",
                    {'id': source.id,
                    entity: response
                }, {'reload': "sales.clients.edit", 'cache': false});
                delete $scope.allData;
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };

        $scope.pageChanged = function(page) {
            $scope.currentPage = page;
            delete $scope.allData;
            init();
        };

        $scope.delete = function (item) {
            var options = {
                title: "Cuidado!!",
                message: "El cliente ' "+item.fullname+" ' será eliminado",
                cancel: "Cancelar",
                confirm: "Eliminar"
            };
            AlertFactory.confirm(options, function () {
                RESTService.deleted('client/delete', item.id, function (response) {
                    notifyAlert.success("El item se ha eliminado con éxito!!");
                    var obj = {"text": $scope.text};
                    $state.transitionTo('sales.clients', {entity: obj}, {'reload': true});
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });

            });
        };
    }
})();




