(function () {
    'use strict';

    angular.module('sys.utils.utils')
        .controller('ExtendGuestCtrl', ExtendGuestCtrl);

    ExtendGuestCtrl.$inject = ['$scope', '$state', 'RESTService', 'notifyAlert', '_', 'HelperFactory', 'ConfigPagination', 'PARAM', '$uibModalInstance', '$timeout','fileReader', 'CLIENT', 'TYPE_DOCUMENT'];

    function ExtendGuestCtrl($scope, $state, RESTService, notifyAlert, _, HelperFactory, ConfigPagination, PARAM, $uibModalInstance, $timeout, fileReader, CLIENT, TYPE_DOCUMENT) {

        var loading;


        $scope.get_param = PARAM;
        $scope.entity = $scope.get_param.entity;
        $scope.client = $scope.entity;


        if ($scope.get_param.is_edit) {
            $scope.txt_title = 'Editar'
            $scope.action == 'edit';
            $scope.client.fullname = $scope.entity.fullname;
            $scope.client.document = $scope.entity.document;
            $scope.client.cellphone = $scope.entity.cellphone;
            $scope.client.email = $scope.entity.email;
            $scope.client.address = $scope.entity.address;
            $scope.client.date_birthday = $scope.entity.date_birthday;
            $scope.client.is_responsible = $scope.entity.is_responsible;
        }
        else
        {
            $scope.txt_title = 'Registrar';
            $scope.action = 'create';
            $scope.client = {
                'client_id': 0,
                'fullname': null,
                'document': null,
                'tradename': null,
                'cellphone': null,
                'telephone': null,
                'email': null,
                'address':null,
                'url_image':null,
                'is_responsible':false,
                'date_birthday':null
            };

            $scope.ubigeo = false;
        }

        init()

        function init() {

            $scope.service_alert = false;

            $scope.type_dni = TYPE_DOCUMENT['DNI'];
            $scope.type_ruc = TYPE_DOCUMENT['RUC'];
            $scope.max_length_document = 8;

            $scope.types = CLIENT.TYPE;
            $scope.typeSelected =  CLIENT.TYPE[0];

            $scope.status = CLIENT.STATUS;
            $scope.statusSelected = CLIENT.STATUS[0];

            $scope.sexs = CLIENT.SEX;
            $scope.sexSelected = CLIENT.SEX[0];

            $scope.age_groups = CLIENT.AGE_GROUP;
            $scope.ageGroupSelected = CLIENT.AGE_GROUP[0];

            ageGroupSelected($scope.client.age_group);


            RESTService.all('config/typedocument', null, function (response) {
                $scope.type_documents = response.results;
                $scope.typeDocumentSelected = response.results[0];
                typeDocumentSelected($scope.client.typedocument_id);
            });

            // checkUbigeo();

            $timeout(function () {
                $('#date_birthday').datepicker({
                    dateFormat: 'yy-mm-dd',
                    changeYear: true,
                    changeMonth: true,
                    autoclose: true,
                });

                typeSelected($scope.client.type_client);
                checkType($scope.client.type_client);

                loading = angular.element(document.querySelector('#loading_modal'));

            }, 100);

            angular.element(document.querySelector('#client_fullname')).focus();
        }

        function checkUbigeo() {
            if($scope.ubigeo){
                $("#departmentSelected").html('');
                $("#provinceSelected").html('');
                $("#districtSelected").html('');

                $scope.is_required_ubigeo = true;

                $scope.departments = $scope.ubigeo.departments;
                $scope.provinces = $scope.ubigeo.provinces;
                $scope.districts = $scope.ubigeo.districts;

                $timeout(function () {
                    $scope.departmentSelected = ConfigPagination.searchById($scope.ubigeo.department_id,$scope.ubigeo.departments);
                    $scope.provinceSelected = ConfigPagination.searchById($scope.ubigeo.province_id,$scope.ubigeo.provinces);
                    $scope.districtSelected = ConfigPagination.searchById($scope.ubigeo.district_id,$scope.ubigeo.districts);
                }, 100);

                return true;
            }
            else{
                RESTService.all('ubigeo/departments', null, function (response) {
                    var last = response.results.length;
                    $scope.departments = response.results;
                    response.results[last] = {id: 0, code:'0', name:'Seleccione', value:0}
                    $scope.departmentSelected = response.results[last];
                    $scope.is_required_ubigeo = false;
                });
                return false;
            }
        }

        $scope.$on("fileProgress", function(e, progress) {
            $scope.progress = progress.loaded / progress.total;
        });

        $scope.changeTypeDocument = function () {
            $scope.client.document = null;
            if($scope.typeDocumentSelected.id == $scope.type_ruc.id){
                $scope.max_length_document = $scope.type_ruc.max_length;
            }
            else if($scope.typeDocumentSelected.id == $scope.type_dni.id)
                $scope.max_length_document = $scope.type_dni.max_length;
            else{
                $scope.max_length_document = 20;
            }
        }

        $scope.changeDepartment = function () {
            if($scope.departmentSelected.code == '0'){
                $("#provinceSelected").html('')
                $("#districtSelected").html('')
                delete $scope.provinceSelected;
                delete $scope.districtSelected;
                $scope.is_required_ubigeo = false;
            }
            else{
                $scope.is_required_ubigeo = true;
                getProvinces($scope.departmentSelected.code);
            }
        }

        $scope.changeDepartment = function () {
            if($scope.departmentSelected.code == '0'){
                $("#provinceSelected").html('')
                $("#districtSelected").html('')
                delete $scope.provinceSelected;
                delete $scope.districtSelected;
                $scope.is_required_ubigeo = false;
            }
            else{
                $scope.is_required_ubigeo = true;
                getProvinces($scope.departmentSelected.code);
            }
        }

        $scope.changeProvince = function () {
            if($scope.provinceSelected.code == '0'){
                $("#districtSelected").html('')
                delete $scope.districtSelected;
            }
            else{
                getDistricts($scope.provinceSelected.code);
            }
        }

        $scope.changeDistrict= function () {
            if($scope.districtSelected.code == '0'){
                delete $scope.districtSelected;
            }
        }

        function getProvinces(department_id) {
            RESTService.get('ubigeo/provinces', department_id, function (response) {
                $("#provinceSelected").html('')
                $("#districtSelected").html('')
                delete $scope.districtSelected;

                var last = response.results.length;
                response.results[last] = {id: 0, code:'0', name:'Seleccione', value:0}
                $scope.provinces = response.results;
                $scope.provinceSelected = response.results[last];
            });
        }

        function getDistricts(province_id) {
            delete $scope.districtSelected;
            RESTService.get('ubigeo/districts', province_id, function (response) {
                $("#districtSelected").html('')

                var last = response.results.length;
                response.results[last] = {id: 0, code:'0', name:'Seleccione', value:0}
                $scope.districts = response.results;
                $scope.districtSelected = response.results[last];
            });
        }

        function typeDocumentSelected(id) {
            if(!_.isUndefined(id)){
                $scope.typeDocumentSelected = ConfigPagination.searchById(id,$scope.type_documents);

                if($scope.typeDocumentSelected.id == $scope.type_ruc.id) {
                    $scope.max_length_document = $scope.type_ruc.max_length;
                } else if ($scope.typeDocumentSelected.id == $scope.type_dni.id) {

                    $scope.max_length_document = $scope.type_dni.max_length;
                } else {
                    $scope.max_length_document = 20;
                }
            }
        }

        function ageGroupSelected(id) {
            if(!_.isUndefined(id)){
                $scope.ageGroupSelected = ConfigPagination.searchById(id,$scope.age_groups);
            }
        }

        function typeSelected(id) {
            if(!_.isUndefined(id)){
                $scope.typeSelected = ConfigPagination.searchById(id,$scope.types);
            }
        }

        function sexSelected(id) {
            if(!_.isUndefined(id)){
                $scope.sexSelected = ConfigPagination.searchById(id,$scope.sexs);
            }
        }

        function statusSelected(id) {
            if(!_.isUndefined(id)){
                $scope.statusSelected = ConfigPagination.searchById(id,$scope.status);
            }
        }

        function checkType(type_client) {
            if(type_client == CLIENT.TYPE[1].id){
                $scope.sexSelected = CLIENT.SEX[0];
                $scope.statusSelected = CLIENT.STATUS[0];

                $("#sexSelected").attr('disabled', 'disabled');
                $("#statusSelected").attr('disabled', 'disabled');
            }
            else{
                sexSelected($scope.client.sex);
                statusSelected($scope.client.status);
            }
        }

        $scope.changeType = function (typeSelected) {
            if(typeSelected.id == CLIENT.TYPE[1].id){
                $scope.sexSelected = CLIENT.SEX[0];
                $scope.statusSelected = CLIENT.STATUS[0];
                $("#sexSelected").attr('disabled', 'disabled');
                $("#statusSelected").attr('disabled', 'disabled');
            }
            else{
                $scope.sexSelected = CLIENT.SEX[0];
                $scope.statusSelected = CLIENT.STATUS[0];
                $("#sexSelected").removeAttr('disabled', 'disabled');
                $("#statusSelected").removeAttr('disabled', 'disabled');
            }
        }
        $scope.save = function () {
            if (validate()) {
                loading.show();
                $scope.client['typedocument_id'] = $scope.typeDocumentSelected.id;
                $scope.client['sex'] = $scope.sexSelected.id;
                $scope.client['age_group'] = $scope.ageGroupSelected.id;
                $scope.client['age_group_description'] = $scope.ageGroupSelected.description;

                if (!$scope.get_param.is_edit) {
                    notifyAlert.success("Registro realizado con éxito!!");
                    $uibModalInstance.close($scope.client);
                } else {
                    notifyAlert.success("Datos modificados con éxito!!");
                    $uibModalInstance.close($scope.client);
                }
            }
        };

        function validate() {
            if (_.isNull($scope.client.fullname) || _.isEmpty($scope.client.fullname)) {
                HelperFactory.show_AlertFactory('Debe ingresar la descripción del cliente');
                angular.element(document.querySelector('#client_fullname')).focus();
                return false;
            }

            if (_.isNull($scope.client.document) || _.isEmpty($scope.client.document)) {
                HelperFactory.show_AlertFactory('Debe ingresar el documento del cliente');
                angular.element(document.querySelector('#client_document')).focus();
                return false;
            }

            if (_.isNull($scope.client.fullname) || _.isEmpty($scope.client.fullname)) {
                HelperFactory.show_AlertFactory('Debe ingresar la descripción del cliente');
                angular.element(document.querySelector('#client_fullname')).focus();
                return false;
            }

            if($scope.typeDocumentSelected.id === $scope.type_ruc.id) {
                if(($scope.client.document).length !== $scope.type_ruc.max_length){
                    HelperFactory.show_AlertFactory('El tipo documento '+$scope.typeDocumentSelected.description+' debe tener '+$scope.type_ruc.max_length +' caracteres.');
                    angular.element(document.querySelector('#client_document')).focus();
                    return false;
                }

            } else if ($scope.typeDocumentSelected.id === $scope.type_dni.id) {
                if(($scope.client.document).length !== $scope.type_dni.max_length){
                    HelperFactory.show_AlertFactory('El tipo documento '+$scope.typeDocumentSelected.description+' debe tener '+$scope.type_dni.max_length +' caracteres.');
                    angular.element(document.querySelector('#client_document')).focus();
                    return false;
                }
            }

            return true;
        };

        // extract data by document
        $scope.extractDni = function () {
            $scope.service_alert = false;
            loading.show();
            RESTService.get('services/dni', $scope.client.document, function (response) {
                if(response.success == true){
                    $scope.service_alert = true;
                    $scope.service_message = 'Los datos del cliente se extrajeron correctamente ';
                    replaceExtractDniData(response.data);
                }else{
                    notifyAlert.warning(response.message);
                }
                loading.hide();
            }, function (error) {

                console.log(error);

                loading.hide();
                return false;
            });
        }

        $scope.extractRuc = function () {
            $scope.service_alert = false;
            loading.show();
            RESTService.get('services/ruc', $scope.client.document, function (response) {
                if(response.success == true){
                    $scope.service_alert = true;
                    $scope.service_message = 'El cliente se encuentra '+ response.data.status+ ' y '+ response.data.condition;
                    replaceExtractRucData(response.data);
                }else{
                    notifyAlert.warning(response.message);
                }
                loading.hide();
            }, function (error) {
                loading.hide();
                return false;
            });
        }

        function replaceExtractRucData(data) {
            $scope.client.fullname = data.name;
            $scope.client.address = data.address;
            $scope.ubigeo = data.ubigeo;
            checkUbigeo();
        }

        function replaceExtractDniData(data) {
            $scope.client.fullname = data.fullname;
            $scope.client.address = data.address;
            // $scope.client.date_birthday = data.date_of_birthday;
        }

        // =============

        $scope.closeModal = function () {
            $uibModalInstance.dismiss();
            // $uibModalInstance.dismiss('Cancelado');
            $("#loading_object").css("display","none");
        };
    }

})();


