(function () {

    'use strict';
    angular.module('sys.app.client.new')
        .controller('NewClientCtrl', NewClientCtrl);

    NewClientCtrl.$inject = ['$scope', '$stateParams', '$state', 'RESTService','notifyAlert', '_', 'HelperFactory', 'ConfigPagination', '$timeout', 'fileReader', 'CLIENT', 'TYPE_DOCUMENT'];

    function NewClientCtrl($scope, $stateParams, $state, RESTService, notifyAlert, _, HelperFactory, ConfigPagination, $timeout, fileReader, CLIENT, TYPE_DOCUMENT) {

        $('[data-toggle="tooltip"]').tooltip();

        try {
            if (!_.isNull($stateParams.entity.id)) {
                $scope.entity = $stateParams.entity.data;
                $scope.client = $stateParams.entity.data;

                if ($scope.client.id != 0) {//$scope.unitElements
                    $scope.txt_title = 'Editar';
                    $scope.action = 'edit';
                    $scope.client.fullname = $scope.entity.fullname;
                    $scope.client.document = $scope.entity.document;
                    $scope.client.tradename = $scope.entity.tradename;
                    $scope.client.telephone = $scope.entity.telephone;
                    $scope.client.email = $scope.entity.email;
                    $scope.client.address = $scope.entity.address;
                    $scope.client.url_image = $scope.entity.urlImageBase;

                    $scope.ubigeo = $stateParams.entity.ubigeo;
                }
                else
                {
                    $scope.txt_title = 'Registrar';
                    $scope.action = 'create';
                    $scope.client = {
                        'fullname': null,
                        'document': null,
                        'tradename': null,
                        'cellphone': null,
                        'telephone': null,
                        'email': null,
                        'address':null,
                        'url_image':null,
                        'date_birthday':null
                    };

                    $scope.ubigeo = false;
                }
            }
        }
        catch (e) {
            $state.transitionTo('sales.clients', null, {'reload': true});
            console.log(e);
            return false;
        }

        init()

        function init() {

            $scope.service_alert = false;

            $scope.type_dni = TYPE_DOCUMENT['DNI'];
            $scope.type_ruc = TYPE_DOCUMENT['RUC'];
            $scope.max_length_document = 8;

            $scope.types = CLIENT.TYPE;
            $scope.typeSelected =  CLIENT.TYPE[0];

            $scope.status = CLIENT.STATUS;
            $scope.statusSelected = CLIENT.STATUS[0];

            $scope.sexs = CLIENT.SEX;
            $scope.sexSelected = CLIENT.SEX[0];


            RESTService.all('config/typedocument', null, function (response) {
                $scope.type_documents = response.results;
                $scope.typeDocumentSelected = response.results[0];
                typeDocumentSelected($scope.client.typedocument_id);
            });

            checkUbigeo();

            $timeout(function () {
                $('#date_birthday').datepicker({
                    dateFormat: 'yy-mm-dd',
                    changeYear: true,
                    changeMonth: true,
                    autoclose: true,
                });
                // }).datepicker('widget').wrap('<div class="ll-skin-latoja"/>');

                typeSelected($scope.client.type_client);
                checkType($scope.client.type_client);

                // changeSexSelected($scope.client.sex);

            }, 100);

            angular.element(document.querySelector('#client_fullname')).focus();
        }

        function checkUbigeo() {
            if($scope.ubigeo){
                $("#departmentSelected").html('');
                $("#provinceSelected").html('');
                $("#districtSelected").html('');

                $scope.is_required_ubigeo = true;

                $scope.departments = $scope.ubigeo.departments;
                $scope.provinces = $scope.ubigeo.provinces;
                $scope.districts = $scope.ubigeo.districts;

                $timeout(function () {
                    $scope.departmentSelected = ConfigPagination.searchById($scope.ubigeo.department_id,$scope.ubigeo.departments);
                    $scope.provinceSelected = ConfigPagination.searchById($scope.ubigeo.province_id,$scope.ubigeo.provinces);
                    $scope.districtSelected = ConfigPagination.searchById($scope.ubigeo.district_id,$scope.ubigeo.districts);
                }, 100);

                return true;
            }
            else{
                RESTService.all('ubigeo/departments', null, function (response) {
                    var last = response.results.length;
                    $scope.departments = response.results;
                    response.results[last] = {id: 0, code:'0', name:'Seleccione', value:0}
                    $scope.departmentSelected = response.results[last];
                    $scope.is_required_ubigeo = false;
                });
                return false;
            }
        }

        $scope.$on("fileProgress", function(e, progress) {
            $scope.progress = progress.loaded / progress.total;
        });

        $scope.changeTypeDocument = function () {
            $scope.client.document = null;
            if($scope.typeDocumentSelected.id == $scope.type_ruc.id){
               $scope.max_length_document = $scope.type_ruc.max_length;
            }
            else if($scope.typeDocumentSelected.id == $scope.type_dni.id)
                $scope.max_length_document = $scope.type_dni.max_length;
            else{
                $scope.max_length_document = 20;
            }
        }

        $scope.changeDepartment = function () {
            if($scope.departmentSelected.code == '0'){
                $("#provinceSelected").html('')
                $("#districtSelected").html('')
                delete $scope.provinceSelected;
                delete $scope.districtSelected;
                $scope.is_required_ubigeo = false;
            }
            else{
                $scope.is_required_ubigeo = true;
                getProvinces($scope.departmentSelected.code);
            }
        }

        $scope.changeDepartment = function () {
            if($scope.departmentSelected.code == '0'){
                $("#provinceSelected").html('')
                $("#districtSelected").html('')
                delete $scope.provinceSelected;
                delete $scope.districtSelected;
                $scope.is_required_ubigeo = false;
            }
            else{
                $scope.is_required_ubigeo = true;
                getProvinces($scope.departmentSelected.code);
            }
        }

        $scope.changeProvince = function () {
            if($scope.provinceSelected.code == '0'){
                $("#districtSelected").html('')
                delete $scope.districtSelected;
            }
            else{
                getDistricts($scope.provinceSelected.code);
            }
        }

        $scope.changeDistrict= function () {
            if($scope.districtSelected.code == '0'){
                delete $scope.districtSelected;
            }
        }

        function getProvinces(department_id) {
            RESTService.get('ubigeo/provinces', department_id, function (response) {
                $("#provinceSelected").html('')
                $("#districtSelected").html('')
                delete $scope.districtSelected;

                var last = response.results.length;
                response.results[last] = {id: 0, code:'0', name:'Seleccione', value:0}
                $scope.provinces = response.results;
                $scope.provinceSelected = response.results[last];
            });
        }

        function getDistricts(province_id) {
            delete $scope.districtSelected;
            RESTService.get('ubigeo/districts', province_id, function (response) {
                $("#districtSelected").html('')

                var last = response.results.length;
                response.results[last] = {id: 0, code:'0', name:'Seleccione', value:0}
                $scope.districts = response.results;
                $scope.districtSelected = response.results[last];
            });
        }

        function typeDocumentSelected(id) {
            if(!_.isUndefined(id)){
                $scope.typeDocumentSelected = ConfigPagination.searchById(id,$scope.type_documents);

                if($scope.typeDocumentSelected.id == $scope.type_ruc.id){
                    $scope.max_length_document = $scope.type_ruc.max_length;
                }
                else if($scope.typeDocumentSelected.id == $scope.type_dni.id)
                    $scope.max_length_document = $scope.type_dni.max_length;
                else{
                    $scope.max_length_document = 20;
                }
            }
        }

        function typeSelected(id) {
            if(!_.isUndefined(id)){
                $scope.typeSelected = ConfigPagination.searchById(id,$scope.types);
            }
        }

        function sexSelected(id) {
            if(!_.isUndefined(id)){
                $scope.sexSelected = ConfigPagination.searchById(id, $scope.sexs);
            }
        }

        function statusSelected(id) {
            if(!_.isUndefined(id)){
                $scope.statusSelected = ConfigPagination.searchById(id,$scope.status);
            }
        }

        function checkType(type_client) {
            if(type_client == CLIENT.TYPE[1].id){
                $scope.sexSelected = CLIENT.SEX[0];
                $scope.statusSelected = CLIENT.STATUS[0];

                $("#sexSelected").attr('disabled', 'disabled');
                $("#statusSelected").attr('disabled', 'disabled');
            }
            else{
                sexSelected($scope.client.sex);
                statusSelected($scope.client.status);
            }

        }

        $scope.changeType = function (typeSelected) {
            if(typeSelected.id == CLIENT.TYPE[1].id){
                $scope.sexSelected = CLIENT.SEX[0];
                $scope.statusSelected = CLIENT.STATUS[0];
                $("#sexSelected").attr('disabled', 'disabled');
                $("#statusSelected").attr('disabled', 'disabled');
            }
            else{
                $scope.sexSelected = CLIENT.SEX[0];
                $scope.statusSelected = CLIENT.STATUS[0];
                $("#sexSelected").removeAttr('disabled', 'disabled');
                $("#statusSelected").removeAttr('disabled', 'disabled');
            }
        }

        $scope.save = function () {
            if (validate()) {
                $scope.client['type_document'] = $scope.typeDocumentSelected.id;
                $scope.client['type_client'] = $scope.typeSelected.id;
                $scope.client['sex'] = $scope.sexSelected.id;
                $scope.client['status'] = $scope.statusSelected.id;

                $scope.client['is_required_ubigeo'] = $scope.is_required_ubigeo;

                // ubigeo data
                if($scope.is_required_ubigeo) {
                    $scope.client['department_id'] = $scope.departmentSelected.code;
                    $scope.client['province_id'] = $scope.provinceSelected.code;
                    $scope.client['district_id'] = $scope.districtSelected.code;
                }

                if($scope.action == 'create'){
                    RESTService.save('client/save', $scope.client, function (result) {
                        notifyAlert.success("Registro realizado con éxito!!");
                        $state.transitionTo('sales.clients', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
                else if($scope.action == 'edit'){
                    RESTService.updated('client/update', $scope.client.id, $scope.client, function (result) {
                        notifyAlert.success("Registro actualizado con éxito!!");
                        $state.transitionTo('sales.clients', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
            }
        };

        function validate() {
            if (_.isNull($scope.client.fullname) || _.isEmpty($scope.client.fullname)) {
                HelperFactory.show_AlertFactory('Debe ingresar el nombre del cliente');
                angular.element(document.querySelector('#client_fullname')).focus();
                return false;
            }
            if (_.isNull($scope.client.document) || _.isEmpty($scope.client.document)) {
                HelperFactory.show_AlertFactory('Debe ingresar el documento del cliente');
                angular.element(document.querySelector('#client_document')).focus();
                return false;
            }

            if($scope.is_required_ubigeo){
                if ($scope.districtSelected.code == 0 || _.isEmpty($scope.districtSelected.code)) {
                    HelperFactory.show_AlertFactory('Debe seleccionar un distrito');
                    angular.element(document.querySelector('#districtSelected')).focus();
                    return false;
                }
            }
            // if (_.isNull($scope.client.document) || _.isEmpty($scope.client.document)) {
            //     HelperFactory.show_AlertFactory('Debe ingresar el documento del cliente');
            //     angular.element(document.querySelector('#client_document')).focus();
            //     return false;
            // }

            return true;
        };

        $scope.close = function () {
            $state.transitionTo('sales.clients', null, {'reload': true});
        };

        // extract data by document
        $scope.extractDni = function () {
            $scope.service_alert = false;
            RESTService.get('services/dni', $scope.client.document, function (response) {
                if(response.success == true){
                    $scope.service_alert = true;
                    $scope.service_message = 'Los datos del cliente se extrajeron correctamente ';
                    replaceExtractDniData(response.data);
                }else{
                    notifyAlert.warning(response.message);
                }
            }, function (error) {
                return false;
            });

        }

        $scope.extractRuc = function () {
            $scope.service_alert = false;
            RESTService.get('services/ruc', $scope.client.document, function (response) {
                if(response.success == true){
                    $scope.service_alert = true;
                    $scope.service_message = 'El cliente se encuentra '+ response.data.status+ ' y '+ response.data.condition;
                    replaceExtractRucData(response.data);
                }else{
                    notifyAlert.warning(response.message);
                }
            }, function (error) {
                return false;
            });
        }

        function replaceExtractRucData(data) {
            $scope.client.fullname = data.name;
            $scope.client.address = data.address;
            $scope.ubigeo = data.ubigeo;
            checkUbigeo();
        }

        function replaceExtractDniData(data) {
            console.log(data);            
            $scope.client.fullname = data.fullname;
            $scope.client.address = data.address;
            // $scope.client.date_birthday = data.date_of_birthday;
        }

        // =============
    }


})();
