(function () {
    'use strict';
    angular.module('sys.app.eatery')
        .controller('EateryCtrl', EateryCtrl);

    EateryCtrl.$inject = ['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory','$timeout', 'notifyAlert', 'SEARCH', '$uibModal'];

    function EateryCtrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $timeout, notifyAlert, SEARCH, $uibModal) {

        $scope.entity = {};
        $scope.text= null;
        $scope.currentPage = 1;
        var object = "";

        // var start_range = moment().startOf('month');
        // var end_range = moment().endOf('month');
        //
        // $scope.start_range = start_range;
        // $scope.end_range = end_range;

        $scope.date_range = moment().format('YYYY-MM-DD');

        init();
        sync();

        function init() {
            object = "search=" + $scope.text + '&page=' + $scope.currentPage +
                "&start_range=" + $scope.date_range;
                // "&start_range=" + $scope.start_range.format('YYYY-MM-DD') + '&end_range=' + $scope.end_range.format('YYYY-MM-DD');

            RESTService.all('order/command/list', object, function (response) {
                $scope.allData = response.results;
                $scope.totalItems = response.total;
                $scope.itemsPerPage = response.paginate_by;
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        }

        function sync() {
            $timeout(function () {
                // $('#date_range').daterangepicker({
                //         locale: {
                //             format: 'MMM D, YYYY'
                //         },
                //         startDate: $scope.start_range,
                //         endDate: $scope.end_range,
                //         showDropdowns: true,
                //     },
                //     function (start, end, label) {
                //         $scope.start_range = start;
                //         $scope.end_range = end;
                //         init();
                //     }
                // );
                $('#date_range').daterangepicker({
                        locale: {
                            format: 'YYYY-MM-DD'
                        },
                        singleDatePicker: true,
                        showDropdowns: true,
                    }, function (start, end, label) {
                        $scope.date_range = start.format('YYYY-MM-DD');
                        init();
                    }
                );
            }, 50);
        };


        $scope.searchAction = function (text) {
            $scope.text = text;
            $scope.currentPage = 1;
            if (text.length >= SEARCH.MIN_LETTERS || text.length == 0) {
                delete $scope.allData;
                init();
            }
        };

        $scope.refresh = function () {
            delete $scope.allData;
            $state.transitionTo('sales.eatery', {entity: null}, {'reload': true});
        };


        $scope.new = function () {
            var source = {'sale': {'id':0 }};
            $state.transitionTo('sales.eatery.new', {entity: source}, {
                'reload': 'sales.eatery.new',
                'cache': false
            });
            delete $scope.allData;
        };

        // $scope.edit = function (source) {
        //     delete $scope.allData;
        //     RESTService.get('sales/edit', source.id, function (response) {
        //         $state.transitionTo("sales.eatery.edit", {
        //             'id': source.id,
        //             entity: response.data
        //         }, {'reload': "sales.eatery.edit", 'cache': false});
        //     }, function (error) {
        //         console.log('ERROR');
        //         return false;
        //     });
        //
        // };

        $scope.edit = function (source) {
            delete $scope.allData;
            RESTService.get('order/command/edit', source.id, function (response) {
                $state.transitionTo("sales.eatery.edit", {
                    'id': source.id,
                    entity: response.data
                }, {'reload': "sales.eatery.edit", 'cache': false});
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };

        $scope.detail = function (source) {
            delete $scope.allData;
            RESTService.get('sales/detail', source.id, function (response) {
                $state.transitionTo("sales.eatery.detail", {
                    'id': source.id,
                    entity: response.data
                }, {'reload': "sales.eatery.detail", 'cache': false});
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };

        $scope.pageChanged = function(page) {
            $scope.currentPage = page;
            delete $scope.allData;
            init();
        };

        $scope.printVoucher = function (item) {
            window.open('/print/billing/document/'+item);
        }

        $scope.printCommand = function (item) {
            window.open('/print/command/document/'+item);
        }

        $scope.delete = function (item) {
            var options = {
                title: "Cuidado!!",
                message: "El registro ' "+item.code+" ' será eliminado",
                cancel: "Cancelar",
                confirm: "Eliminar"
            };
            AlertFactory.confirm(options, function () {
                RESTService.deleted('order/command/delete', item.id, function (response) {
                    notifyAlert.success("El item se ha eliminado con éxito!!");
                    var obj = {"text": $scope.text};
                    $state.transitionTo('sales.eatery', {entity: obj}, {'reload': true});
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });

            })
        };


        $scope.associateSale = function (sale_id) {
            RESTService.get('sales/detail', sale_id, function (response) {
                var obj = {'data': response.data};
                $uibModal.open({
                    animation: true,
                    templateUrl: '../../templates/sales/sale/modaldetail.html',
                    controller: 'ModalDetailSaleCtrl',
                    size: 'modal-dialog modal-lg',
                    backdrop: 'static',
                    appendTo: angular.element(document.querySelector('#wrapper')),
                    resolve: {
                        PARAM: function () {
                            return obj;
                        }
                    }
                });
            });
        };
        
    }

})();
