(function () {
    'use strict';

    angular.module('sys.utils.utils')
        .controller('InformationDeliveryCtrl', InformationDeliveryCtrl);

    InformationDeliveryCtrl.$inject = ['$scope', '$state', 'RESTService', 'notifyAlert', '_', 'HelperFactory', 'ConfigPagination', 'PARAM', '$uibModalInstance', '$timeout'];

    function InformationDeliveryCtrl($scope, $state, RESTService, notifyAlert, _, HelperFactory, ConfigPagination, PARAM, $uibModalInstance, $timeout) {

        var loading;
        $scope.get_param = PARAM;
        $scope.entity = $scope.get_param.entity;

        if($scope.get_param.is_new){
            $scope.txt_title = 'Registrar';
            $scope.action = 'create';
            $scope.delivery = {
                'id': 0,
                'description': null,
                'cellphone': null,
                'address':null,
                'email': null,
                'delivery_date':null,
                'delivery_time':null,
                'observation':null
            };
        }
        else{
            $scope.delivery = $scope.entity;
            $timeout(function () {
                angular.element(document.querySelector('#delivery_time')).val($scope.delivery.delivery_time);
            }, 100);
        }

        init();
        function init() {
            $timeout(function () {
                $('#delivery_date').daterangepicker({
                        locale: {
                            format: 'YYYY-MM-DD'
                        },
                        singleDatePicker: true,
                        showDropdowns: true,
                        minDate: moment()
                    }, function (start, end, label) {
                    }
                );

                loading = angular.element(document.querySelector('#loading_modal'));
                angular.element(document.querySelector('#delivery_description')).focus();
            }, 100);
        }

        $scope.save = function () {
            if (validate()) {
                loading.show();
                $scope.delivery["delivery_time"]= $("#delivery_time").val();

                if (!$scope.get_param.is_edit) {
                    notifyAlert.success("Registro realizado con éxito!!");
                    $uibModalInstance.close($scope.delivery);
                } else {
                    notifyAlert.success("Datos modificados con éxito!!");
                    $uibModalInstance.close($scope.delivery);
                }
            }
        };

        function validate() {
            if (_.isNull($scope.delivery.description) || _.isEmpty($scope.delivery.description)) {
                HelperFactory.show_AlertFactory('Debe ingresar la referencia');
                angular.element(document.querySelector('#delivery_description')).focus();
                return false;
            }

            if (_.isNull($scope.delivery.cellphone) || _.isEmpty($scope.delivery.cellphone)) {
                HelperFactory.show_AlertFactory('Debe ingresar el telefono de contacto');
                angular.element(document.querySelector('#delivery_cellphone')).focus();
                return false;
            }

            return true;
        };

        $scope.closeModal = function () {
            $uibModalInstance.dismiss();
        };
    }


})();

