(function () {
    'use strict';
    angular.module('sys.app.eatery.new')
        .controller('NewEateryCtrl', NewEateryCtrl);

    NewEateryCtrl.$inject = ['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory', '$timeout', 'notifyAlert', 'SEARCH', 'HelperFactory', 'CLIENT', '$uibModal', '$stateParams', 'TYPE_DOCUMENT', 'VOUCHER', 'PRODUCT', 'TRANSACTION', 'PAYMENT_METHOD'];

    function NewEateryCtrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $timeout, notifyAlert, SEARCH, HelperFactory, CLIENT, $uibModal, $stateParams, TYPE_DOCUMENT, VOUCHER, PRODUCT, TRANSACTION, PAYMENT_METHOD) {

        var quantity_default = 1;
        $scope.date_sale_now = moment().format('dddd D, MMM Y');
        $scope.max_lenght_grouped = 255;

        $scope.subtotal = 0;
        $scope.total_igv = 0;
        $scope.total_sale = 0;
        $scope.text_amount = null;
        // paid form
        $scope.total_paid = 0;
        $scope.turned = 0;

        $scope.client = null;
        $scope.client_default = false;

        $scope.employee = null;

        $scope.sale_cash = TRANSACTION.TYPES[0];
        $scope.sale_credit = TRANSACTION.TYPES[1];
        $scope.intervalDates = TRANSACTION.INTERVALS;
        $scope.intervalDateSelected = TRANSACTION.INTERVALS[0];

        $scope.paymethod_deposit = PAYMENT_METHOD['deposit'];

        $scope.text = null;

        var typeprice = PRODUCT.TYPEPRICE;
        $scope.is_price_general = typeprice[0];
        $scope.is_price_unit = typeprice[1];
        $scope.is_price_variant = typeprice[2];

        var boxPaid, boxProduct, boxDetail, btnsBoxDetail;

        $scope.currentPage = 1;

        $scope.bankaccounts = [];
        $scope.categoryfood = [];

        $scope.is_remake = false;
        $scope.data_remake = {};

        $scope.client_data = {};
        $scope.paid = {};

        $scope.delivery = {};

        $scope.status_command = false;

        try {
            $scope.check_sale = $stateParams.entity.sale;
            if (!_.isNull($scope.check_sale.id)) {
                $scope.entity = $stateParams.entity.sale;
                $scope.sale = $stateParams.entity.sale;

                if ($scope.sale.id != 0) {
                    $scope.txt_title = 'Editar'
                    $scope.action = 'edit';
                    $scope.is_edit = true;

                    $scope.status_command = $scope.sale.status_command;
                    $scope.warehousesSelected = {id:1};

                    $scope.is_remake = true;
                    $scope.data_remake = $stateParams.entity;
                    $scope.cart = $stateParams.entity.detail;
                    $scope.delivery = {};

                    if($scope.sale.is_delivered){
                        $scope.delivery = $stateParams.entity.delivery;
                    }

                    $timeout(function () {
                        sum_items()
                    }, 50);
                }
                else {
                    $scope.txt_title = 'Registrar';
                    $scope.action = 'create';
                    $scope.is_edit = false;
                    $scope.cart = [];
                    $scope.sale = {
                        'is_igv': false,
                        'is_grouped': false,
                        'description_grouped': null,
                        'is_order': false,
                        'order_id': null,
                        'is_proforma': false,
                        'proforma_id': null,
                        'observation': null,
                        'number_table': null,
                        'reference': null,
                        'is_delivered': false,
                    };
                    $scope.paid = {
                        'is_paid': false,
                        'document': null,
                        'address': null,
                        'reference_operation': null,
                    };

                    $scope.schedule = {
                        'number_quota': null,
                        'first_date_schedule': null
                    };
                }
            }
        }
        catch (e) {
            $state.transitionTo('sales.eatery', null, {'reload': true});
            console.log(e);
            return false;
        }

        sync();

        function sync() {

            $scope.voucher_ruc = VOUCHER['FACTURA'];

            RESTService.all('config/typetransaction', null, function (response) {
                $scope.transactions = response.results;
                $scope.transactionSelected = response.results[0];
            });

            RESTService.all('warehouses/branchoffice', null, function (response) {
                $scope.warehouses = response.results;
                $scope.warehousesSelected = response.results[0];

            });

            RESTService.all('config/paymentmethod', null, function (response) {
                $scope.paymentmethods = response.results;
                $scope.paymentSelected = response.results[0];
            });

            RESTService.all('config/typevoucher/sale', null, function (response) {
                $scope.typevouchers = response.results;
                $scope.typeVoucherSelected = response.results[0];
            });

            RESTService.all('config/tax', null, function (response) {
                $scope.igv = response.results[0].percentage;
            });

            RESTService.all('config/currency', null, function (response) {
                $scope.currency = response.results;
                $scope.currencySelected = response.results[0];
            });


            getCategories();


            $timeout(function () {
                $('#date_order').daterangepicker({
                    locale: {
                        format: 'YYYY-MM-DD'
                    },
                    singleDatePicker: true,
                    showDropdowns: true,
                    minDate: new Date()
                });

                // divs hide actions

                boxPaid = $(".boxPaid");
                boxProduct = $(".boxProduct");
                boxDetail = $(".boxDetail");
                btnsBoxDetail = $(".btnsBoxDetail");

            }, 50);

            $timeout(function () {
                if ($scope.is_remake == true) {
                    remakeSale($scope.data_remake);
                }
            }, 1000);
        }

        function remakeSale(result) {
            $scope.cart = [];
            var data = result;

            var order = data.sale;
            var products_order = data.detail;

            $scope.client = order.client_id;

            $.each(products_order, function (i, product) {
                product.warehouse_id = $scope.warehousesSelected.id;
                $scope.cart.push(product);
            });

            $timeout(function () {
                $.each(products_order, function (i, product) {
                    var index = i;
                    var units = product.unitsmeasure;

                    $("#unitSelected" + index).html('');
                    $.each(units, function (i, item) {
                        $("#unitSelected" + index).append($('<option>', {
                            value: item.id,
                            text: item.description
                            // text: item.description + ' (' + item.equivalence + ')'
                        }));
                    });

                    $("#unitSelected" + index).val(product.unitmeasure_id);
                    var pos = $scope.cart.indexOf(product);
                    $scope.cart[pos].unit_id = product.unitmeasure_id;

                    if(product.typeprice_id == $scope.is_price_variant.id){
                        $("#unitSelected" + index).val(product.productvariant_id);
                        var pos = $scope.cart.indexOf(product);
                        $scope.cart[pos].variant_id = product.productvariant_id;
                    }

                });

                sum_items();


                if($scope.status_command == true){

                    $scope.sale.is_igv = false;
                    $scope.sale.is_grouped = false;
                    $scope.sale.description_grouped = null;
                    $scope.sale.is_order = false;
                    $scope.sale.order_id = $scope.sale.id;
                    $scope.sale.is_proforma = false;
                    $scope.sale.proforma_id = null;

                    // $scope.sale = {
                    //     'is_igv': false,
                    //     'is_grouped': false,
                    //     'description_grouped': null,
                    //     'is_order': false,
                    //     'order_id': null,
                    //     'is_proforma': false,
                    //     'proforma_id': null,
                    //     'observation': null,
                    //     'is_delivered': false,
                    // };
                    $scope.paid = {
                        'is_paid': false,
                        'document': null,
                        'address': null,
                        'reference_operation': null,
                    };

                    $scope.schedule = {
                        'number_quota': null,
                        'first_date_schedule': null
                    };

                    $scope.changeToPaid();
                }

            }, 100);
        };

        function getCategories() {
            $scope.products = [];
            $scope.categoryfood = [];
            $scope.categoy_selected = false;
            RESTService.all('category/search/all', null, function (response) {
                $scope.categoryfood = response.results;
            });
        };

        $scope.backToCategories = function () {
            getCategories();
        };

        $scope.selectIsGrouped = function (is_grouped) {
            $timeout(function () {
                angular.element(document.querySelector('#description_grouped')).focus();
            }, 50);
        };

        function getSerieVoucher(voucher_id) {
            RESTService.get('config/voucher/serie', voucher_id, function (response) {
                $scope.series = response.results;
                $scope.serieSelected = response.results[0];
            });
        };

        $scope.changeTypeTransacation = function (transaction) {
            if (transaction.id == $scope.sale_cash.id) {// venta al contado
                //
            }
            else if (transaction.id == $scope.sale_credit.id) {

                $timeout(function () {
                    $('#first_date_schedule').datepicker({
                        dateFormat: 'yy-mm-dd',
                        autoclose: true,
                        minDate: new Date(),
                    });

                    $('[data-toggle="tooltip"]').tooltip();

                }, 100);

            }
        }

        $scope.changeTypeVoucher = function (typeVoucher) {
            $scope.typeVoucherSelected = typeVoucher;
            if (typeVoucher.id == $scope.voucher_ruc) {
                if ($scope.client_default) {
                    angular.element(document.querySelector('#search_client_value')).removeAttr('disabled').focus();
                    angular.element(document.querySelector('#search_client_value')).val('');
                    $scope.client = null;
                    $scope.client_default = false;
                    $scope.$broadcast('angucomplete-alt:clearInput', 'search_client');
                }
            }
            ;

            getSerieVoucher($scope.typeVoucherSelected.id);
        }

        $scope.changeToPaid = function () {
            boxProduct.hide("slide", {direction: "right"}, 50, function () {
                boxPaid.css("display", "block");
                btnsBoxDetail.css("display", "none");

                $('[data-toggle="tooltip"]').tooltip();
                angular.element(document.querySelector('#search_client_value')).focus();
                $scope.paid.is_paid = true;

                $timeout(function () {
                    getSerieVoucher($scope.typeVoucherSelected.id);
                }, 1000);

            });
        }

        $scope.changeToProduct = function () {
            boxPaid.hide("slide", {direction: "right"}, 50, function () {
                boxProduct.css("display", "block");
                btnsBoxDetail.css("display", "block");
                $scope.paid.is_paid = false;
                getListProducts($scope.warehousesSelected);
            });
        };

        $scope.changePayment = function (item) {
            $scope.paymentSelected = item;
            if (item.id == $scope.paymethod_deposit.id) {
                RESTService.all('accountbanks/search/all', null, function (response) {
                    $scope.bankaccounts = response.results;
                    $scope.bankaccounts_exists = false;
                    if ($scope.bankaccounts.length > 0) {
                        $scope.bankaccounts_exists = true;
                        $scope.bankAccountSelected = response.results[0];
                    }
                });
            }
        };

        $scope.changeBankAccount = function (item) {
            $scope.bankAccountSelected = item;
        };

        $scope.changeIntervalDate = function (intervalDate) {
            $scope.intervalDateSelected = intervalDate;
        }

        $scope.changeDelivery = function (item) {
            $scope.sale.is_delivered = item;
            if(item){
                $scope.sale.number_table = null;
            }
        };

        $scope.selectClientDefault = function (client_default) {
            if (client_default) {
                $scope.client = CLIENT.DEFAULT;
                $scope.paid.document = null;
                $scope.paid.address = null;
                $timeout(function () {
                    $(".removeClient").hide();
                    angular.element(document.querySelector('#search_client_value')).attr('disabled', 'disabled');
                    angular.element(document.querySelector('#search_client_value')).val('VARIOS');
                }, 100);
            } else {
                $(".removeClient").show();
                angular.element(document.querySelector('#search_client_value')).removeAttr('disabled').focus();
                angular.element(document.querySelector('#search_client_value')).val('');
                $scope.client = null;
                $scope.$broadcast('angucomplete-alt:clearInput', 'search_client');
            }
        }

        $scope.reloadProduct = function () {
            $scope.text = null;
            angular.element(document.querySelector('#searchInput')).val(null).focus();
            delete $scope.products;
            getListProducts($scope.warehousesSelected);
        };

        $scope.changeWarehousesSelected = function (item) {
            $scope.warehousesSelected = item;
            getListProducts(item);
        }

        function getListProducts(warehouse) {
            var url = 'product/sale/search';
            var object = "search=" + $scope.text + '&warehouse_id=' + warehouse.id;
            $scope.products_favorites = false;

            if (_.isNull($scope.text) || $scope.text.length == 0) {
                url = 'product/favorite/';
                object = "warehouse_id=" + warehouse.id + '&page=' + $scope.currentPage;
                $scope.products_favorites = true;
            }

            RESTService.all(url, object, function (response) {
                $scope.products = response.data;
                if ($scope.products_favorites) {
                    $scope.totalItems = response.total;
                    $scope.itemsPerPage = response.paginate_by;
                }
                else {
                    $scope.currentPage = 1;
                }
            });
        };


        $scope.getFoodByCategory = function (category) {
            var url = 'product/by_category';
            var object = "category_id=" + category.id
            $scope.categoy_selected = true;
            $scope.category_description = category.description;
            $scope.category_ = category;

            RESTService.all(url, object, function (response) {
                $scope.products = response.data;
                // $scope.totalItems = response.total;
                // $scope.itemsPerPage = response.paginate_by;
                // $scope.currentPage = 1;
            });
        }

        $scope.pageChanged = function (page) {
            $scope.currentPage = page;
            delete $scope.allData;
            getListProducts($scope.warehousesSelected);
        };

        $scope.$on("fileProgress", function (e, progress) {
            $scope.progress = progress.loaded / progress.total;
        });

        $scope.selectedClient = function (response) {
            if (!_.isUndefined(response)) {
                var data = response.originalObject;
                $scope.client_data = data;
                $scope.client = data.id;
                $scope.type_document = data.typeDocument;
                $scope.paid.document = data.document;
                $scope.paid.address = data.address;
                angular.element(document.querySelector('#search_client_value')).attr('disabled', 'disabled');
            }
        }

        $scope.removeClient = function () {
            angular.element(document.querySelector('#search_client_value')).removeAttr('disabled').focus();
            angular.element(document.querySelector('#search_client_value')).val('');
            $scope.client = null;
            $scope.paid.document = null;
            $scope.paid.address = null;
            $scope.$broadcast('angucomplete-alt:clearInput', 'search_client');
        }

        $scope.selectedEmployee = function (response) {
            if (!_.isUndefined(response)) {
                var data = response.originalObject;
                $scope.employee = data.id;
                $scope.employe_data = data;
                angular.element(document.querySelector('#search_employee_value')).attr('disabled', 'disabled');
            }
        };

        $scope.removeEmployee = function () {
            angular.element(document.querySelector('#search_employee_value')).removeAttr('disabled').focus();
            angular.element(document.querySelector('#search_employee_value')).val('');
            $scope.employee = null;
            $scope.$broadcast('angucomplete-alt:clearInput', 'search_employee');
        };

        $scope.searchAction = function (text) {
            $scope.text = text;
            if (text.length >= SEARCH.MIN_LETTERS || text.length == 0) {
                delete $scope.products;
                getListProducts($scope.warehousesSelected);
            }
        };

        $scope.listPriceUnit = function (product) {
            var obj = {
                'product': product,
                'currency': $scope.currencySelected
            };
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/sales/sale/priceunits.html',
                controller: 'ExtendsPriceUnitsCtrl',
                size: 'modal-dialog modal-dialog-centered',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                // init();
            });
        };

        function refreshDomProducts() {
            if($scope.categoy_selected == true){
                $scope.getFoodByCategory($scope.category_)
            }
        };

        $scope.addItem = function (item) {
            var valid_stock = validExistStock(item);
            if (valid_stock) {
                var unique = ifExist(item);
                if (unique) {
                    item.detail_id = null;
                    item.quantity = quantity_default;
                    item.price = item.price_sale;
                    item.igv = 0;
                    item.detail = null;
                    item.warehouse_id = $scope.warehousesSelected.id;

                    var subtotal_ = Number(Number(item.price) * Number(item.quantity)).toFixed(2);
                    item.subtotal = subtotal_;

                    $scope.cart.push(item);
                    var last = $scope.cart.length;

                    $timeout(function () {
                        listUnitMeasureProduct(last, item);
                    }, 50);

                    $timeout(function () {
                        sum_items();
                    }, 300);

                    if(item.typeprice_id == $scope.is_price_variant.id || item.typeprice_id == $scope.is_price_unit.id){
                        refreshDomProducts();
                    };
                }
                else {
                    notifyAlert.warning('El producto ' + item.description + ' ya se encuentra agregado');
                }
            }
        };

        function validExistStock(item) {
            var response = true
            if (item.is_control_stock) {
                $.each(item.productstock, function (i, stock) {
                    if (stock.warehouse_id == $scope.warehousesSelected.id && stock.stock == 0) {
                        notifyAlert.error('El producto ' + item.description + ' no cuenta con stock suficiente en el almacén ' + $scope.warehousesSelected.description);
                        response = false;
                        return false;

                    }
                });
            }
            return response;
        }

        function listUnitMeasureProduct(pos, product) {
            var index = pos - 1;
            var units = product.unitsmeasure;
            $("#unitSelected" + index).html('');
            $.each(units, function (i, item) {
                if ($scope.is_price_variant.id == product.typeprice_id) {
                    if (item.is_active) {
                        $("#unitSelected" + index).append($('<option>', {
                            value: item.id,
                            text: item.description
                        }));
                    }
                } else {
                    $("#unitSelected" + index).append($('<option>', {
                        value: item.id,
                        // text : item.description + ' ('+item.equivalence+')'
                        text: item.description
                    }));
                }
            });

            $("#unitSelected" + index).val(units[0].id);
            // $("#unitSelected" + index).attr('disabled', 'disabled');
            $(".completeDescription").tooltip();

            var pos = $scope.cart.indexOf(product);

            $scope.cart[pos].unit_id = units[0].id;

            if (product.typeprice_id == $scope.is_price_unit.id) {
                $scope.cart[pos].price = units[0].price_sale;
                $scope.cart[pos].price_sale = units[0].price_sale;
                var subtotal_ = Number(Number(units[0].price_sale) * Number($scope.cart[pos].quantity)).toFixed(2);
                $scope.cart[pos].subtotal = subtotal_;
            }


            if (product.typeprice_id == $scope.is_price_variant.id) {
                $scope.cart[pos].unit_id = units[0].unit_id;
                $scope.cart[pos].variant_id = units[0].id;
                $scope.cart[pos].price = units[0].price;
                $scope.cart[pos].price_sale = units[0].price;
                var subtotal_ = Number(Number(units[0].price) * Number($scope.cart[pos].quantity)).toFixed(2);
                $scope.cart[pos].subtotal = subtotal_;
            }
        };

        $scope.change_unitmeasure = function (unitSelected, product, $index) {
            var check_unit = angular.element(document.querySelector('#unitSelected' + $index)).val();
            var pos = $scope.cart.indexOf(product);

            if (product.typeprice_id == $scope.is_price_unit.id) {
                var unit_price = ConfigPagination.searchById(unitSelected, product.unitsmeasure);
                $scope.cart[pos].unit_id = check_unit;
                $scope.cart[pos].price = unit_price.price_sale;
                $scope.cart[pos].price_sale = unit_price.price_sale;

                $("#price" + $index).val(unit_price.price_sale);

                var subtotal_ = Number(Number(unit_price.price_sale) * Number($scope.cart[pos].quantity)).toFixed(2);
                $scope.cart[pos].subtotal = subtotal_;

                $timeout(function () {
                    sum_items();
                }, 300);
            }

            if (product.typeprice_id == $scope.is_price_variant.id) {
                var unit_price = ConfigPagination.searchById(unitSelected, product.unitsmeasure);
                $scope.cart[pos].variant_id = check_unit;
                $scope.cart[pos].price = unit_price.price;
                $scope.cart[pos].price_sale = unit_price.price;

                $("#price" + $index).val(unit_price.price);

                var subtotal_ = Number(Number(unit_price.price) * Number($scope.cart[pos].quantity)).toFixed(2);
                $scope.cart[pos].subtotal = subtotal_;

                $timeout(function () {
                    sum_items();
                }, 300);
            }
        };
        $scope.removeItem = function ($event, product, $index) {
            $event.preventDefault();
            var index = $scope.cart.indexOf(product);
            $scope.cart.splice(index, 1);
            $timeout(function () {
                sum_items();
            }, 300);
            notifyAlert.info("El producto " + product.description + ' ha sido removido del detalle');
        };

        function ifExist(obj) {
            if (obj.typeprice_id == $scope.is_price_general.id) {
                var cart = $scope.cart;
                var is_unique = true;
                for (var key in cart) {
                    if (cart[key].id === Number(obj.id)) {
                        is_unique = false;
                        break;
                    }
                }
                return is_unique;
            }
            else{
                return true;
            }
        };

        $scope.recalculate_quantity = function (count, product, $index) {
            var check_quantity = angular.element(document.querySelector('#quantity' + $index)).val();
            var q_ = check_quantity;

            angular.element(document.querySelector('#quantity' + $index)).val(q_);

            var quantity = angular.element(document.querySelector('#quantity' + $index)).val();

            if (!_.isNaN(quantity * 1)) {
                var index = $scope.cart.indexOf(product);
                var subtotal = (Number(quantity) * Number($scope.cart[index].price))
                $scope.cart[index].quantity = quantity;
                $scope.cart[index].subtotal = subtotal;
                $timeout(function () {
                    sum_items();
                }, 300);
            }
        };

        $scope.recalculate_price = function (price, product, $index) {

            var check_price = angular.element(document.querySelector('#price' + $index)).val();
            var q_ = check_price;

            angular.element(document.querySelector('#price' + $index)).val(q_);

            var price_get = angular.element(document.querySelector('#price' + $index)).val();

            if (!_.isNaN(price_get * 1)) {
                // if (_.isNull(price) || _.isEmpty(price) || _.isUndefined(price)) {
                //     price = 1;
                //     angular.element('#price' + $index).val(price);
                // }

                var index = $scope.cart.indexOf(product);

                $scope.cart[index].subtotal = (Number(product.quantity) * Number(price_get)).toFixed(2);
                $scope.cart[index].price = Number(price_get);
                $timeout(function () {
                    sum_items();
                }, 300);
            }
        };

        $scope.recalculate_turned = function (price) {

            var check_price = angular.element(document.querySelector('#total_received')).val();
            var q_ = check_price;

            angular.element(document.querySelector('#total_received')).val(q_);

            var price_get = angular.element(document.querySelector('#total_received')).val();

            if (!_.isNaN(price_get * 1)) {

                if (Number(price_get) > Number($scope.total_paid)) {
                    $scope.turned = (Number(price_get) - Number($scope.total_paid)).toFixed(2);
                }
                else {
                    $scope.turned = 0;
                }
            }
        };

        function sum_items() {
            $scope.subtotal = 0;
            $scope.total_sale = 0;
            for (var i in $scope.cart) {
                var item = $scope.cart[i];
                $scope.subtotal = (Number($scope.subtotal) + Number(item.price) * Number(item.quantity)).toFixed(2);
            }

            $scope.total_sale = (Number($scope.subtotal)).toFixed(2);
            $scope.text_amount = numero.letras($scope.total_sale);

            // paid data
            $scope.total_paid = $scope.total_sale;
            $scope.total_received = null;
            angular.element(document.querySelector('#total_received')).val('');
            $scope.turned = 0;
        };


        $scope.saveCommand = function () {
            $scope.order = {};
            if (validateCommand()) {
                var data = {};
                $scope.order['subtotal'] = $scope.subtotal;
                $scope.order['total'] = $scope.total_sale;
                $scope.order['text_amount'] = $scope.text_amount;
                $scope.order['date_order'] = $scope.date_sale_now;
                $scope.order['observation'] = $scope.sale.observation;
                $scope.order['number_table'] = $scope.sale.number_table;
                $scope.order['reference'] = $scope.sale.reference;
                $scope.order['is_delivered'] = $scope.sale.is_delivered;

                data.order = $scope.order;
                data.detail = $scope.cart;
                data.delivery = $scope.delivery;


                var options = {
                    title: "¡Atención!",
                    message: "¿Esta seguro(a) de confirmar el pedido?",
                    cancel: "Cancelar",
                    confirm: "Confirmar"
                };
                AlertFactory.confirmWarning(options, function () {
                    RESTService.save('order/command/save', data, function (result) {
                        notifyAlert.success("Registro realizado con éxito!!");
                        $state.transitionTo('sales.eatery', null, {'reload': true});
                    });
                });
            }
        }

        $scope.editCommand = function () {
            $scope.order = {};
            if (validateCommand()) {
                var data = {};
                $scope.order['subtotal'] = $scope.subtotal;
                $scope.order['total'] = $scope.total_sale;
                $scope.order['text_amount'] = $scope.text_amount;
                $scope.order['date_order'] = $scope.date_sale_now;
                $scope.order['observation'] = $scope.sale.observation;
                $scope.order['number_table'] = $scope.sale.number_table;
                $scope.order['is_delivered'] = $scope.sale.is_delivered;

                data.order = $scope.order;
                data.detail = $scope.cart;
                data.delivery = $scope.delivery;

                var options = {
                    title: "GUARDAR CAMBIOS",
                    message: "¿Esta seguro(a) de aplicar los cambios a la comanda N° "+$scope.sale.code+" ?",
                    cancel: "Cancelar",
                    confirm: "Guardar cambios"
                };

                AlertFactory.confirmWarning(options, function () {
                    RESTService.updated('order/command/update', $scope.sale.id, data, function (result) {
                        notifyAlert.success("Cambios realizados con éxito!!");
                        $scope.selfUpdate($scope.sale.id);
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                });
            }
        }

        $scope.savePaid = function () {
            if (validate()) {
                $scope.sale['client_id'] = $scope.client;
                $scope.sale['typetransaction_id'] = $scope.transactionSelected.id;
                $scope.sale['igv'] = $scope.total_igv;
                $scope.sale['subtotal'] = $scope.subtotal;
                $scope.sale['total'] = $scope.total_sale;

                $scope.paid['client_default'] = $scope.client_default;
                $scope.paid['currency_id'] = $scope.currencySelected.id;
                $scope.paid['typevoucher_id'] = $scope.typeVoucherSelected.id;
                $scope.paid['paymentmethod_id'] = $scope.paymentSelected.id;
                $scope.paid['serie'] = $scope.serieSelected.series;
                $scope.paid['text_amount'] = $scope.text_amount;

                var accountbank_id = null;
                if ($scope.bankaccounts.length > 0) {
                    if ($scope.paymentSelected.id == $scope.paymethod_deposit.id) {
                        accountbank_id = $scope.bankAccountSelected.id;
                    }
                }

                $scope.paid['accountbank_id'] = accountbank_id;

                var data = {};
                data.sale = $scope.sale;
                data.paid = $scope.paid;
                data.detail = $scope.cart;

                var options = {
                    title: "¡Atención!",
                    message: "¿Esta seguro(a) de confirmar el pago de la venta?",
                    cancel: "Cancelar",
                    confirm: "Confirmar"
                };


                if ($scope.transactionSelected.id == $scope.sale_credit.id) {
                    options.message = "¿Esta seguro(a) de confirmar la venta al crédito?";
                    $scope.schedule['interval_schedule'] = $scope.intervalDateSelected.id;

                    data.schedule = $scope.schedule;
                }

                AlertFactory.confirmWarning(options, function () {
                    RESTService.save('sales/save/command', data, function (result) {
                        notifyAlert.success("Registro realizado con éxito!!");

                        if (result.billing != false) {
                            var billing = result.billing;
                            var label;
                            label = '<span class="badge badge-success f-s-12 p-5">' + billing.message + '</span>';

                            if (billing.code == 'pending') {
                                label = '<span class="badge badge-warning f-s-12 p-5">' + billing.message + '</span>';
                            }

                            swal({
                                title: "EN HORA BUENA!",
                                html: '<b>Venta registrada correctamente</b>, desea imprimir el comprobante?</br></br>' + label + ' ',
                                type: "success",
                                showCancelButton: true,
                                confirmButtonColor: "#30419b",
                                cancelButtonClass: 'btn btn-secondary ml-2',
                                confirmButtonText: 'Imprimir <i class="fas fa-print m-r-5"></i>',
                                cancelButtonText: "Cancelar",
                            }).then(function (isConfirm) {
                                if (isConfirm.value == true) {
                                    window.open('/print/billing/document/' + result.sale.id);
                                } else {

                                }
                            });
                        } else {
                            swal({
                                title: "EN HORA BUENA!",
                                html: '<b>Venta registrada correctamente</b>, desea imprimir el comprobante?',
                                type: "success",
                                showCancelButton: true,
                                confirmButtonColor: "#30419b",
                                cancelButtonClass: 'btn btn-secondary ml-2',
                                confirmButtonText: 'Imprimir <i class="fas fa-print m-r-5"></i>',
                                cancelButtonText: "Cancelar",
                            }).then(function (isConfirm) {
                                if (isConfirm.value == true) {
                                    window.open('/print/billing/document/' + result.sale.id);
                                } else {

                                }
                            });
                        }

                        $state.transitionTo('sales.eatery', null, {'reload': true});

                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                });
            }
        };

        function validate() {
            if ($scope.cart.length === 0) {
                HelperFactory.show_AlertFactory('Debe ingresar por lo menos un producto al detalle');
                return false;
            }

            // check quantity
            for (var i in $scope.cart) {
                if (Number($scope.cart[i].quantity) == 0 || _.isNull($scope.cart[i].quantity)) {
                    HelperFactory.show_AlertFactory('La cantidad del producto ' + $scope.cart[i].description + ' no puede ser igual a cero o estar vacío.');
                    angular.element(document.querySelector('#quantity' + i)).focus();
                    return false;
                }
            }

            // check price
            for (var i in $scope.cart) {
                if (Number($scope.cart[i].price) == 0 || _.isNull($scope.cart[i].price)) {
                    HelperFactory.show_AlertFactory('El precio del producto ' + $scope.cart[i].description + ' no puede ser igual a cero o estar vacío.');
                    angular.element(document.querySelector('#price' + i)).focus();
                    return false;
                }
            }

            if (_.isNull($scope.client) || _.isUndefined($scope.client)) {
                HelperFactory.show_AlertFactory('Debe seleccionar al cliente');
                angular.element(document.querySelector('#search_client_value')).focus();
                return false;
            }
            ;

            if (!_.isNull($scope.client) || !_.isUndefined($scope.client)) {

                if ($scope.typeVoucherSelected.id == VOUCHER.FACTURA) {
                    if ($scope.client_data.typedocument_id == TYPE_DOCUMENT['RUC'].id) {
                        return true;
                    }
                    else {
                        HelperFactory.show_AlertFactory('Para la emisión de facturas electrónicas, el documento del cliente debe ser de tipo RUC.');
                        angular.element(document.querySelector('#search_client_value')).focus();
                        return false;
                    }
                }
            }
            ;

            if (_.isUndefined($scope.total_sale) || $scope.total_sale == 0) {
                HelperFactory.show_AlertFactory('El total de la venta no puede ser igual a cero');
                return false;
            }
            ;

            return true;
        };

        function validateCommand() {

            if ($scope.cart.length === 0) {
                HelperFactory.show_AlertFactory('Debe ingresar por lo menos un producto al detalle');
                return false;
            }

            // check quantity
            for (var i in $scope.cart) {
                if (Number($scope.cart[i].quantity) == 0 || _.isNull($scope.cart[i].quantity)) {
                    HelperFactory.show_AlertFactory('La cantidad del producto ' + $scope.cart[i].description + ' no puede ser igual a cero o estar vacío.');
                    angular.element(document.querySelector('#quantity' + i)).focus();
                    return false;
                }
            }

            // check price
            for (var i in $scope.cart) {
                if (Number($scope.cart[i].price) == 0 || _.isNull($scope.cart[i].price)) {
                    HelperFactory.show_AlertFactory('El precio del producto ' + $scope.cart[i].description + ' no puede ser igual a cero o estar vacío.');
                    angular.element(document.querySelector('#price' + i)).focus();
                    return false;
                }
            }

            if (_.isUndefined($scope.total_sale) || $scope.total_sale == 0) {
                HelperFactory.show_AlertFactory('El total de la venta no puede ser igual a cero');
                return false;
            }

            if ($scope.sale.is_delivered) {
                if(_.isUndefined($scope.delivery.description)){
                    HelperFactory.show_AlertFactory('Debe especifcar los datos para la entrega del delivery');
                    angular.element(document.querySelector('#information_delivery')).focus();
                    return false;
                }
            }else{
                if (_.isNull($scope.sale.number_table)) {
                    HelperFactory.show_AlertFactory('Debe especificar el N° de mesa para el pedido.');
                    angular.element(document.querySelector('#sale_number_table')).focus();
                    return false;
                }
            }

            return true;
        };


        $scope.printCommand = function () {
            window.open('/print/command/document/'+$scope.sale.id);
        }

        $scope.closeCommand = function () {
            if(validateCommand()){
                var options = {
                    title: "¡Atención!",
                    message: "¿Esta seguro(a) de cerrar la comanda N° "+$scope.sale.code+" ? Se sugiere GUARDAR todo los cambios antes de continuar.",
                    cancel: "Cancelar",
                    confirm: "CERRAR COMANDA"
                };
                AlertFactory.confirmInfo(options, function () {
                    RESTService.updated('order/close_command', $scope.sale.id, $scope.sale, function (result) {
                        notifyAlert.success("Comanda N° "+$scope.sale.code+" cerrada con éxito !");
                        $scope.selfUpdate($scope.sale.id);
                    });
                });
            }
        };

        $scope.selfUpdate = function (model_id) {
            RESTService.get('order/command/edit', model_id, function (response) {
                $state.transitionTo("sales.eatery.edit", {
                    'id': model_id,
                    entity: response.data
                }, {'reload': "sales.eatery.edit", 'cache': false});
            });
        };

        $scope.cleanSale = function () {
            var options = {
                title: "Cuidado!!",
                message: "Está por cancelar todo el progreso del pedido.",
                cancel: "Minimizar",
                confirm: "Cancelar Pedido"
            };
            AlertFactory.confirm(options, function () {
                $state.transitionTo('sales.eatery', null, {'reload': true});
            });
        };

        $scope.close = function () {
            $state.transitionTo('sales.eatery', null, {'reload': true});
        }


        $scope.click_input_quantity = function (msg, $event) {
            var el = event.target;
            el.select();
        };

        $scope.click_input_price = function (msg, $event) {
            var el = event.target;
            el.select();
        };

        $scope.click_input_total_received = function (msg, $event) {
            var el = event.target;
            el.select();
        };

        $scope.addClient = function (actionCreate) {
            var obj = {'id': 0};

            if (!actionCreate) {
                obj = {
                    'id': 0,
                    entity: 'lol'
                };
            }

            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/sales/client/extends.html',
                controller: 'ExtendClientCtrl',
                size: 'lg',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                if (!_.isUndefined(result)) {
                    var data = result.data;
                    $scope.client_data = data;
                    $scope.client = data.id;
                    $scope.paid.document = data.document;
                    $scope.paid.address = data.address;
                    $timeout(function () {
                        angular.element(document.querySelector('#search_client_value')).val(data.fullname);
                        angular.element(document.querySelector('#search_client_value')).attr('disabled', 'disabled');
                    }, 50);
                }
            });
        };

        $scope.showOrders = function () {
            var obj = {
                'entity': null,
            };
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/sales/order/showorders.html',
                controller: 'ExtendsShowOrdersCtrl',
                size: 'modal-dialog modal-lg',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                if (!_.isUndefined(result)) {
                    $scope.cart = [];
                    var data = result.data;
                    var order = data.order;
                    var products_order = data.detail;

                    $scope.order_code = order.code;
                    $scope.sale.is_order = true;
                    $scope.sale.order_id = order.id;
                    $scope.sale.observation = order.observation;

                    $scope.client = order.client_id;
                    $scope.type_document = order.typeDocument;
                    $scope.paid.document = order.client_document;
                    $scope.paid.address = order.client_address;
                    angular.element(document.querySelector('#search_client_value')).attr('disabled', 'disabled');
                    angular.element(document.querySelector('#search_client_value')).val(order.client_fullname);

                    $.each(products_order, function (i, product) {
                        product.warehouse_id = $scope.warehousesSelected.id;
                        $scope.cart.push(product);
                    });

                    $timeout(function () {
                        $.each(products_order, function (i, product) {
                            var index = i;
                            var units = product.unitsmeasure;

                            $("#unitSelected" + index).html('');
                            $.each(units, function (i, item) {
                                $("#unitSelected" + index).append($('<option>', {
                                    value: item.id,
                                    text: item.description + ' (' + item.equivalence + ')'
                                }));
                            });
                            $("#unitSelected" + index).val(product.unitmeasure_id);
                            var pos = $scope.cart.indexOf(product);
                            $scope.cart[pos].unit_id = product.unitmeasure_id;
                        });

                        sum_items();

                        $scope.changeToPaid();

                    }, 100);
                }
            });
        };

        $scope.addAccountBank = function (actionCreate) {
            var obj = {'id': 0};
            if (!actionCreate) {
                obj = {
                    'id': 0,
                    entity: null
                };
            }
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/finance/accountbank/extends.html',
                controller: 'ExtendAccountBankCtrl',
                size: 'md',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                if (!_.isUndefined(result)) {
                    var data = result.data;
                    $scope.bankaccounts.push(data);
                    $scope.bankAccountSelected = data;
                    $scope.bankaccounts_exists = true;
                }
            });
        };

        $scope.informationDetail = function (product) {
            RESTService.get('product/information/detail', product.id, function (response) {
                var obj = {'data': response.data};
                $uibModal.open({
                    animation: true,
                    templateUrl: '../../templates/catalog/product/informationdetail.html',
                    controller: 'ExtendsProductInformationDetailCtrl',
                    size: 'modal-dialog modal-dialog-centered',
                    backdrop: 'static',
                    appendTo: angular.element(document.querySelector('#wrapper')),
                    resolve: {
                        PARAM: function () {
                            return obj;
                        }
                    }
                });
            });
        };

        $scope.informationDelivery = function (delivery_data) {
            let val_id = 0;
            let is_new = true;

            console.log(delivery_data);

            if (!_.isUndefined(delivery_data.id)) {
                if (delivery_data.id !== 0) {
                    val_id = delivery_data.id;
                    is_new = false;
                }else{
                    is_new = false;
                }
            }

            let obj = {'id': val_id, 'is_edit':true, entity:delivery_data, 'is_new':is_new};
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/sales/eatery/informationdelivery.html',
                controller: 'InformationDeliveryCtrl',
                size: 'modal-dialog modal-dialog-centered',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                if (!_.isUndefined(result)) {
                    $scope.delivery = result;
                }
            });
        };

    }
})();

