(function () {

    'use strict';
    angular.module('sys.app.order.detail')
        .controller('DetailOrderCtrl', DetailOrderCtrl);

    DetailOrderCtrl.$inject = ['$scope', '$stateParams', '$state', 'RESTService', 'EventsFactory', '$http', 'notifyAlert','_', 'HelperFactory', '$timeout', 'ORDER', 'SEARCH', 'AlertFactory', 'ConfigPagination', '$uibModal'];

    function DetailOrderCtrl($scope, $stateParams, $state, RESTService, EventsFactory, $http, notifyAlert,_, HelperFactory, $timeout, ORDER, SEARCH, AlertFactory, ConfigPagination, $uibModal) {

        var quantity_default = 1;

        $scope.subtotal = 0;
        $scope.total_order= 0;
        $scope.client = null;
        $scope.text = null;

        $scope.shifts = ORDER.SHIFT;

        try {
            $scope.check_order = $stateParams.entity.order;

            if (!_.isNull($scope.check_order.id)) {
                $scope.entity = $stateParams.entity.order;
                $scope.order = $stateParams.entity.order;

                if ($scope.order.id != 0) {
                    $scope.products = $stateParams.entity.detail;
                }
            }
        }
        catch (e) {
            $state.transitionTo('sales.orders', null, {'reload': true});
            console.log(e);
            return false;
        };

        init()

        function init() {

            RESTService.all('config/tax', null, function (response) {
                $scope.igv = response.results[0].percentage;
            });

            RESTService.all('config/currency', null, function (response) {
                $scope.currency = response.results;
                $scope.currencySelected = response.results[0];
                currencySelected($scope.proforma.currency_id);
            });
        }

        function currencySelected(id) {
            if(!_.isUndefined(id)){
                $scope.currencySelected = ConfigPagination.searchById(id,$scope.currency);
            }
        }

        $scope.updateDelivered = function () {

            var options = {
                title: "¡Atención!",
                message: "¿Esta seguro(a) de confirmar la entrega del pedido?",
                cancel: "Cancelar",
                confirm: "Confirmar"
            };
            AlertFactory.confirmSuccess(options, function () {
                RESTService.updated('order/delivered', $scope.order.id, $scope.order, function (result) {
                    notifyAlert.success("Se ha confirmado la entrega del pedido!!");
                    $state.transitionTo('sales.orders', null, {'reload': true});
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });
            });
        }

        $scope.edit = function (source) {
            delete $scope.allData;
            RESTService.get('order/edit', source.id, function (response) {
                $state.transitionTo("sales.orders.edit", {
                    'id': source.id,
                    entity: response.data
                }, {'reload': "sales.orders.edit", 'cache': false});
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };

        $scope.delete = function (item) {
            var options = {
                title: "Cuidado!!",
                message: "El pedido ' "+item.code+" ' será eliminado",
                cancel: "Cancelar",
                confirm: "Eliminar"
            };
            AlertFactory.confirm(options, function () {
                RESTService.deleted('order/delete', item.id, function (response) {
                    notifyAlert.success("El item se ha eliminado con éxito!!");
                    var obj = {"text": $scope.text};
                    $state.transitionTo('sales.orders', {entity: obj}, {'reload': true});
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });

            })
        };

        $scope.close = function () {
            $state.transitionTo('sales.orders', null, {'reload': true});
        }

    }

})();

