(function () {

    'use strict';
    angular.module('sys.app.order.new')
        .controller('NewOrderCtrl', NewOrderCtrl);

    NewOrderCtrl.$inject = ['$scope', '$stateParams', '$state', 'RESTService', 'notifyAlert', '_', 'HelperFactory', 'ConfigPagination', '$timeout', 'fileReader', '$uibModal', 'ORDER'];

    function NewOrderCtrl($scope, $stateParams, $state, RESTService, notifyAlert, _, HelperFactory, ConfigPagination, $timeout, fileReader, $uibModal, ORDER) {

        $scope.client = null;
        $scope.text_amount = null;
        $scope.subtotal = 0;
        $scope.total_igv = 0;
        $scope.total_order = 0;
        $scope.products_edit = [];
        $scope.is_edit = false;

        $scope.shifts = ORDER.SHIFT;

        var val_date_order=  moment().format('YYYY-MM-DD');


        try {

            $scope.check_order = $stateParams.entity.order;

            if (!_.isNull($scope.check_order.id)) {
                $scope.entity = $stateParams.entity.order;
                $scope.order = $stateParams.entity.order;

                if ($scope.order.id != 0) {//$scope.unitElements
                    $scope.txt_title = 'Editar';
                    $scope.action = 'edit';
                    $scope.is_edit = true;

                    $scope.products = $stateParams.entity.detail;
                    $scope.products_edit = $stateParams.entity.detail;

                    shiftSelected($scope.order.shift);
                    clientSelected($scope.order);

                    $timeout(function () {
                        sum_items()
                    }, 100);
                }
                else {

                    $scope.txt_title = 'Registrar';
                    $scope.action = 'create';
                    $scope.products = [];

                    $scope.order = {
                        'nro_voucher': null,
                        'date_order': val_date_order,
                        'observation': null,
                        'is_igv': false,
                    };

                    $scope.shiftSelected = ORDER.SHIFT[0];
                }
            }
        }
        catch (e) {
            $state.transitionTo('sales.orders', null, {'reload': true});
            console.log(e);
            return false;
        }


        init();

        function init() {

            RESTService.all('config/tax', null, function (response) {
                $scope.igv = response.results[0].percentage;
            });

            RESTService.all('config/currency', null, function (response) {
                $scope.currency = response.results;
                $scope.currencySelected = response.results[0];
            });

            RESTService.all('warehouses/branchoffice', null, function (response) {
                $scope.warehouses = response.results;
                $scope.warehousesSelected = response.results[0];
            });

            $timeout(function () {

                $('#date_order').daterangepicker({
                    locale: {
                        format: 'YYYY-MM-DD'
                    },
                    singleDatePicker: true,
                    showDropdowns: true,
                    minDate: new Date()
                });

                $('[data-toggle="tooltip"]').tooltip();

                // set units measure to product
                if($scope.is_edit){
                    $.each($scope.products_edit, function (i, product) {
                        var index = i;
                        var units = product.unitsmeasure;

                        $("#unitSelected"+index).html('');
                        $.each(units, function (i, item) {
                            $("#unitSelected"+index).append($('<option>', {
                                value: item.id,
                                text : item.description + ' ('+item.equivalence+')'
                            }));
                        });
                        $("#unitSelected"+index).val(product.unitmeasure_id);
                        var pos = $scope.products.indexOf(product);
                        $scope.products[pos].unit_id = product.unitmeasure_id;
                    });

                    angular.element(document.querySelector('#search_product_value')).focus();
                }
                else{
                    angular.element(document.querySelector('#search_client_value')).focus();
                }

            }, 100);
        };

        function clientSelected(data) {
            $scope.client = data.client_id;
            $timeout(function () {
                angular.element(document.querySelector('#search_client_value')).attr('disabled', 'disabled');
                $timeout(function () {
                    angular.element(document.querySelector('#search_client_value')).val(data.client_fullname +' - '+ data.typedocument+':'+data.client_document);
                }, 100);
            }, 100);
        };

        function shiftSelected(id) {
            if (!_.isUndefined(id)) {
                $scope.shiftSelected = ConfigPagination.searchById(id, $scope.shifts);
            }
        };


        $scope.changeOrderIgv = function (igv) {
            if ($scope.products.length > 0) {
                if (igv) {
                    for (var i in $scope.products) {
                        var item = $scope.products[i];
                        var index = $scope.products.indexOf(item);
                        var igv = ((item.subtotal * $scope.igv) / 100).toFixed(2);
                        var total = Number(item.subtotal) + Number(igv);
                        $scope.products[index].igv = igv;
                        $scope.products[index].total = total;
                        $scope.products[index].is_igv = true;
                    }
                } else {
                    for (var i in $scope.products) {
                        var item = $scope.products[i];
                        var index = $scope.products.indexOf(item);
                        var igv = 0;
                        var total = Number(item.subtotal) + Number(igv);
                        $scope.products[index].igv = igv;
                        $scope.products[index].total = total;
                        $scope.products[index].is_igv = false;
                    }
                }
                $timeout(function () {
                    sum_items();
                }, 300);
            }
        };

        $scope.recalculate_quantity = function (count, product, $index) {
            var check_quantity = angular.element(document.querySelector('#quantity' + $index)).val();
            var q_ = check_quantity;

            angular.element(document.querySelector('#quantity' + $index)).val(q_);

            var quantity = angular.element(document.querySelector('#quantity' + $index)).val();

            if (!_.isNaN(quantity * 1)) {
                var index = $scope.products.indexOf(product);
                var subtotal = (Number(quantity) * Number($scope.products[index].price));
                var igv = 0;
                if ($scope.order.is_igv) {
                    igv = ((subtotal * $scope.igv) / 100).toFixed(2);
                }

                var total = Number(subtotal) + Number(igv);

                $scope.products[index].quantity = quantity;
                $scope.products[index].subtotal = subtotal;
                $scope.products[index].igv = igv;
                $scope.products[index].total = total;

                $timeout(function () {
                    sum_items();
                }, 300);
            }
        };

        $scope.recalculate_price = function (price, product, $index) {
            var check_price = angular.element(document.querySelector('#price' + $index)).val();
            var q_ = check_price;

            angular.element(document.querySelector('#price' + $index)).val(q_);

            var price_get = angular.element(document.querySelector('#price' + $index)).val();

            if (!_.isNaN(price_get * 1)) {
                var index = $scope.products.indexOf(product);

                var subtotal = (Number(product.quantity) * Number(price_get)).toFixed(2);
                var igv = 0;
                if ($scope.order.is_igv) {
                    igv = ((subtotal * $scope.igv) / 100).toFixed(2);
                }
                var total = Number(subtotal) + Number(igv);
                $scope.products[index].price = Number(price_get);
                $scope.products[index].subtotal = subtotal;
                $scope.products[index].igv = igv;
                $scope.products[index].total = total;
                $timeout(function () {
                    sum_items();
                }, 300);
            }
        };

        $scope.recalculate_igv = function (igv, product, $index) {
            console.log(igv);
        };

        $scope.change_unitmeasure = function (unitSelected, product, $index) {
            var check_unit = angular.element(document.querySelector('#unitSelected' + $index)).val();
            var pos = $scope.products.indexOf(product);
            $scope.products[pos].unit_id = check_unit;

            changePriceByUnitMeasure(check_unit, product, $index)
        };

        function changePriceByUnitMeasure(unit_id, product, pos) {

            var price_unit = ConfigPagination.searchById(unit_id, product.unitsmeasure);
            angular.element(document.querySelector('#price' + pos)).val(price_unit.price_sale);
            var price_get = angular.element(document.querySelector('#price' + pos)).val();

            if (!_.isNaN(price_get * 1)) {
                var index = $scope.products.indexOf(product);

                var subtotal = (Number(product.quantity) * Number(price_get)).toFixed(2);
                var igv = 0;
                if ($scope.order.is_igv) {
                    igv = ((subtotal * $scope.igv) / 100).toFixed(2);
                }
                var total = Number(subtotal) + Number(igv);
                $scope.products[index].price = Number(price_get);
                $scope.products[index].subtotal = subtotal;
                $scope.products[index].igv = igv;
                $scope.products[index].total = total;
                $timeout(function () {
                    sum_items();
                }, 300);
            }
        }

        $scope.change_is_igv = function (is_igv_, product, $index) {
            var igv = 0;
            var index = $scope.products.indexOf(product);
            var subtotal = (Number(product.quantity) * Number(product.price)).toFixed(2);

            if(is_igv_){
                igv = ((product.subtotal * $scope.igv) / 100).toFixed(2);
            }

            var total = Number(subtotal) + Number(igv);

            $scope.products[index].is_igv = is_igv_;
            $scope.products[index].igv = igv;
            $scope.products[index].total = total;

            $timeout(function () {
                sum_items();
            }, 300);
        }

        $scope.removeItem = function ($event, product, $index) {
            $event.preventDefault();
            var index = $scope.products.indexOf(product);
            $scope.products.splice(index, 1)
            $timeout(function () {
                sum_items();
            }, 300);
            notifyAlert.info("El producto " + product.description + ' ha sido removido del detalle');
        };

        $scope.selectedProduct = function (response) {
            if (!_.isUndefined(response)) {
                var item = response.originalObject;
                var unique = ifExistProduct(item);

                if (unique) {
                    item.unit_id = 0;
                    item.quantity = null;
                    item.price = item.price_sale;
                    item.detail = null;
                    item.subtotal = 0;
                    item.igv = null;
                    item.total = 0;
                    item.equivalence = null;
                    item.is_igv = false;

                    if($scope.order.is_igv){
                        var igv = ((item.subtotal * $scope.igv) / 100).toFixed(2);
                        var total = Number(item.subtotal) + Number(igv);

                        item.igv = igv;
                        item.total = total;
                        item.is_igv = true;
                    }

                    $scope.products.push(item);

                    $timeout(function () {
                        sum_items();
                    }, 300);

                    var last = $scope.products.length;
                    $timeout(function () {
                        angular.element(document.querySelector('#quantity' + Number(last - 1))).focus();
                        listUnitMeasureProduct(last, item);
                    }, 50);
                    $scope.$broadcast('angucomplete-alt:clearInput', 'search_product');
                }
                else {
                    notifyAlert.warning('El producto ' + item.description + ' ya se encuentra agregado');
                }
            }
        }

        function listUnitMeasureProduct(pos, product) {
            var index = pos - 1;
            var units = product.unitsmeasure;

            $("#unitSelected" + index).html('');
            $.each(units, function (i, item) {
                $("#unitSelected" + index).append($('<option>', {
                    value: item.id,
                    text : item.description + ' ('+item.equivalence+')'
                }));
            });

            $("#unitSelected" + index).val(units[0].id);
            var pos = $scope.products.indexOf(product);
            $scope.products[pos].unit_id = units[0].id;
        }

        function ifExistProduct(obj) {
            var cart = $scope.products;
            var is_unique = true;
            for (var key in cart) {
                if (cart[key].id === Number(obj.id)) {
                    is_unique = false;
                    break;
                }
            }
            return is_unique;
        }

        $scope.click_input_quantity = function (msg, $event) {
            var el = event.target;
            el.select();
        };

        $scope.click_input_price = function (msg, $event) {
            var el = event.target;
            el.select();
        };

        $scope.click_input_igv = function (msg, $event) {
            var el = event.target;
            el.select();
        };

        $scope.selectedClient = function (response) {
            if (!_.isUndefined(response)) {
                var data = response.originalObject;
                $scope.client = data.id;

                angular.element(document.querySelector('#search_client_value')).attr('disabled', 'disabled');

                $timeout(function () {
                    angular.element(document.querySelector('#search_client_value')).val(data.fullname +' - '+ data.typeDocument+':'+data.document);
                }, 100);
            }
        };

        $scope.removeClient = function () {
            angular.element(document.querySelector('#search_client_value')).removeAttr('disabled').focus();
            angular.element(document.querySelector('#search_client_value')).val('');
            $scope.client = null;
            $scope.$broadcast('angucomplete-alt:clearInput', 'search_client');
        };

        function sum_items() {
            $scope.subtotal = 0;
            $scope.total_igv = 0;
            $scope.total_order = 0;
            for (var i in $scope.products) {
                var item = $scope.products[i];
                $scope.subtotal = (Number($scope.subtotal) + Number(item.price) * Number(item.quantity)).toFixed(2);
                $scope.total_igv = (Number($scope.total_igv) + Number(item.igv)).toFixed(2);
            }

            $scope.total_order = (Number($scope.subtotal) + Number($scope.total_igv)).toFixed(2);
            $scope.text_amount = numero.letras($scope.total_order);
        }

        $scope.save = function () {
            if (validate()) {
                var data = {};
                $scope.order['client_id'] = $scope.client;
                $scope.order['shift'] = $scope.shiftSelected.id;
                $scope.order['igv'] = $scope.total_igv;
                $scope.order['subtotal'] = $scope.subtotal;
                $scope.order['total'] = $scope.total_order;
                $scope.order['text_amount'] = $scope.text_amount;

                data.order = $scope.order;
                data.detail = $scope.products;

                if ($scope.action == 'create') {
                    RESTService.save('order/save', data, function (result) {
                        notifyAlert.success("Registro realizado con éxito!!");
                        $state.transitionTo('sales.orders', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
                else if ($scope.action == 'edit') {
                    RESTService.updated('order/update', $scope.order.id, data, function (result) {
                        notifyAlert.success("Registro actualizado con éxito!!");
                        $state.transitionTo('sales.orders', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
            }
        };

        function validate() {
            if (_.isNull($scope.client) || _.isUndefined($scope.client)) {
                HelperFactory.show_AlertFactory('Debe seleccionar el client');
                angular.element(document.querySelector('#search_client_value')).focus();
                return false;
            }

            if (_.isUndefined($scope.order.date_order) || _.isNull($scope.order.date_order)) {
                HelperFactory.show_AlertFactory('Debe seleccionar una fecha para el pedido');
                angular.element(document.querySelector('#date_order')).focus();
                return false;
            }

            if ($scope.shiftSelected.id == 0) {
                HelperFactory.show_AlertFactory('Debe seleccionar el turno para el pedido');
                angular.element(document.querySelector('#shiftSelected')).focus();
                return false;
            }


            if ($scope.products.length === 0) {
                HelperFactory.show_AlertFactory('Debe ingresar por lo menos un producto al detalle del pedido');
                angular.element(document.querySelector('#search_product_value')).focus();
                return false;
            }

            // check quantity
            for (var i in $scope.products) {
                if (Number($scope.products[i].quantity) == 0 || _.isNull($scope.products[i].quantity)) {
                    HelperFactory.show_AlertFactory('La cantidad del producto ' + $scope.products[i].description + ' no puede ser igual a cero o estar vacío.');
                    angular.element(document.querySelector('#quantity' + i)).focus();
                    return false;
                }
            }

            // check price
            for (var i in $scope.products) {
                if (Number($scope.products[i].price) == 0 || _.isNull($scope.products[i].price)) {
                    HelperFactory.show_AlertFactory('El precio del producto ' + $scope.products[i].description + ' no puede ser igual a cero o estar vacío.');
                    angular.element(document.querySelector('#price' + i)).focus();
                    return false;
                }
            }

            return true;
        };

        $scope.addClient = function (actionCreate) {
            var obj = {'id': 0};

            if (!actionCreate) {
                obj = {
                    'id': 0,
                    entity: 'lol'
                };
            }

            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/sales/client/extends.html',
                controller: 'ExtendClientCtrl',
                size: 'lg',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                if (!_.isUndefined(result)) {
                    var data = result.data;
                    $scope.client = data.id;

                    $timeout(function () {
                        angular.element(document.querySelector('#search_client_value')).val(data.fullname);
                        angular.element(document.querySelector('#search_client_value')).attr('disabled', 'disabled');
                    }, 50);
                }
            });
        };

        $scope.addProduct = function (actionCreate) {
            var obj = {'id': 0};
            if (!actionCreate){
                obj = {
                    'id': 0,
                    entity: null
                };
            }
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/catalog/product/extends.html',
                controller: 'ExtendCatalogProductCtrl',
                size: 'lg',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                if (!_.isUndefined(result)) {
                    var response = {};
                    response.originalObject = result.data;
                    $scope.selectedProduct(response);
                }
            });
        };

        $scope.listPriceUnit = function (product) {
            var obj = {
                'product': product,
                'currency': $scope.currencySelected
            };
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/sales/sale/priceunits.html',
                controller: 'ExtendsPriceUnitsCtrl',
                size: 'modal-dialog modal-dialog-centered',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                // init();
            });
        };

        $scope.informationDetail = function (product) {
            RESTService.get('product/information/detail', product.id, function (response) {
                var obj = {'data': response.data};
                $uibModal.open({
                    animation: true,
                    templateUrl: '../../templates/catalog/product/informationdetail.html',
                    controller: 'ExtendsProductInformationDetailCtrl',
                    size: 'modal-dialog modal-dialog-centered',
                    backdrop: 'static',
                    appendTo: angular.element(document.querySelector('#wrapper')),
                    resolve: {
                        PARAM: function () {
                            return obj;
                        }
                    }
                });
            });
        };

        $scope.close = function () {
            $state.transitionTo('sales.orders', null, {'reload': true});
        };
    }

})();

