
(function () {
    'use strict';

    angular.module('sys.app.order', [
        'sys.app.order.new',
        'sys.app.order.detail'
    ]);

    angular.module('sys.app.order').config(Config);

    Config.$inject = ['$stateProvider', '$urlRouterProvider'];


    function Config($stateProvider, $urlRouterProvider) {
        $stateProvider

            .state('sales.orders.new', {
                url: '/nuevo',
                templateUrl: '../../templates/sales/order/new.html',
                controller: 'NewOrderCtrl',
                params: {
                    entity: null
                },
                title: "Crear pedido",
                module:"orders"
            })

            // editar orden pedido
            .state('sales.orders.edit', {
                url: '/editar',
                templateUrl: '../../templates/sales/order/new.html',
                controller: 'NewOrderCtrl',
                params: {
                    entity: null
                },
                title:'Editar pedido',
                module:"orders"
            })

            .state('sales.orders.detail', {
                url: '/detalle',
                templateUrl: '../../templates/sales/order/detail.html',
                controller: 'DetailOrderCtrl',
                params: {
                    entity: null
                },
                title:'Detalle pedido',
                module:"orders"
            })

        ;

        $urlRouterProvider.otherwise('/lista');
    }

})();
