(function () {
    'use strict';

    angular.module('sys.utils.utils')
        .controller('ExtendsShowOrdersCtrl', ExtendsShowOrdersCtrl);

    ExtendsShowOrdersCtrl.$inject =['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory', '$http', '$timeout', 'notifyAlert', 'SEARCH', 'loadingAlert', '$uibModal', 'ORDER', '$uibModalInstance'];

    function ExtendsShowOrdersCtrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $http, $timeout, notifyAlert, SEARCH, loadingAlert, $uibModal, ORDER, $uibModalInstance) {

        $scope.entity = {};
        $scope.text= null;
        $scope.currentPage = 1;

        $scope.status = ORDER.STATUS;
        $scope.statusSelected = ORDER.STATUS[0];

        var object = "";

        init();

        function init() {
            object = "search=" + $scope.text + '&page=' + $scope.currentPage+'&statusDelivered='+$scope.statusSelected.id;
            RESTService.all('order/list', object + '&export=0', function (response) {
                $scope.allData = response.results;
                $scope.totalItems = response.total;
                $scope.itemsPerPage = response.paginate_by;
            }, function (error) {
                console.log('ERROR');
                return false;
            });

        }

        $scope.edit = function (source) {
            delete $scope.allData;
            RESTService.get('order/edit', source.id, function (response) {
                $state.transitionTo("sales.orders.edit", {
                    'id': source.id,
                    entity: response.data
                }, {'reload': "sales.orders.edit", 'cache': false});
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };


        $scope.detail = function (source) {
            delete $scope.allData;
            RESTService.get('order/detail', source.id, function (response) {
                $state.transitionTo("sales.orders.detail", {
                    'id': source.id,
                    entity: response.data
                }, {'reload': "sales.orders.detail", 'cache': false});
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };


        $scope.searchAction = function (text) {
            $scope.text = text;
            $scope.currentPage = 1;
            if (text.length >= SEARCH.MIN_LETTERS || text.length == 0) {
                delete $scope.allData;
                init();
            }
        };

        $scope.pageChanged = function(page) {
            $scope.currentPage = page;
            delete $scope.allData;
            init();
        };

        $scope.selectedStatus = function (item) {
            $scope.statusSelected = item;
            init();
        };


        $scope.new = function () {
            var source = {'order': {'id':0 }};
            $state.transitionTo('sales.orders.new', {entity: source}, {
                'reload': 'sales.orders.new',
                'cache': false
            });
            delete $scope.allData;
        };

        $scope.refresh = function () {
            delete $scope.allData;
            $state.transitionTo('sales.orders', {entity: null}, {'reload': true});
        };

        $scope.delete = function (item) {
            var options = {
                title: "Cuidado!!",
                message: "El pedido ' "+item.nro_voucher+" ' será eliminado",
                cancel: "Cancelar",
                confirm: "Eliminar"
            };
            AlertFactory.confirm(options, function () {
                RESTService.deleted('order/delete', item.id, function (response) {
                    notifyAlert.success("El item se ha eliminado con éxito!!");
                    var obj = {"text": $scope.text};
                    $state.transitionTo('sales.orders', {entity: obj}, {'reload': true});
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });

            })
        };

        $scope.selectOrder = function (item) {
            RESTService.get('order/edit', item.id, function (response) {
                $uibModalInstance.close(response);
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };

        $scope.closeModal = function () {
            $uibModalInstance.dismiss();
        };

    }

})();
