(function () {

    'use strict';
    angular.module('sys.app.proformas.detail')
        .controller('DetailProformaCtrl', DetailProformaCtrl);

    DetailProformaCtrl.$inject = ['$scope', '$stateParams', '$state', 'RESTService', 'EventsFactory', '$http', 'notifyAlert','_', 'HelperFactory', '$timeout', 'ORDER', 'SEARCH', 'AlertFactory', 'ConfigPagination', '$uibModal'];

    function DetailProformaCtrl($scope, $stateParams, $state, RESTService, EventsFactory, $http, notifyAlert,_, HelperFactory, $timeout, ORDER, SEARCH, AlertFactory, ConfigPagination, $uibModal) {

        try {
            $scope.check_proforma = $stateParams.entity.proforma;

            if (!_.isNull($scope.check_proforma.id)) {
                $scope.entity = $stateParams.entity.proforma;
                $scope.proforma = $stateParams.entity.proforma;

                if ($scope.proforma.id != 0) {
                    $scope.products = $stateParams.entity.detail;
                }
            }
        }
        catch (e) {
            $state.transitionTo('sales.proformas', null, {'reload': true});
            console.log(e);
            return false;
        }

        init()

        function init() {

            RESTService.all('config/tax', null, function (response) {
                $scope.igv = response.results[0].percentage;
            });

            RESTService.all('config/currency', null, function (response) {
                $scope.currency = response.results;
                $scope.currencySelected = response.results[0];
                currencySelected($scope.proforma.currency_id);
            });
        }

        function currencySelected(id) {
            if(!_.isUndefined(id)){
                $scope.currencySelected = ConfigPagination.searchById(id,$scope.currency);
            }
        }

        $scope.edit = function (source) {
            delete $scope.allData;
            RESTService.get('proformas/edit', source.id, function (response) {
                $state.transitionTo("sales.proformas.edit", {
                    'id': source.id,
                    entity: response.data
                }, {'reload': "sales.proformas.edit", 'cache': false});
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };


        $scope.delete = function (item) {
            var options = {
                title: "Cuidado!!",
                message: "La proforma N° ' "+item.nro_voucher+" ' será eliminada",
                cancel: "Cancelar",
                confirm: "Eliminar"
            };
            AlertFactory.confirm(options, function () {
                RESTService.deleted('proformas/delete', item.id, function (response) {
                    notifyAlert.success("El item se ha eliminado con éxito!!");
                    var obj = {"text": $scope.text};
                    $state.transitionTo('sales.proformas', {entity: obj}, {'reload': true});

                }, function (error) {
                    console.log('ERROR');
                    return false;
                });

            })
        };

        $scope.printProforma = function (item) {
            window.open('/print/proforma/document/'+ item.id);
        };

        $scope.sendEmailProforma = function (item) {
            swal({
                title: '<span class="f-s-16">Enviar por correo la proforma <span class="text-success bold">N° '+item.nro_voucher+'</span></span>',
                input: 'email',
                inputPlaceholder: "Ingrese correo, Ejem: cliente@gmail.com",
                showCancelButton: true,
                confirmButtonColor: "#30419b",
                confirmButtonText: "<i class='fas fa-envelope m-r-5'></i>Confirmar envío",
                cancelButtonText: "Cancelar"
            }).then(function (email) {
                if(email.value){
                    $("#loading_object").show();
                    $.ajax({
                        url: '/send/email/proforma/'+ item.id,
                        type: 'GET',
                        data: {
                            email:email.value
                        },
                        success: function(response) {
                            $("#loading_object").hide();
                            swal({
                                type: 'success',
                                title:'Excelente !!',
                                html:response.msg
                            })
                        },
                        error: (function (error) {
                            $("#loading_object").hide();
                            swal({
                                type: 'error',
                                title:'Hubo un error !!',
                                html: "Hubo un error al realizar el envío. Para mayor información consulte a su administrador." + error
                            })
                        })
                    });
                }
            });
        };

        $scope.close = function () {
            $state.transitionTo('sales.proformas', null, {'reload': true});
        };


    }

})();

