(function () {

    'use strict';
    angular.module('sys.app.proformas.new')
        .controller('NewProformaCtrl', NewProformaCtrl);

    NewProformaCtrl.$inject = ['$scope', '$stateParams', '$state', 'RESTService', 'notifyAlert', '_', 'HelperFactory', 'ConfigPagination', '$timeout', 'fileReader', '$uibModal'];

    function NewProformaCtrl($scope, $stateParams, $state, RESTService, notifyAlert, _, HelperFactory, ConfigPagination, $timeout, fileReader, $uibModal) {

        $scope.client = null;
        $scope.text_amount = null;
        $scope.subtotal = 0;
        $scope.total_igv = 0;
        $scope.total_proforma = 0;
        $scope.products_edit = [];
        $scope.is_edit = false;

        var val_date_issue =  moment().format('YYYY-MM-DD');
        var date_expiration = moment(val_date_issue).add(1,'month').format('YYYY-MM-DD');


        try {

            $scope.check_proforma = $stateParams.entity.proforma;

            if (!_.isNull($scope.check_proforma.id)) {
                $scope.entity = $stateParams.entity.proforma;
                $scope.proforma = $stateParams.entity.proforma;

                if ($scope.proforma.id != 0) {//$scope.unitElements
                    $scope.txt_title = 'Editar';
                    $scope.action = 'edit';
                    $scope.is_edit = true;

                    $scope.products = $stateParams.entity.detail;
                    $scope.products_edit = $stateParams.entity.detail;

                    clientSelected($scope.proforma);

                    $timeout(function () {
                        sum_items()
                    }, 100);
                }
                else {
                    $scope.txt_title = 'Registrar';
                    $scope.action = 'create';

                    $scope.products = [];

                    $scope.proforma = {
                        'nro_voucher': null,
                        'date_issue': val_date_issue,
                        'date_expiration': date_expiration,
                        'observation': null,
                        'cellphone': null,
                        'email': null,
                        'address': null,
                        'is_igv': false,
                    };
                }
            }
        }
        catch (e) {
            $state.transitionTo('sales.proformas', null, {'reload': true});
            console.log(e);
            return false;
        }


        init();

        function init() {

            RESTService.all('config/tax', null, function (response) {
                $scope.igv = response.results[0].percentage;
            });

            RESTService.all('config/currency', null, function (response) {
                $scope.currency = response.results;
                $scope.currencySelected = response.results[0];
            });

            RESTService.all('accountbanks/search/all', null, function (response) {
                $scope.bankaccounts = response.results;
                $scope.bankaccounts_exists = false;
                if($scope.bankaccounts.length>0){
                    $scope.bankaccounts_exists = true;
                    $scope.bankAccountSelected = response.results[0];

                    accountBankSelected($scope.proforma.accountbank_id);
                }
            });

            $timeout(function () {

                $('#date_issue').datepicker({
                    dateFormat: 'yy-mm-dd',
                    autoclose: true,
                });

                $('#date_expiration').datepicker({
                    dateFormat: 'yy-mm-dd',
                    autoclose: true,
                    minDate: moment(val_date_issue).add(1,"days").format('yy-mm-dd')
                    // minDate: new Date(val_date_issue)
                });

                $('[data-toggle="tooltip"]').tooltip();

                // set units measure to product
                if($scope.is_edit){
                    $.each($scope.products_edit, function (i, product) {
                        var index = i;
                        var units = product.unitsmeasure;

                        $("#unitSelected"+index).html('');
                        $.each(units, function (i, item) {
                            $("#unitSelected"+index).append($('<option>', {
                                value: item.id,
                                text : item.description + ' ('+item.equivalence+')'
                            }));
                        });
                        $("#unitSelected"+index).val(product.unitmeasure_id);
                        var pos = $scope.products.indexOf(product);
                        $scope.products[pos].unit_id = product.unitmeasure_id;
                    });
                }

                angular.element(document.querySelector('#search_client_value')).focus();

            }, 100);
        };

        function clientSelected(data) {
            $scope.client = data.client_id;
            $timeout(function () {
                angular.element(document.querySelector('#search_client_value')).attr('disabled', 'disabled');
                $timeout(function () {
                    angular.element(document.querySelector('#search_client_value')).val(data.client_fullname +' - '+ data.typedocument+':'+data.client_document);
                }, 100);
            }, 100);
        };

        function accountBankSelected(id) {
            if(!_.isUndefined(id)){
                if(id != null){
                    $scope.bankAccountSelected = ConfigPagination.searchById(id,$scope.bankaccounts);
                }
            }
        };

        $scope.changeBankAccount = function (item) {
            $scope.bankAccountSelected = item;
        };

        $scope.changeProformaIgv = function (igv) {
            if ($scope.products.length > 0) {
                if (igv) {
                    for (var i in $scope.products) {
                        var item = $scope.products[i];
                        var index = $scope.products.indexOf(item);
                        var igv = ((item.subtotal * $scope.igv) / 100).toFixed(2);
                        var total = Number(item.subtotal) + Number(igv);
                        $scope.products[index].igv = igv;
                        $scope.products[index].total = total;

                        $("#igv" + i).val(igv);
                    }

                } else {
                    for (var i in $scope.products) {
                        var item = $scope.products[i];
                        var index = $scope.products.indexOf(item);
                        var igv = 0;
                        var total = Number(item.subtotal) + Number(igv);
                        $scope.products[index].igv = igv;
                        $scope.products[index].total = total;
                        $("#igv" + i).val(0);
                    }
                }
                $timeout(function () {
                    sum_items();
                }, 300);
            }
        };

        $scope.recalculate_quantity = function (count, product, $index) {
            var check_quantity = angular.element(document.querySelector('#quantity' + $index)).val();
            var q_ = check_quantity;

            angular.element(document.querySelector('#quantity' + $index)).val(q_);

            var quantity = angular.element(document.querySelector('#quantity' + $index)).val();

            if (!_.isNaN(quantity * 1)) {
                var index = $scope.products.indexOf(product);
                var subtotal = (Number(quantity) * Number($scope.products[index].price));
                var igv = 0;
                if ($scope.proforma.is_igv) {
                    igv = ((subtotal * $scope.igv) / 100).toFixed(2);
                }

                var total = Number(subtotal) + Number(igv);

                $scope.products[index].quantity = quantity;
                $scope.products[index].subtotal = subtotal;
                $scope.products[index].igv = igv;
                $scope.products[index].total = total;

                $timeout(function () {
                    sum_items();
                }, 300);
            }
        };

        $scope.recalculate_price = function (price, product, $index) {
            var check_price = angular.element(document.querySelector('#price' + $index)).val();
            var q_ = check_price;

            angular.element(document.querySelector('#price' + $index)).val(q_);

            var price_get = angular.element(document.querySelector('#price' + $index)).val();

            if (!_.isNaN(price_get * 1)) {
                var index = $scope.products.indexOf(product);

                var subtotal = (Number(product.quantity) * Number(price_get)).toFixed(2);
                var igv = 0;
                if ($scope.proforma.is_igv) {
                    igv = ((subtotal * $scope.igv) / 100).toFixed(2);
                }
                var total = Number(subtotal) + Number(igv);
                $scope.products[index].price = Number(price_get);
                $scope.products[index].subtotal = subtotal;
                $scope.products[index].igv = igv;
                $scope.products[index].total = total;
                $timeout(function () {
                    sum_items();
                }, 300);
            }
        };

        $scope.recalculate_igv = function (igv, product, $index) {

            var check_igv = angular.element(document.querySelector('#igv' + $index)).val();
            var q_ = check_igv;

            angular.element(document.querySelector('#igv' + $index)).val(q_);

            var price_get = angular.element(document.querySelector('#igv' + $index)).val();

            if (!_.isNaN(price_get * 1)) {

                var index = $scope.products.indexOf(product);
                var subtotal = (Number(product.quantity) * Number(product.price)).toFixed(2);

                var igv = price_get;
                var total = Number(subtotal) + Number(igv);

                $scope.products[index].igv = igv;
                $scope.products[index].total = total;
                $timeout(function () {
                    sum_items();
                }, 300);
            }

        };

        $scope.change_unitmeasure = function (unitSelected, product, $index) {
            var check_unit = angular.element(document.querySelector('#unitSelected' + $index)).val();
            var pos = $scope.products.indexOf(product);
            $scope.products[pos].unit_id = check_unit;

            changePriceByUnitMeasure(check_unit, product, $index)
        };

        function changePriceByUnitMeasure(unit_id, product, pos) {

            var price_unit = ConfigPagination.searchById(unit_id, product.unitsmeasure);
            angular.element(document.querySelector('#price' + pos)).val(price_unit.price_sale);
            var price_get = angular.element(document.querySelector('#price' + pos)).val();

            if (!_.isNaN(price_get * 1)) {
                var index = $scope.products.indexOf(product);

                var subtotal = (Number(product.quantity) * Number(price_get)).toFixed(2);
                var igv = 0;
                if ($scope.proforma.is_igv) {
                    igv = ((subtotal * $scope.igv) / 100).toFixed(2);
                }
                var total = Number(subtotal) + Number(igv);
                $scope.products[index].price = Number(price_get);
                $scope.products[index].subtotal = subtotal;
                $scope.products[index].igv = igv;
                $scope.products[index].total = total;
                $timeout(function () {
                    sum_items();
                }, 300);
            }
        }

        $scope.removeItem = function ($event, product, $index) {
            $event.preventDefault();
            var index = $scope.products.indexOf(product);
            $scope.products.splice(index, 1)
            $timeout(function () {
                sum_items();
            }, 300);
            notifyAlert.info("El producto " + product.description + ' ha sido removido del detalle');
        };

        $scope.selectedProduct = function (response) {
            if (!_.isUndefined(response)) {
                var item = response.originalObject;
                var unique = ifExistProduct(item);

                if (unique) {
                    item.unit_id = 0;
                    item.quantity = null;
                    item.price = item.price_sale;
                    item.detail = null;
                    item.subtotal = 0;
                    item.igv = null;
                    item.total = 0;
                    item.equivalence = null;

                    $scope.products.push(item);

                    $timeout(function () {
                        sum_items();
                    }, 300);

                    var last = $scope.products.length;
                    $timeout(function () {
                        angular.element(document.querySelector('#quantity' + Number(last - 1))).focus();
                        listUnitMeasureProduct(last, item);
                    }, 50);
                    $scope.$broadcast('angucomplete-alt:clearInput', 'search_product');
                }
                else {
                    notifyAlert.warning('El producto ' + item.description + ' ya se encuentra agregado');
                }
            }
        }

        function listUnitMeasureProduct(pos, product) {
            var index = pos - 1;
            var units = product.unitsmeasure;

            $("#unitSelected" + index).html('');
            $.each(units, function (i, item) {
                $("#unitSelected" + index).append($('<option>', {
                    value: item.id,
                    text : item.description + ' ('+item.equivalence+')'
                }));
            });

            $("#unitSelected" + index).val(units[0].id);
            // $("#unitSelected" + index).attr('disabled', 'disabled');

            var pos = $scope.products.indexOf(product);
            $scope.products[pos].unit_id = units[0].id;
        }

        function ifExistProduct(obj) {
            var cart = $scope.products;
            var is_unique = true;
            for (var key in cart) {
                if (cart[key].id === Number(obj.id)) {
                    is_unique = false;
                    break;
                }
            }
            return is_unique;
        }

        $scope.click_input_quantity = function (msg, $event) {
            var el = event.target;
            el.select();
        };

        $scope.click_input_price = function (msg, $event) {
            var el = event.target;
            el.select();
        };

        $scope.click_input_igv = function (msg, $event) {
            var el = event.target;
            el.select();
        };

        $scope.selectedClient = function (response) {
            if (!_.isUndefined(response)) {
                var data = response.originalObject;
                $scope.client = data.id;
                $scope.proforma.email = data.email;
                $scope.proforma.cellphone = data.cellphone;
                $scope.proforma.address = data.address;

                angular.element(document.querySelector('#search_client_value')).attr('disabled', 'disabled');

                $timeout(function () {
                    angular.element(document.querySelector('#search_client_value')).val(data.fullname +' - '+ data.typeDocument+':'+data.document);
                }, 100);
            }
        };

        $scope.removeClient = function () {
            angular.element(document.querySelector('#search_client_value')).removeAttr('disabled').focus();
            angular.element(document.querySelector('#search_client_value')).val('');
            $scope.client = null;
            $scope.$broadcast('angucomplete-alt:clearInput', 'search_client');
        };

        function sum_items() {
            $scope.subtotal = 0;
            $scope.total_igv = 0;
            $scope.total_proforma = 0;
            for (var i in $scope.products) {
                var item = $scope.products[i];
                $scope.subtotal = (Number($scope.subtotal) + Number(item.price) * Number(item.quantity)).toFixed(2);
                $scope.total_igv = (Number($scope.total_igv) + Number(item.igv)).toFixed(2);
            }

            $scope.total_proforma = (Number($scope.subtotal) + Number($scope.total_igv)).toFixed(2);
            $scope.text_amount = numero.letras($scope.total_proforma);
        }

        $scope.save = function () {
            if (validate()) {

                var data = {};
                $scope.proforma['client_id'] = $scope.client;
                $scope.proforma['igv'] = $scope.total_igv;
                $scope.proforma['subtotal'] = $scope.subtotal;
                $scope.proforma['total'] = $scope.total_proforma;
                $scope.proforma['text_amount'] = $scope.text_amount;

                var accountbank_id = null;
                if($scope.bankaccounts.length > 0){
                    accountbank_id = $scope.bankAccountSelected.id;
                };

                $scope.proforma['accountbank_id'] = accountbank_id ;

                data.proforma = $scope.proforma;
                data.detail = $scope.products;

                if ($scope.action == 'create') {
                    RESTService.save('proformas/save', data, function (result) {
                        notifyAlert.success("Registro realizado con éxito!!");
                        $state.transitionTo('sales.proformas', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
                else if ($scope.action == 'edit') {
                    RESTService.updated('proformas/update', $scope.proforma.id, data, function (result) {
                        notifyAlert.success("Registro actualizado con éxito!!");
                        $state.transitionTo('sales.proformas', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
            }
        };

        function validate() {
            if (_.isNull($scope.client) || _.isUndefined($scope.client)) {
                HelperFactory.show_AlertFactory('Debe seleccionar el client');
                angular.element(document.querySelector('#search_client_value')).focus();
                return false;
            }
            if (_.isUndefined($scope.proforma.date_issue) || _.isNull($scope.proforma.date_issue)) {
                HelperFactory.show_AlertFactory('Debe seleccionar la fecha de emisión de la proforma');
                angular.element(document.querySelector('#date_issue')).focus();
                return false;
            }
            if (_.isUndefined($scope.proforma.date_expiration) || _.isNull($scope.proforma.date_expiration)) {
                HelperFactory.show_AlertFactory('Debe seleccionar la fecha de vencimiento de la proforma');
                angular.element(document.querySelector('#date_issue')).focus();
                return false;
            }

            if (_.isUndefined($scope.proforma.cellphone) || _.isNull($scope.proforma.cellphone)) {
                HelperFactory.show_AlertFactory('Debe ingresar al menos el número de celular del cliente');
                angular.element(document.querySelector('#cellphone')).focus();
                return false;
            }

            if ($scope.products.length === 0) {
                HelperFactory.show_AlertFactory('Debe ingresar por lo menos un producto al detalle de la proforma');
                angular.element(document.querySelector('#search_product_value')).focus();
                return false;
            }

            // check quantity
            for (var i in $scope.products) {
                if (Number($scope.products[i].quantity) == 0 || _.isNull($scope.products[i].quantity)) {
                    HelperFactory.show_AlertFactory('La cantidad del producto ' + $scope.products[i].description + ' no puede ser igual a cero o estar vacío.');
                    angular.element(document.querySelector('#quantity' + i)).focus();
                    return false;
                }
            }

            // check price
            for (var i in $scope.products) {
                if (Number($scope.products[i].price) == 0 || _.isNull($scope.products[i].price)) {
                    HelperFactory.show_AlertFactory('El precio del producto ' + $scope.products[i].description + ' no puede ser igual a cero o estar vacío.');
                    angular.element(document.querySelector('#price' + i)).focus();
                    return false;
                }
            }

            return true;
        };

        $scope.addClient = function (actionCreate) {
            var obj = {'id': 0};

            if (!actionCreate) {
                obj = {
                    'id': 0,
                    entity: 'lol'
                };
            }

            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/sales/client/extends.html',
                controller: 'ExtendClientCtrl',
                size: 'lg',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                if (!_.isUndefined(result)) {
                    var data = result.data;
                    $scope.client = data.id;
                    $scope.proforma.email = data.email;
                    $scope.proforma.cellphone = data.cellphone;
                    $scope.proforma.address = data.address;

                    $timeout(function () {
                        angular.element(document.querySelector('#search_client_value')).val(data.fullname);
                        angular.element(document.querySelector('#search_client_value')).attr('disabled', 'disabled');
                    }, 50);
                }
            });
        };

        $scope.addAccountBank = function (actionCreate) {
            var obj = {'id': 0};
            if (!actionCreate){
                obj = {
                    'id': 0,
                    entity: null
                };
            }
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/finance/accountbank/extends.html',
                controller: 'ExtendAccountBankCtrl',
                size: 'md',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                if (!_.isUndefined(result)) {
                    var data = result.data;
                    $scope.bankaccounts.push(data);
                    $scope.bankAccountSelected = data;
                    $scope.bankaccounts_exists = true;
                }
            });
        };

        $scope.addProduct = function (actionCreate) {
            var obj = {'id': 0};
            if (!actionCreate){
                obj = {
                    'id': 0,
                    entity: null
                };
            }
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/catalog/product/extends.html',
                controller: 'ExtendCatalogProductCtrl',
                size: 'lg',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                if (!_.isUndefined(result)) {
                    var response = {};
                    response.originalObject = result.data;
                    $scope.selectedProduct(response);
                }
            });
        };

        $scope.close = function () {
            $state.transitionTo('sales.proformas', null, {'reload': true});
        };
    }


})();
