(function () {
    'use strict';

    angular.module('sys.app.proformas', [
        'sys.app.proformas.new',
        'sys.app.proformas.detail'
    ]);


    angular.module('sys.app.proformas').config(Config);

    //region INJECT AND CONFIG
    Config.$inject = ['$stateProvider', '$urlRouterProvider'];

    function Config($stateProvider, $urlRouterProvider) {

        $stateProvider

            .state('sales.proformas.new', {
                url: '/nuevo',
                templateUrl: '../../templates/sales/proforma/new.html',
                controller: 'NewProformaCtrl',
                cache:false,
                params: {
                    entity: null
                },
                title:'Crear proforma',
                module:"proformas"
            })
            // editar producto
            .state('sales.proformas.edit', {
                url: '/editar',
                templateUrl: '../../templates/sales/proforma/new.html',
                controller: 'NewProformaCtrl',
                cache:false,
                params: {
                    entity: null
                },
                title:'Editar proforma',
                module:"proformas"
            })

            .state('sales.proformas.detail', {
                url: '/detalle',
                templateUrl: '../../templates/sales/proforma/detail.html',
                controller: 'DetailProformaCtrl',
                params: {
                    entity: null
                },
                title:'Detalle proforma',
                module:"proformas"
            })
        ;

        $urlRouterProvider.otherwise('/proformas');
    }

    //endregion
})();