(function () {
    'use strict';
    angular.module('sys.app.proformas')
        .controller('ProformaCtrl', ProformaCtrl);

    ProformaCtrl.$inject =['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory', '$http', '$timeout', 'notifyAlert', 'SEARCH', 'loadingAlert', '$uibModal', 'ORDER'];

    function ProformaCtrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $http, $timeout, notifyAlert, SEARCH, loadingAlert, $uibModal, ORDER) {

        $scope.entity = {};
        $scope.text= null;
        $scope.currentPage = 1;

        var start_range = moment().startOf('month');
        var end_range = moment().endOf('month');

        $scope.start_range = start_range;
        $scope.end_range = end_range;

        var object = "";

        init();
        sync();

        function init() {
            object = "search=" + $scope.text + '&page=' + $scope.currentPage+
                "&start_range=" + $scope.start_range.format('YYYY-MM-DD') + '&end_range=' + $scope.end_range.format('YYYY-MM-DD');
            RESTService.all('proformas/list', object + '&export=0', function (response) {
                $scope.allData = response.results;
                $scope.totalItems = response.total;
                $scope.itemsPerPage = response.paginate_by;
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };

        function sync() {
            $timeout(function () {
                $('#date_range').daterangepicker({
                        locale: {
                            format: 'MMM D, YYYY'
                        },
                        startDate: $scope.start_range,
                        endDate: $scope.end_range,
                        showDropdowns: true,
                    },
                    function (start, end, label) {
                        $scope.start_range = start;
                        $scope.end_range = end;
                        init();
                    }
                );
            }, 50);
        };

        $scope.edit = function (source) {
            delete $scope.allData;
            RESTService.get('proformas/edit', source.id, function (response) {
                $state.transitionTo("sales.proformas.edit", {
                    'id': source.id,
                    entity: response.data
                }, {'reload': "sales.proformas.edit", 'cache': false});
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };

        $scope.detail = function (source) {
            RESTService.get('proformas/detail', source.id, function (response) {
                $state.transitionTo("sales.proformas.detail", {
                    'id': source.id,
                    entity: response.data
                }, {'reload': "sales.proformas.detail", 'cache': false});
                delete $scope.allData;
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };

        $scope.searchAction = function (text) {
            $scope.text = text;
            $scope.currentPage = 1;
            if (text.length >= SEARCH.MIN_LETTERS || text.length == 0) {
                delete $scope.allData;
                init();
            }
        };

        $scope.pageChanged = function(page) {
            $scope.currentPage = page;
            delete $scope.allData;
            init();
        };

        $scope.selectedStatus = function (item) {
            $scope.statusSelected = item;
            init();
        };

        $scope.new = function () {
            var source = {'proforma': {'id':0 }};
            $state.transitionTo('sales.proformas.new', {entity: source}, {
                'reload': 'sales.proformas.new',
                'cache': false
            });
            delete $scope.allData;
        };


        $scope.refresh = function () {
            delete $scope.allData;
            $state.transitionTo('sales.proformas', {entity: null}, {'reload': true});
        };

        $scope.delete = function (item) {
            var options = {
                title: "Cuidado!!",
                message: "La proforma N° ' "+item.nro_voucher+" ' será eliminada",
                cancel: "Cancelar",
                confirm: "Eliminar"
            };
            AlertFactory.confirm(options, function () {
                RESTService.deleted('proformas/delete', item.id, function (response) {
                    notifyAlert.success("El item se ha eliminado con éxito!!");
                    var obj = {"text": $scope.text};
                    $state.transitionTo('sales.proformas', {entity: obj}, {'reload': true});
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });

            })
        };


        $scope.printProforma = function (item) {
            window.open('/print/proforma/document/'+ item.id);
        };

        $scope.openReport = function () {
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/helpers/order/modal_report_order.html',
                controller: 'ModalReportOrderCtrl',
                size: 'sm',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    VALS: function () {
                        var values = true;
                        return values;
                    }
                }
            }).result.then(function (result) {
                // console.log(result)
            });
        };

    }
})();


