(function () {

    'use strict';
    angular.module('sys.app.sale.detail')
        .controller('DetailSaleCtrl', DetailSaleCtrl);

    DetailSaleCtrl.$inject = ['$scope', '$stateParams', '$state', 'RESTService', 'EventsFactory', '$http', 'notifyAlert','_', 'HelperFactory', '$timeout', 'ORDER', 'SEARCH', 'AlertFactory', 'ConfigPagination', '$uibModal', 'VOUCHER', 'TRANSACTION'];

    function DetailSaleCtrl($scope, $stateParams, $state, RESTService, EventsFactory, $http, notifyAlert,_, HelperFactory, $timeout, ORDER, SEARCH, AlertFactory, ConfigPagination, $uibModal, VOUCHER, TRANSACTION) {

        try {

            $scope.check_sale = $stateParams.entity.sale;

            if (!_.isNull($scope.check_sale.id)) {
                $scope.entity = $stateParams.entity.sale;
                $scope.sale = $stateParams.entity.sale;

                $scope.voucher_ruc = VOUCHER['FACTURA'];
                $scope.voucher_boleta = VOUCHER['BOLETA'];
                $scope.voucher_income = VOUCHER['RECIBO_INGRESO'];
                $scope.voucher_expense = VOUCHER['RECIBO_EGRESO'];
                $scope.voucher_ordernote = VOUCHER['NOTA_PEDIDO'];

                if ($scope.sale.id != 0) {
                    $scope.sale.date_sale = $scope.entity.date_sale;
                    $scope.products = $stateParams.entity.detail;
                    $scope.movements = $stateParams.entity.movements;

                    // origin and channel sale

                    $scope.originsales = TRANSACTION.ORIGIN_SALE;
                    $scope.virtualchannels = TRANSACTION.VIRTUAL_CHANNELS;

                    $scope.originSaleSelected = {id:0, description:"-----"};
                    $scope.channelSaleSelected = {id:0, description:"-----"};


                    originSaleSelected($scope.sale.origin_id);
                    channelSaleSelected($scope.sale.channel_id);

                }
            }
        }
        catch (e) {
            $state.transitionTo('sales.sale', null, {'reload': true});
            console.log(e);
            return false;
        }

        function originSaleSelected(id) {
            if(!_.isUndefined(id)){
                $scope.originSaleSelected = ConfigPagination.searchById(id, $scope.originsales);
            }
        }

        function channelSaleSelected(id) {
            if(!_.isUndefined(id)){
                $scope.channelSaleSelected = ConfigPagination.searchById(id, $scope.virtualchannels);
            }
        }

        $scope.delete = function (item) {
            // var options = {
            //     title: "Cuidado!!",
            //     message: "La entrada de almacén N° ' "+item.nro_voucher+" ' será eliminado",
            //     cancel: "Cancelar",
            //     confirm: "Eliminar"
            // };
            // AlertFactory.confirm(options, function () {
            //     RESTService.deleted('entry/delete', item.id, function (response) {
            //         notifyAlert.success("El item se ha eliminado con éxito!!");
            //         var obj = {"text": $scope.text};
            //         $state.transitionTo('warehouse.entry', {entity: obj}, {'reload': true});
            //
            //
            //     }, function (error) {
            //         console.log('ERROR');
            //         return false;
            //     });
            //
            // })
        };

        $scope.goToMoneyMovement = function (item) {
            var text = item.nro_voucher;
            $state.transitionTo('money.moneymovements', {entity: text}, {'reload': true});
        }

        $scope.close = function () {
            $state.transitionTo('sales.sale', null, {'reload': true});
        }


    }

})();

