(function () {
    'use strict';

    angular.module('sys.utils.utils')
        .controller('ExportSaleCtrl', ExportSaleCtrl);

    ExportSaleCtrl.$inject = ['$scope', '$state', 'RESTService', 'notifyAlert', '_', 'HelperFactory', 'ConfigPagination', 'PARAM', '$uibModalInstance', '$timeout', 'EXPORT'];

    function ExportSaleCtrl($scope, $state, RESTService, notifyAlert, _, HelperFactory, ConfigPagination, PARAM, $uibModalInstance, $timeout, EXPORT) {

        $scope.start_range = PARAM.start_range;
        $scope.end_range = PARAM.end_range;

        // $scope.provider = null;

        var object = "";

        init()

        function init() {

            $scope.formats = EXPORT.FORMAT;
            $scope.formatSelected = EXPORT.FORMAT[0];

            // // type vouchers
            // $scope.typevouchers = PARAM.typevouchers;
            // var last = $scope.typevouchers.length;
            // $scope.typeVoucherSelected = $scope.typevouchers[last - 1];
            //
            // // status voucher
            // $scope.statusvoucher = EXPORT.STATUS_VOUCHER;
            // $scope.statusSelected = EXPORT.STATUS_VOUCHER[0];


            $timeout(function () {
                $('#date_range').daterangepicker({
                        locale: {
                            format: 'MMM D, YYYY'
                        },
                        startDate: $scope.start_range,
                        endDate: $scope.end_range,
                        showDropdowns: true,
                    },
                    function (start, end, label) {
                        $scope.start_range = start;
                        $scope.end_range = end;
                    }
                );
            }, 50);
        }


        $scope.generate = function () {
            if (validate()) {
                // object = "start_range=" + $scope.start_range.format('YYYY-MM-DD') + '&end_range=' + $scope.end_range.format('YYYY-MM-DD') + '&format='
                //     + $scope.formatSelected.id + '&voucher=' + $scope.typeVoucherSelected.id + '&status=' + $scope.statusSelected.id + '&provider=' + $scope.provider;

                object = "start_range=" + $scope.start_range.format('YYYY-MM-DD') + '&end_range=' + $scope.end_range.format('YYYY-MM-DD') + '&format='
                    + $scope.formatSelected.id;
                window.open('/report/sale/sales?' + object);
            }
        };

        function validate() {
            if (_.isNull($scope.date_range)) {
                HelperFactory.show_AlertFactory('Debe ingresar un rango de fechas.');
                angular.element(document.querySelector('#date_range')).focus();
                return false;
            }
            return true;
        }

        $scope.closeModal = function () {
            $uibModalInstance.dismiss();
        };
    }

})();
