(function () {
    'use strict';
    angular.module('sys.app.sale.new')
        .controller('NewSaleCtrl', NewSaleCtrl);

    NewSaleCtrl.$inject = ['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory', '$timeout', 'notifyAlert', 'SEARCH', 'HelperFactory', 'CLIENT', '$uibModal', '$stateParams', 'TYPE_DOCUMENT', 'VOUCHER', 'PRODUCT', 'TRANSACTION', 'PAYMENT_METHOD'];

    function NewSaleCtrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $timeout, notifyAlert, SEARCH, HelperFactory, CLIENT, $uibModal, $stateParams, TYPE_DOCUMENT, VOUCHER, PRODUCT, TRANSACTION, PAYMENT_METHOD) {

        var quantity_default = 1;
        $scope.date_sale_now = moment().format('dddd D, MMM Y');
        $scope.max_lenght_grouped = 255;

        $scope.subtotal = 0;
        $scope.total_igv = 0;
        $scope.total_sale = 0;
        $scope.text_amount = null;
        // paid form
        $scope.total_paid = 0;
        $scope.turned = 0;

        $scope.client = null;
        $scope.client_default = false;

        $scope.employee = null;

        $scope.sale_cash = TRANSACTION.TYPES[0];
        $scope.sale_credit = TRANSACTION.TYPES[1];
        $scope.intervalDates = TRANSACTION.INTERVALS;
        $scope.intervalDateSelected = TRANSACTION.INTERVALS[0];

        $scope.paymethod_deposit = PAYMENT_METHOD['deposit'];

        // origin and channel sale

        $scope.originsales = TRANSACTION.ORIGIN_SALE;
        $scope.originSaleSelected = TRANSACTION.ORIGIN_SALE[0];

        $scope.virtualchannels = TRANSACTION.VIRTUAL_CHANNELS;
        $scope.channelSaleSelected = TRANSACTION.VIRTUAL_CHANNELS[0];

        $scope.virtual_sale = TRANSACTION.ORIGIN_SALE[1];

        $scope.text = null;

        var typeprice = PRODUCT.TYPEPRICE;
        $scope.is_price_unit = typeprice[1];

        var boxPaid, boxProduct, boxDetail, btnsBoxDetail;

        $scope.currentPage = 1;

        $scope.bankaccounts = [];

        $scope.is_remake = false;
        $scope.data_remake = {};

        $scope.client_data = {};

        $scope.include_igv = false;

        $scope.is_barcode = false;
        $scope.placeholder_search = "Ingrese el producto a buscar";
        $scope.is_select_typevoucher = false;

        // reserva hotel
        $scope.book_hotel = null;

        try {
            $scope.check_sale = $stateParams.entity.sale;

            if (!_.isNull($scope.check_sale.id)) {
                $scope.entity = $stateParams.entity.sale;
                $scope.sale = $stateParams.entity.sale;

                if (!_.isUndefined($stateParams.entity.is_remake)) {
                    $scope.is_remake = true;
                    $scope.data_remake = $stateParams.entity;
                    $scope.sale.id = 0;
                }

                if ($scope.sale.id != 0) {
                    $scope.txt_title = 'Editar'
                    $scope.cart = $stateParams.entity.detail;
                    $timeout(function () {
                        sum_items()
                    }, 50);
                }
                else {
                    $scope.txt_title = 'Registrar';

                    $scope.cart = [];
                    $scope.sale = {
                        'is_igv': false,
                        'is_grouped': false,
                        'description_grouped': null,
                        'is_order': false,
                        'order_id': null,
                        'is_proforma': false,
                        'proforma_id': null,
                        'observation': null
                    };
                    $scope.paid = {
                        'is_paid': false,
                        'document': null,
                        'address': null,
                        'reference_operation': null,
                    };

                    $scope.schedule = {
                        'number_quota': null,
                        'first_date_schedule': null
                    };
                }
            }
        }
        catch (e) {
            $state.transitionTo('sales.sale', null, { 'reload': true });
            console.log(e);
            return false;
        }


        sync();

        function sync() {
            $scope.voucher_ruc = VOUCHER['FACTURA'];

            RESTService.all('branch/setting/general', null, function (response) {
                $scope.is_barcode = response.is_barcode;
                $scope.is_default_client = response.general.is_default_client;
                $scope.typevoucher_default = response.general.typevoucher_default;

                if ($scope.is_barcode == true) {
                    $scope.placeholder_search = "Código de barra";
                    angular.element(document.querySelector('#searchInput')).focus();
                }

                if ($scope.is_default_client) {
                    $scope.client_default = true;
                    $scope.selectClientDefault(true);
                }

                if ($scope.typevoucher_default != null) {
                    $scope.is_select_typevoucher = true;
                }
            });

            RESTService.all('config/typetransaction', null, function (response) {
                $scope.transactions = response.results;
                $scope.transactionSelected = response.results[0];
            });

            RESTService.all('warehouses/branchoffice', null, function (response) {
                $scope.warehouses = response.results;
                $scope.warehousesSelected = response.results[0];

                getListProducts($scope.warehousesSelected);
            });

            RESTService.all('config/paymentmethod', null, function (response) {
                $scope.paymentmethods = response.results;
                $scope.paymentSelected = response.results[0];
            });

            RESTService.all('config/typevoucher/sale', null, function (response) {
                $scope.typevouchers = response.results;
                $scope.typeVoucherSelected = response.results[0];
            });

            RESTService.all('config/tax', null, function (response) {
                $scope.igv = response.results[0].percentage;
                if (response.include_igv) {
                    $scope.include_igv = true;
                }
            });

            RESTService.all('config/currency', null, function (response) {
                $scope.currency = response.results;
                $scope.currencySelected = response.results[0];
            });


            $timeout(function () {
                $('#date_order').daterangepicker({
                    locale: {
                        format: 'YYYY-MM-DD'
                    },
                    singleDatePicker: true,
                    showDropdowns: true,
                    minDate: new Date()
                });

                // divs hide actions

                boxPaid = $(".boxPaid");
                boxProduct = $(".boxProduct");
                boxDetail = $(".boxDetail");
                btnsBoxDetail = $(".btnsBoxDetail");

            }, 50);

            $timeout(function () {
                if ($scope.is_remake == true) {
                    remakeSale($scope.data_remake);
                };
            }, 2500);
        }

        function remakeSale(result) {

            $scope.cart = [];
            var data = result;

            var order = data.sale;
            var products_order = data.detail;

            $scope.client = order.client_id;
            $scope.type_document = order.typeDocument;
            $scope.paid.document = order.client_document;
            $scope.paid.address = order.client_address;
            angular.element(document.querySelector('#search_client_value')).attr('disabled', 'disabled');
            angular.element(document.querySelector('#search_client_value')).val(order.client_fullname);

            $.each(products_order, function (i, product) {
                product.warehouse_id = $scope.warehousesSelected.id;
                $scope.cart.push(product);
            });

            $timeout(function () {
                $.each(products_order, function (i, product) {
                    var index = i;
                    var units = product.unitsmeasure;

                    $("#unitSelected" + index).html('');
                    $.each(units, function (i, item) {
                        $("#unitSelected" + index).append($('<option>', {
                            value: item.id,
                            text: item.description + ' (' + item.equivalence + ')'
                        }));
                    });
                    $("#unitSelected" + index).val(product.unitmeasure_id);
                    var pos = $scope.cart.indexOf(product);
                    $scope.cart[pos].unit_id = product.unitmeasure_id;
                });

                sum_items();

                $scope.changeToPaid();

            }, 100);
        }


        $scope.selectIsGrouped = function (is_grouped) {
            $timeout(function () {
                angular.element(document.querySelector('#description_grouped')).focus();
            }, 50);
        };

        function getSerieVoucher(voucher_id) {
            RESTService.get('config/voucher/serie', voucher_id, function (response) {
                $scope.series = response.results;
                $scope.serieSelected = response.results[0];
            });
        };

        $scope.changeTypeTransacation = function (transaction) {
            if (transaction.id == $scope.sale_cash.id) {// venta al contado
                //
            }
            else if (transaction.id == $scope.sale_credit.id) {

                $timeout(function () {
                    $('#first_date_schedule').datepicker({
                        dateFormat: 'yy-mm-dd',
                        autoclose: true,
                        minDate: new Date(),
                    });

                    $('[data-toggle="tooltip"]').tooltip();

                }, 100);

            }
        }

        $scope.changeTypeVoucher = function (typeVoucher) {
            $scope.typeVoucherSelected = typeVoucher;
            if (typeVoucher.id == $scope.voucher_ruc) {
                if ($scope.client_default) {
                    angular.element(document.querySelector('#search_client_value')).removeAttr('disabled').focus();
                    angular.element(document.querySelector('#search_client_value')).val('');
                    $scope.client = null;
                    $scope.client_default = false;
                    $scope.$broadcast('angucomplete-alt:clearInput', 'search_client');
                }
            };

            getSerieVoucher($scope.typeVoucherSelected.id);
        }

        $scope.changeOriginSale = function (origin) {
            $scope.originSaleSelected = origin;
        };

        $scope.changeChannelSale = function (channel) {
            $scope.channelSaleSelected = channel;
        };

        $scope.changeToPaid = function () {

            if ($scope.is_select_typevoucher) {
                typeVoucherDefaultSelected($scope.typevoucher_default);
            }

            boxProduct.hide("slide", { direction: "right" }, 50, function () {
                boxPaid.css("display", "block");
                btnsBoxDetail.css("display", "none");

                $('[data-toggle="tooltip"]').tooltip();
                angular.element(document.querySelector('#search_client_value')).focus();
                $scope.paid.is_paid = true;
                getSerieVoucher($scope.typeVoucherSelected.id);
            });
        }

        $scope.changeToProduct = function () {
            boxPaid.hide("slide", { direction: "right" }, 50, function () {
                boxProduct.css("display", "block");
                btnsBoxDetail.css("display", "block");
                $scope.paid.is_paid = false;
                getListProducts($scope.warehousesSelected);
            });
        };

        $scope.changePayment = function (item) {
            $scope.paymentSelected = item;
            if (item.id == $scope.paymethod_deposit.id) {
                RESTService.all('accountbanks/search/all', null, function (response) {
                    $scope.bankaccounts = response.results;
                    $scope.bankaccounts_exists = false;
                    if ($scope.bankaccounts.length > 0) {
                        $scope.bankaccounts_exists = true;
                        $scope.bankAccountSelected = response.results[0];
                    }
                });
            }
        };

        function typeVoucherDefaultSelected(id) {
            if (!_.isUndefined(id)) {
                $scope.typeVoucherSelected = ConfigPagination.searchById(id, $scope.typevouchers);
            }
        };

        $scope.changeBankAccount = function (item) {
            $scope.bankAccountSelected = item;
        };

        $scope.changeIntervalDate = function (intervalDate) {
            $scope.intervalDateSelected = intervalDate;
        }

        $scope.selectClientDefault = function (client_default) {
            if (client_default) {
                $scope.client = CLIENT.DEFAULT;
                $scope.client_data = { email: '' };
                $scope.paid.document = null;
                $scope.paid.address = null;
                $timeout(function () {
                    $(".removeClient").hide();
                    angular.element(document.querySelector('#search_client_value')).attr('disabled', 'disabled');
                    angular.element(document.querySelector('#search_client_value')).val('VARIOS');
                }, 100);
            } else {
                $(".removeClient").show();
                angular.element(document.querySelector('#search_client_value')).removeAttr('disabled').focus();
                angular.element(document.querySelector('#search_client_value')).val('');
                $scope.client = null;
                $scope.$broadcast('angucomplete-alt:clearInput', 'search_client');
            }
        }

        $scope.reloadProduct = function () {
            $scope.searchInput = null;
            $scope.text = null;
            angular.element(document.querySelector('#searchInput')).val(null).focus();
            delete $scope.products;
            $scope.products = [];
            getListProducts($scope.warehousesSelected);
        };

        $scope.changeWarehousesSelected = function (item) {
            $scope.warehousesSelected = item;
            getListProducts(item);
        }

        function getListProducts(warehouse) {
            var url = 'product/sale/search';
            var object = "search=" + $scope.text + '&warehouse_id=' + warehouse.id;
            $scope.products_favorites = false;

            if ($scope.is_barcode == true) {
                if (!_.isNull($scope.text) && $scope.text.length > 2) {
                    RESTService.all(url, object, function (response) {
                        $scope.addItem(response.data[0]);
                        $timeout(function () {
                            $scope.reloadProduct();
                        }, 100);
                    });
                }
                else {
                    url = 'product/favorite/';
                    object = "warehouse_id=" + warehouse.id + '&page=' + $scope.currentPage;
                    $scope.products_favorites = true;
                    RESTService.all(url, object, function (response) {
                        $scope.products = response.data;
                        if ($scope.products_favorites) {
                            $scope.totalItems = response.total;
                            $scope.itemsPerPage = response.paginate_by;
                        }
                        else {
                            $scope.currentPage = 1;
                        }
                    });

                }

            } else {
                if (_.isNull($scope.text) || $scope.text.length == 0) {
                    url = 'product/favorite/';
                    object = "warehouse_id=" + warehouse.id + '&page=' + $scope.currentPage;
                    $scope.products_favorites = true;
                }
                RESTService.all(url, object, function (response) {
                    $scope.products = response.data;
                    if ($scope.products_favorites) {
                        $scope.totalItems = response.total;
                        $scope.itemsPerPage = response.paginate_by;
                    }
                    else {
                        $scope.currentPage = 1;
                    }
                });
            }
        };

        $scope.setBarcode = function (is_barcode) {
            $scope.is_barcode = is_barcode;
            if (is_barcode) {
                $scope.placeholder_search = "Código de barra";
            }
            else {
                $scope.placeholder_search = "Ingrese el producto a buscar";
            }
            $scope.reloadProduct();
        }

        $scope.pageChanged = function (page) {
            $scope.currentPage = page;
            delete $scope.allData;
            getListProducts($scope.warehousesSelected);
        };

        $scope.$on("fileProgress", function (e, progress) {
            $scope.progress = progress.loaded / progress.total;
        });

        $scope.selectedClient = function (response) {
            if (!_.isUndefined(response)) {
                var data = response.originalObject;
                $scope.client_data = data;
                $scope.client = data.id;
                $scope.type_document = data.typeDocument;
                $scope.paid.document = data.document;
                $scope.paid.address = data.address;
                angular.element(document.querySelector('#search_client_value')).attr('disabled', 'disabled');
            }
        }

        $scope.removeClient = function () {
            angular.element(document.querySelector('#search_client_value')).removeAttr('disabled').focus();
            angular.element(document.querySelector('#search_client_value')).val('');
            $scope.client = null;
            $scope.paid.document = null;
            $scope.paid.address = null;
            $scope.$broadcast('angucomplete-alt:clearInput', 'search_client');
        };

        $scope.selectedEmployee = function (response) {
            if (!_.isUndefined(response)) {
                var data = response.originalObject;
                $scope.employee = data.id;
                $scope.employe_data = data;
                angular.element(document.querySelector('#search_employee_value')).attr('disabled', 'disabled');
            }
        };

        $scope.removeEmployee = function () {
            angular.element(document.querySelector('#search_employee_value')).removeAttr('disabled').focus();
            angular.element(document.querySelector('#search_employee_value')).val('');
            $scope.employee = null;
            $scope.$broadcast('angucomplete-alt:clearInput', 'search_employee');
        };

        $scope.searchAction = function (text) {
            $scope.text = text;
            if (text.length >= SEARCH.MIN_LETTERS || text.length == 0) {
                delete $scope.products;
                getListProducts($scope.warehousesSelected);
            }
        };

        $scope.listPriceUnit = function (product) {
            var obj = {
                'product': product,
                'currency': $scope.currencySelected
            };
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/sales/sale/priceunits.html',
                controller: 'ExtendsPriceUnitsCtrl',
                size: 'modal-dialog modal-dialog-centered',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                // init();
            });
        };

        $scope.addItem = function (item) {
            var valid_stock = validExistStock(item);
            if (valid_stock) {
                var unique = ifExist(item);

                if (unique) {
                    item.detail_id = null;
                    item.quantity = quantity_default;
                    item.price = item.price_sale;
                    item.warehouse_id = $scope.warehousesSelected.id;
                    item.igv = 0;
                    item.total = 0;
                    item.is_igv = false;
                    // item.igv = null;
                    // item.total = null;
                    // var subtotal_ = Number(Number(item.price) * Number(item.quantity)).toFixed(2);
                    var subtotal_ = numero.getRound((Number(item.price) * Number(item.quantity)));

                    item.subtotal = subtotal_;

                    if ($scope.include_igv) {
                        // var igv = ((item.subtotal * $scope.igv) / 100).toFixed(2);
                        var igv = numero.getRound(((item.subtotal * $scope.igv) / 100));
                        var total = Number(item.subtotal) + Number(igv);

                        item.igv = igv;
                        item.total = total;
                        item.is_igv = true;

                    }

                    $scope.cart.push(item);

                    var last = $scope.cart.length;
                    $timeout(function () {
                        listUnitMeasureProduct(last, item);
                    }, 50);

                    $timeout(function () {
                        sum_items();
                    }, 300);

                    checkIsIgv();
                }
                else {
                    if ($scope.is_barcode == true) {
                        var cart = $scope.cart;

                        for (var key in cart) {
                            if (cart[key].id === item.id) {

                                var check_quantity = angular.element(document.querySelector('#quantity' + key)).val();
                                var q_ = check_quantity;
                                q_ = Number(q_) + 1;

                                angular.element(document.querySelector('#quantity' + key)).val(q_);

                                var quantity = angular.element(document.querySelector('#quantity' + key)).val();

                                var index = key;
                                var subtotal = (Number(quantity) * Number($scope.cart[index].price))

                                var igv = 0;
                                if ($scope.include_igv) {
                                    if ($scope.cart[index].is_igv == true) {
                                        igv = ((subtotal * $scope.igv) / 100).toFixed(2);
                                    }
                                }

                                var total = Number(subtotal) + Number(igv);

                                $scope.cart[index].quantity = quantity;
                                $scope.cart[index].subtotal = subtotal;
                                $scope.cart[index].igv = igv;
                                $scope.cart[index].total = total;

                                $timeout(function () {
                                    sum_items();
                                }, 300);
                            }
                        }
                    }
                    else {
                        notifyAlert.warning('El producto ' + item.description + ' ya se encuentra agregado');
                    }
                }
            }
        };

        function checkIsIgv() {
            // $("#is_igv_" + item.id).prop('checked', true);
            $timeout(function () {
                $.each($scope.cart, function (i, item) {
                    if (item.is_igv == true) {
                        $("#is_igv_" + item.id).prop('checked', true);
                    }
                });
            }, 200);
        };

        function validExistStock(item) {
            var response = true
            if (item.is_control_stock) {
                $.each(item.productstock, function (i, stock) {
                    if (stock.warehouse_id == $scope.warehousesSelected.id && stock.stock == 0) {
                        notifyAlert.error('El producto ' + item.description + ' no cuenta con stock suficiente en el almacén ' + $scope.warehousesSelected.description);
                        response = false;
                        return false;

                    }
                });
            }
            return response;
        }

        function listUnitMeasureProduct(pos, product) {
            var index = pos - 1;
            var units = product.unitsmeasure;

            $("#unitSelected" + index).html('');
            $.each(units, function (i, item) {

                $("#unitSelected" + index).append($('<option>', {
                    value: item.id,
                    // text : item.description + ' ('+item.equivalence+')'
                    text: item.description
                }));
            });

            $("#unitSelected" + index).val(units[0].id);
            // $("#unitSelected" + index).attr('disabled', 'disabled');
            $(".completeDescription").tooltip();

            var pos = $scope.cart.indexOf(product);
            $scope.cart[pos].unit_id = units[0].id;

            if (product.typeprice_id == $scope.is_price_unit.id) {
                $scope.cart[pos].price = units[0].price_sale;
                $scope.cart[pos].price_sale = units[0].price_sale;
                var subtotal_ = Number(Number(units[0].price_sale) * Number($scope.cart[pos].quantity)).toFixed(2);
                $scope.cart[pos].subtotal = subtotal_;
            }
        };

        $scope.change_unitmeasure = function (unitSelected, product, $index) {
            var check_unit = angular.element(document.querySelector('#unitSelected' + $index)).val();
            var pos = $scope.cart.indexOf(product);
            $scope.cart[pos].unit_id = check_unit;

            if (product.typeprice_id == $scope.is_price_unit.id) {
                var unit_price = ConfigPagination.searchById(unitSelected, product.unitsmeasure);
                $scope.cart[pos].price = unit_price.price_sale;
                $scope.cart[pos].price_sale = unit_price.price_sale;

                $("#price" + $index).val(unit_price.price_sale);

                var subtotal_ = Number(Number(unit_price.price_sale) * Number($scope.cart[pos].quantity)).toFixed(2);
                $scope.cart[pos].subtotal = subtotal_;

                $timeout(function () {
                    sum_items();
                }, 300);
            }
        };

        $scope.removeItem = function ($event, product, $index) {
            $event.preventDefault();
            var index = $scope.cart.indexOf(product);
            $scope.cart.splice(index, 1);
            $timeout(function () {
                sum_items();
            }, 300);
            notifyAlert.info("El producto " + product.description + ' ha sido removido del detalle');
        };

        function ifExist(obj) {
            var cart = $scope.cart;
            var is_unique = true;
            for (var key in cart) {
                if (cart[key].id === Number(obj.id)) {
                    is_unique = false;
                    break;
                }
            }
            return is_unique;
        };

        $scope.changeSaleIgv = function (igv) {
            if ($scope.cart.length > 0) {
                if (igv) {
                    for (var i in $scope.cart) {
                        var item = $scope.cart[i];
                        var index = $scope.cart.indexOf(item);
                        var igv = ((item.subtotal * $scope.igv) / 100).toFixed(2);
                        var total = Number(item.subtotal) + Number(igv);
                        $scope.cart[index].igv = igv;
                        $scope.cart[index].total = total;
                    }

                } else {
                    for (var i in $scope.cart) {
                        var item = $scope.cart[i];
                        var index = $scope.cart.indexOf(item);
                        var igv = 0;
                        var total = Number(item.subtotal) + Number(igv);
                        $scope.cart[index].igv = igv;
                        $scope.cart[index].total = total;
                    }
                }
                $timeout(function () {
                    sum_items();
                }, 300);
            }
        };

        $scope.recalculate_quantity = function (count, product, $index) {
            var check_quantity = angular.element(document.querySelector('#quantity' + $index)).val();
            var q_ = check_quantity;

            angular.element(document.querySelector('#quantity' + $index)).val(q_);

            var quantity = angular.element(document.querySelector('#quantity' + $index)).val();

            if (!_.isNaN(quantity * 1)) {
                var index = $scope.cart.indexOf(product);
                var subtotal = (Number(quantity) * Number($scope.cart[index].price))

                var igv = 0;
                if ($scope.include_igv) {
                    if (product.is_igv == true) {
                        igv = ((subtotal * $scope.igv) / 100).toFixed(2);
                    }
                }

                var total = Number(subtotal) + Number(igv);

                $scope.cart[index].quantity = quantity;
                $scope.cart[index].subtotal = subtotal;
                $scope.cart[index].igv = igv;
                $scope.cart[index].total = total;

                $timeout(function () {
                    sum_items();
                }, 300);
            }
        };

        $scope.recalculate_price = function (price, product, $index) {

            var check_price = angular.element(document.querySelector('#price' + $index)).val();
            var q_ = check_price;

            angular.element(document.querySelector('#price' + $index)).val(q_);

            var price_get = angular.element(document.querySelector('#price' + $index)).val();

            if (!_.isNaN(price_get * 1)) {

                var index = $scope.cart.indexOf(product);

                var subtotal = (Number(product.quantity) * Number(price_get)).toFixed(2);
                var igv = 0;
                if ($scope.include_igv) {
                    if (product.is_igv == true) {
                        igv = ((subtotal * $scope.igv) / 100).toFixed(2);
                    }
                }
                var total = Number(subtotal) + Number(igv);

                $scope.cart[index].subtotal = subtotal;
                $scope.cart[index].price = Number(price_get);
                $scope.cart[index].igv = igv;
                $scope.cart[index].total = total;
                $timeout(function () {
                    sum_items();
                }, 300);
            }
        };

        $scope.recalculate_igv = function (igv, product, $index) {

            var check_igv = angular.element(document.querySelector('#igv' + $index)).val();
            var q_ = check_igv;

            angular.element(document.querySelector('#igv' + $index)).val(q_);

            var price_get = angular.element(document.querySelector('#igv' + $index)).val();

            if (!_.isNaN(price_get * 1)) {

                var index = $scope.cart.indexOf(product);
                // var subtotal = (Number(product.quantity) * Number(product.price)).toFixed(2);
                var subtotal = numero.getRound((Number(product.quantity) * Number(product.price)));

                var igv = price_get;
                var total = Number(subtotal) + Number(igv);

                $scope.cart[index].igv = igv;
                $scope.cart[index].total = total;
                $timeout(function () {
                    sum_items();
                }, 300);
            }
        };

        $scope.recalculate_turned = function (price) {

            var check_price = angular.element(document.querySelector('#total_received')).val();
            var q_ = check_price;

            angular.element(document.querySelector('#total_received')).val(q_);

            var price_get = angular.element(document.querySelector('#total_received')).val();

            if (!_.isNaN(price_get * 1)) {

                if (Number(price_get) > Number($scope.total_paid)) {
                    $scope.turned = (Number(price_get) - Number($scope.total_paid)).toFixed(2);
                }
                else {
                    $scope.turned = 0;
                }
            }
        };

        $scope.change_is_igv = function (is_igv_, product, $index) {

            var igv = 0;
            var index = $scope.cart.indexOf(product);
            var subtotal = (Number(product.quantity) * Number(product.price)).toFixed(2);

            if (is_igv_ == true) {
                igv = ((product.subtotal * $scope.igv) / 100).toFixed(2);

            }

            var total = Number(subtotal) + Number(igv);

            $scope.cart[index].is_igv = is_igv_;
            $scope.cart[index].igv = igv;
            $scope.cart[index].total = total;

            $timeout(function () {
                sum_items();
            }, 300);
        }

        function sum_items() {
            $scope.subtotal = 0;
            $scope.total_sale = 0;
            $scope.total_igv = 0;

            for (var i in $scope.cart) {
                var item = $scope.cart[i];

                $scope.subtotal = (Number($scope.subtotal) + numero.getRound((Number(item.price) * Number(item.quantity)))).toFixed(2);
                // $scope.subtotal = (Number($scope.subtotal) + (Number(item.price) * Number(item.quantity))).toFixed(2);
                // $scope.total_igv = (Number($scope.total_igv) + Number(item.igv)).toFixed(2);
                $scope.total_igv = Number($scope.total_igv) + Number(item.igv);

            }

            $scope.total_sale = (Number($scope.subtotal) + Number($scope.total_igv)).toFixed(2);
            $scope.text_amount = numero.letras($scope.total_sale);

            // paid data
            $scope.total_paid = $scope.total_sale;
            $scope.total_received = null;
            angular.element(document.querySelector('#total_received')).val('');
            $scope.turned = 0;

        };

        $scope.savePaid = function () {
            if (validate()) {
                $scope.sale['client_id'] = $scope.client;
                $scope.sale['employe_id'] = $scope.employee;
                $scope.sale['typetransaction_id'] = $scope.transactionSelected.id;
                $scope.sale['igv'] = $scope.total_igv;
                $scope.sale['subtotal'] = $scope.subtotal;
                $scope.sale['total'] = $scope.total_sale;

                // about sale origin
                $scope.sale['origin_id'] = $scope.originSaleSelected.id;
                $scope.sale['channel_id'] = $scope.channelSaleSelected.id;

                $scope.paid['client_default'] = $scope.client_default;
                $scope.paid['currency_id'] = $scope.currencySelected.id;
                $scope.paid['typevoucher_id'] = $scope.typeVoucherSelected.id;
                $scope.paid['paymentmethod_id'] = $scope.paymentSelected.id;
                $scope.paid['serie'] = $scope.serieSelected.series;
                $scope.paid['text_amount'] = $scope.text_amount;

                var accountbank_id = null;
                if ($scope.bankaccounts.length > 0) {
                    if ($scope.paymentSelected.id == $scope.paymethod_deposit.id) {
                        accountbank_id = $scope.bankAccountSelected.id;
                    }
                }

                $scope.paid['accountbank_id'] = accountbank_id;

                var data = {};
                data.sale = $scope.sale;
                data.paid = $scope.paid;
                data.detail = $scope.cart;

                var messag_alert = "¿Esta seguro(a) de confirmar el pago de la venta?";

                if ($scope.client_data.email != null) {
                    messag_alert = "¿Esta seguro(a) de confirmar el pago de la venta?, <b>el comprobante también se enviará al correo del cliente </br>" + $scope.client_data.email + "</b>";
                }

                var options = {
                    title: "¡Atención!",
                    message: messag_alert,
                    cancel: "Cancelar",
                    confirm: "Confirmar"
                };

                if ($scope.transactionSelected.id == $scope.sale_credit.id) {
                    options.message = "¿Esta seguro(a) de confirmar la venta al crédito?";
                    $scope.schedule['interval_schedule'] = $scope.intervalDateSelected.id;

                    data.schedule = $scope.schedule;
                }

                AlertFactory.confirmWarning(options, function () {
                    RESTService.save('sales/save', data, function (result) {
                        notifyAlert.success("Registro realizado con éxito!!");

                        if (result.billing != false) {
                            var billing = result.billing;
                            var label;
                            label = '<span class="badge badge-success f-s-12 p-5">' + billing.message + '</span>';

                            if (billing.code == 'pending') {
                                label = '<span class="badge badge-warning f-s-12 p-5">' + billing.message + '</span>';
                            }

                            // send email ============
                            // sendEmailSale(result.sale.id);
                            $scope.sale_id_temp = result.sale.id;
                            var email_client = "";
                            if (!_.isNull($scope.client_data.email)) {
                                email_client = $scope.client_data.email;
                            }

                            swal({
                                title: "EN HORA BUENA!",
                                html: '<b>Venta registrada correctamente</b>, desea imprimir el comprobante?</br></br>' + label + ' ',
                                type: "success",
                                showCancelButton: true,
                                confirmButtonColor: "#30419b",
                                cancelButtonClass: 'btn btn-secondary ml-2',
                                confirmButtonText: 'Imprimir <i class="fas fa-print m-r-5"></i>',
                                cancelButtonText: "Cancelar",
                                footer: '<div class="col-lg-12 col-12">\n' +
                                    '    <div id="loading_email" class="loading_email"><div class="spinner-border text-primary" role="status"><span class="sr-only">loading...</span></div><p class="f-s-9 m-b-0">Enviando correo</p></div>' +
                                    '<div class="row">\n' +
                                    '        <div class="col-lg-7 col-6">\n' +
                                    '            <input id="email_client" type="email" class="form-control form-control-sm" placeholder="Ingrese el correo del cliente" value="' + email_client + '">\n' +
                                    '        </div>\n' +
                                    '        <div class="col-lg-5 col-6">\n' +
                                    '            <button id="sendEmail" class="btn btn-sm btn-outline-info w-100">Enviar al correo<i class="fas fa-envelope-open m-l-5"></i></button>\n' +
                                    '        </div>\n' +
                                    '    </div>\n' +
                                    '</div>'
                            }).then(function (isConfirm) {
                                if (isConfirm.value == true) {
                                    window.open('/print/billing/document/' + result.sale.id);
                                } else {
                                }
                            });
                        } else {
                            swal({
                                title: "EN HORA BUENA!",
                                html: '<b>Venta registrada correctamente</b>, desea imprimir el comprobante?',
                                type: "success",
                                showCancelButton: true,
                                confirmButtonColor: "#30419b",
                                cancelButtonClass: 'btn btn-secondary ml-2',
                                confirmButtonText: 'Imprimir <i class="fas fa-print m-r-5"></i>',
                                cancelButtonText: "Cancelar",
                            }).then(function (isConfirm) {
                                if (isConfirm.value == true) {
                                    window.open('/print/billing/document/' + result.sale.id);
                                } else {
                                }
                            });
                        }

                        $state.transitionTo('sales.sale', null, { 'reload': true });

                    });
                });
            }
        };

        $scope.addToBook = function () {
            if (validate()) {
                $scope.sale['client_id'] = $scope.client;
                $scope.sale['employe_id'] = $scope.employee;
                $scope.sale['typetransaction_id'] = $scope.transactionSelected.id;
                $scope.sale['igv'] = $scope.total_igv;
                $scope.sale['subtotal'] = $scope.subtotal;
                $scope.sale['total'] = $scope.total_sale;

                $scope.sale['client_default'] = $scope.client_default;

                // about sale origin
                $scope.sale['origin_id'] = $scope.originSaleSelected.id;
                $scope.sale['channel_id'] = $scope.channelSaleSelected.id;

                if ($scope.book_hotel != null) {
                    $scope.sale['bookinghotel_id'] = $scope.book_hotel.booking_id;                    
                }               

                var data = {};
                data.sale = $scope.sale;
                data.detail = $scope.cart;

                var messag_alert = "¿Esta seguro(a) de agregar la venta a la reserva de hotel?";

                var options = {
                    title: "¡Atención!",
                    message: messag_alert,
                    cancel: "Cancelar",
                    confirm: "Confirmar"
                };

                AlertFactory.confirmWarning(options, function () {
                    RESTService.save('sales/save/bookhotel', data, function (result) {
                        notifyAlert.success("Registro realizado con éxito!!");
                        console.log(result);
                        
                        // if (result.billing != false) {
                        //     var billing = result.billing;
                        //     var label;
                        //     label = '<span class="badge badge-success f-s-12 p-5">' + billing.message + '</span>';

                        //     if (billing.code == 'pending') {
                        //         label = '<span class="badge badge-warning f-s-12 p-5">' + billing.message + '</span>';
                        //     }

                        //     // send email ============
                        //     // sendEmailSale(result.sale.id);
                        //     $scope.sale_id_temp = result.sale.id;
                        //     var email_client = "";
                        //     if(!_.isNull($scope.client_data.email)){
                        //         email_client = $scope.client_data.email;
                        //     }

                        //     swal({
                        //         title: "EN HORA BUENA!",
                        //         html: '<b>Venta registrada correctamente</b>, desea imprimir el comprobante?</br></br>' + label + ' ',
                        //         type: "success",
                        //         showCancelButton: true,
                        //         confirmButtonColor: "#30419b",
                        //         cancelButtonClass: 'btn btn-secondary ml-2',
                        //         confirmButtonText: 'Imprimir <i class="fas fa-print m-r-5"></i>',
                        //         cancelButtonText: "Cancelar",
                        //         footer: '<div class="col-lg-12 col-12">\n' +
                        //             '    <div id="loading_email" class="loading_email"><div class="spinner-border text-primary" role="status"><span class="sr-only">loading...</span></div><p class="f-s-9 m-b-0">Enviando correo</p></div>' +
                        //             '<div class="row">\n' +
                        //             '        <div class="col-lg-7 col-6">\n' +
                        //             '            <input id="email_client" type="email" class="form-control form-control-sm" placeholder="Ingrese el correo del cliente" value="'+email_client+'">\n' +
                        //             '        </div>\n' +
                        //             '        <div class="col-lg-5 col-6">\n' +
                        //             '            <button id="sendEmail" class="btn btn-sm btn-outline-info w-100">Enviar al correo<i class="fas fa-envelope-open m-l-5"></i></button>\n' +
                        //             '        </div>\n' +
                        //             '    </div>\n' +
                        //             '</div>'
                        //     }).then(function (isConfirm) {
                        //         if (isConfirm.value == true) {
                        //             window.open('/print/billing/document/' + result.sale.id);
                        //         } else {
                        //         }
                        //     });
                        // }else{
                        //     swal({
                        //         title: "EN HORA BUENA!",
                        //         html: '<b>Venta registrada correctamente</b>, desea imprimir el comprobante?',
                        //         type: "success",
                        //         showCancelButton: true,
                        //         confirmButtonColor: "#30419b",
                        //         cancelButtonClass: 'btn btn-secondary ml-2',
                        //         confirmButtonText: 'Imprimir <i class="fas fa-print m-r-5"></i>',
                        //         cancelButtonText: "Cancelar",
                        //     }).then(function (isConfirm) {
                        //         if (isConfirm.value == true) {
                        //             window.open('/print/billing/document/' + result.sale.id);
                        //         } else {
                        //         }
                        //     });
                        // }

                        // $state.transitionTo('sales.sale', null, {'reload': true});

                    });
                });
            }
        };


        $(document).on('click', '#sendEmail', function (e) {
            e.preventDefault();
            var value_email = $("#email_client").val();
            if (validateEmail(value_email)) {
                $("#loading_email").show();
                $.ajax({
                    url: '/send/email/billing/' + $scope.sale_id_temp,
                    type: 'GET',
                    data: {
                        email: value_email
                    },
                    success: function (response) {
                        $("#loading_email").hide();
                        notifyAlert.info(response.msg + ' para ' + $scope.client_data.email);
                    },
                    error: (function (error) {
                        $("#loading_email").hide();
                        notifyAlert.error("Hubo un error al realizar el envío del correo. Para mayor información consulte a su administrador." + error);
                    })
                });
            }
            else {
                notifyAlert.warning("Por favor ingrese un formato de correo válido!!");
            }
        });

        function validateEmail(email) {
            var re = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            return re.test(email);
        }

        function sendEmailSale(sale_id) {
            if ($scope.client_data.email != '') {
                $.ajax({
                    url: '/send/email/billing/' + sale_id,
                    type: 'GET',
                    data: {
                        email: $scope.client_data.email
                    },
                    success: function (response) {
                        $("#loading_object").hide();
                        notifyAlert.info(response.msg + ' para ' + $scope.client_data.email);
                    },
                    error: (function (error) {
                        $("#loading_object").hide();
                        swal({
                            type: 'error',
                            title: 'Hubo un error !!',
                            html: "Hubo un error al realizar el envío. Para mayor información consulte a su administrador." + error
                        })
                    })
                });
            }
        }

        function validate() {
            if ($scope.cart.length === 0) {
                HelperFactory.show_AlertFactory('Debe ingresar por lo menos un producto al detalle');
                return false;
            }
            // check quantity
            for (var i in $scope.cart) {
                if (Number($scope.cart[i].quantity) == 0 || _.isNull($scope.cart[i].quantity)) {
                    HelperFactory.show_AlertFactory('La cantidad del producto ' + $scope.cart[i].description + ' no puede ser igual a cero o estar vacío.');
                    angular.element(document.querySelector('#quantity' + i)).focus();
                    return false;
                }
            }

            // check price
            for (var i in $scope.cart) {
                if (Number($scope.cart[i].price) == 0 || _.isNull($scope.cart[i].price)) {
                    HelperFactory.show_AlertFactory('El precio del producto ' + $scope.cart[i].description + ' no puede ser igual a cero o estar vacío.');
                    angular.element(document.querySelector('#price' + i)).focus();
                    return false;
                }
            }

            if (_.isNull($scope.client) || _.isUndefined($scope.client)) {
                HelperFactory.show_AlertFactory('Debe seleccionar al cliente');
                angular.element(document.querySelector('#search_client_value')).focus();
                return false;
            };

            if (!_.isNull($scope.client) || !_.isUndefined($scope.client)) {

                if ($scope.typeVoucherSelected.id == VOUCHER.FACTURA) {
                    if ($scope.client_data.typedocument_id == TYPE_DOCUMENT['RUC'].id) {
                        return true;
                    }
                    else {
                        HelperFactory.show_AlertFactory('Para la emisión de facturas electrónicas, el documento del cliente debe ser de tipo RUC.');
                        angular.element(document.querySelector('#search_client_value')).focus();
                        return false;
                    }
                }
            };

            if (_.isUndefined($scope.total_sale) || $scope.total_sale == 0) {
                HelperFactory.show_AlertFactory('El total de la venta no puede ser igual a cero');
                return false;
            };

            return true;
        };

        $scope.cleanSale = function () {
            var options = {
                title: "Cuidado!!",
                message: "Está por cancelar todo el progreso de la venta.",
                cancel: "Minimizar",
                confirm: "Cancelar Venta"
            };
            AlertFactory.confirm(options, function () {
                $state.transitionTo('sales.sale', null, { 'reload': true });
            });
        };


        $scope.click_input_igv = function (msg, $event) {
            var el = event.target;
            el.select();
        };

        $scope.click_input_quantity = function (msg, $event) {
            var el = event.target;
            el.select();
        };

        $scope.click_input_price = function (msg, $event) {
            var el = event.target;
            el.select();
        };

        $scope.click_input_total_received = function (msg, $event) {
            var el = event.target;
            el.select();
        };

        $scope.addClient = function (actionCreate) {
            var obj = { 'id': 0 };

            if (!actionCreate) {
                obj = {
                    'id': 0,
                    entity: 'lol'
                };
            }

            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/sales/client/extends.html',
                controller: 'ExtendClientCtrl',
                size: 'lg',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                if (!_.isUndefined(result)) {
                    var data = result.data;
                    $scope.client_data = data;
                    $scope.client = data.id;
                    $scope.paid.document = data.document;
                    $scope.paid.address = data.address;
                    $timeout(function () {
                        angular.element(document.querySelector('#search_client_value')).val(data.fullname);
                        angular.element(document.querySelector('#search_client_value')).attr('disabled', 'disabled');
                    }, 50);
                }
            });
        };

        $scope.showOrders = function () {
            var obj = {
                'entity': null,
            };
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/sales/order/showorders.html',
                controller: 'ExtendsShowOrdersCtrl',
                size: 'modal-dialog modal-lg',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                if (!_.isUndefined(result)) {
                    $scope.cart = [];
                    var data = result.data;
                    var order = data.order;
                    var products_order = data.detail;

                    $scope.order_code = order.code;
                    $scope.sale.is_order = true;
                    $scope.sale.order_id = order.id;
                    $scope.sale.observation = order.observation;

                    $scope.client = order.client_id;
                    $scope.type_document = order.typeDocument;
                    $scope.paid.document = order.client_document;
                    $scope.paid.address = order.client_address;
                    angular.element(document.querySelector('#search_client_value')).attr('disabled', 'disabled');
                    angular.element(document.querySelector('#search_client_value')).val(order.client_fullname);

                    $.each(products_order, function (i, product) {
                        product.warehouse_id = $scope.warehousesSelected.id;

                        product.is_igv = false;
                        if (Number(product.igv) !== 0) {
                            product.is_igv = true;
                            if ($scope.include_igv) {
                                var igv = ((product.subtotal * $scope.igv) / 100).toFixed(2);
                                var total = Number(product.subtotal) + Number(igv);
                                product.igv = igv;
                                product.total = total;
                                product.is_igv = true;
                            }
                        }

                        $scope.cart.push(product);
                    });

                    $timeout(function () {
                        $.each(products_order, function (i, product) {
                            var index = i;
                            var units = product.unitsmeasure;

                            $("#unitSelected" + index).html('');
                            $.each(units, function (i, item) {
                                $("#unitSelected" + index).append($('<option>', {
                                    value: item.id,
                                    text: item.description + ' (' + item.equivalence + ')'
                                }));
                            });
                            $("#unitSelected" + index).val(product.unitmeasure_id);
                            var pos = $scope.cart.indexOf(product);
                            $scope.cart[pos].unit_id = product.unitmeasure_id;
                        });

                        sum_items();

                        $scope.changeToPaid();

                    }, 100);
                }
            });
        };

        $scope.showBookings = function () {
            var obj = {
                'entity': null,
            };
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/hotel/bookings/modalbookings.html',
                controller: 'ExtendsModalBookingsCtrl',
                size: 'modal-dialog modal-lg',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                if (!_.isUndefined(result)) {
                    console.log(result);
                    $scope.client = CLIENT.DEFAULT;
                    $scope.book_hotel = result;
                }
            });
        };

        $scope.removeBookHotel = function () {
            $scope.book_hotel = null;
        }

        $scope.addAccountBank = function (actionCreate) {
            var obj = { 'id': 0 };
            if (!actionCreate) {
                obj = {
                    'id': 0,
                    entity: null
                };
            }
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/finance/accountbank/extends.html',
                controller: 'ExtendAccountBankCtrl',
                size: 'md',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                if (!_.isUndefined(result)) {
                    var data = result.data;
                    $scope.bankaccounts.push(data);
                    $scope.bankAccountSelected = data;
                    $scope.bankaccounts_exists = true;
                }
            });
        };

        $scope.informationDetail = function (product) {
            RESTService.get('product/information/detail', product.id, function (response) {
                var obj = { 'data': response.data };
                $uibModal.open({
                    animation: true,
                    templateUrl: '../../templates/catalog/product/informationdetail.html',
                    controller: 'ExtendsProductInformationDetailCtrl',
                    size: 'modal-dialog modal-dialog-centered',
                    backdrop: 'static',
                    appendTo: angular.element(document.querySelector('#wrapper')),
                    resolve: {
                        PARAM: function () {
                            return obj;
                        }
                    }
                });
            });
        };
    }
})();

