(function () {
    'use strict';

    angular.module('sys.app.sale', [
        'sys.app.sale.new',
        'sys.app.sale.detail'
    ]);

    angular.module('sys.app.sale').config(Config);

    //region INJECT AND CONFIG
    Config.$inject = ['$stateProvider', '$urlRouterProvider'];

    function Config($stateProvider, $urlRouterProvider) {

        $stateProvider

            .state('sales.sale.new', {
                url: '/nuevo',
                templateUrl: '../../templates/sales/sale/new.html',
                controller: 'NewSaleCtrl',
                cache:false,
                params: {
                    entity: null
                },
                title:'Crear venta',
                module:"sale"
            })
            // editar producto
            .state('sales.sale.edit', {
                url: '/editar',
                templateUrl: '../../templates/sales/sale/new.html',
                controller: 'NewSaleCtrl',
                cache:false,
                params: {
                    entity: null
                },
                title:'Editar venta',
                module:"sale"
            })

            .state('sales.sale.detail', {
                url: '/detalle',
                templateUrl: '../../templates/sales/sale/detail.html',
                controller: 'DetailSaleCtrl',
                params: {
                    entity: null
                },
                title:'Detalle venta',
                module:"sale"
            })
        ;

        $urlRouterProvider.otherwise('/ventas');
    }

    //endregion
})();
