(function () {
    'use strict';
    angular.module('sys.app.sale')
        .controller('SaleCtrl', SaleCtrl);

    SaleCtrl.$inject = ['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory','$timeout', 'notifyAlert', 'SEARCH', '$uibModal'];

    function SaleCtrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $timeout, notifyAlert, SEARCH, $uibModal) {

        $scope.entity = {};
        $scope.text= null;
        $scope.currentPage = 1;
        var object = "";

        var start_range = moment().startOf('month');
        var end_range = moment().endOf('month');

        $scope.start_range = start_range;
        $scope.end_range = end_range;

        init();

        sync();

        function init() {
            object = "search=" + $scope.text + '&page=' + $scope.currentPage +
                "&start_range=" + $scope.start_range.format('YYYY-MM-DD') + '&end_range=' + $scope.end_range.format('YYYY-MM-DD');

            RESTService.all('sales/list', object, function (response) {
                $scope.allData = response.results;
                $scope.totalItems = response.total;
                $scope.itemsPerPage = response.paginate_by;
                

            }, function (error) {
                console.log('ERROR');
                return false;
            });
        }

        function sync() {
            $timeout(function () {
                $('#date_range').daterangepicker({
                        locale: {
                            format: 'MMM D, YYYY'
                        },
                        startDate: $scope.start_range,
                        endDate: $scope.end_range,
                        showDropdowns: true,
                    },
                    function (start, end, label) {
                        $scope.start_range = start;
                        $scope.end_range = end;
                        init();
                    }
                );
            }, 50);
        };


        $scope.searchAction = function (text) {
            $scope.text = text;
            $scope.currentPage = 1;
            if (text.length >= SEARCH.MIN_LETTERS || text.length == 0) {
                delete $scope.allData;
                init();
            }
        };

        $scope.refresh = function () {
            delete $scope.allData;
            $state.transitionTo('sales.sale', {entity: null}, {'reload': true});
        };

        $scope.export = function () {
            var obj = {
                'start_range': $scope.start_range,
                'end_range': $scope.end_range,
            };

            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/sales/sale/export.html',
                controller: 'ExportSaleCtrl',
                size: 'modal-dialog',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                init();
            });
        };

        $scope.new = function () {
            var source = {'sale': {'id':0 }};

            $state.transitionTo('sales.sale.new', {entity: source}, {
                'reload': 'sales.sale.new',
                'cache': false
            });
            delete $scope.allData;
        };

        $scope.edit = function (source) {
            delete $scope.allData;
            RESTService.get('sales/edit', source.id, function (response) {
                $state.transitionTo("sales.sale.edit", {
                    'id': source.id,
                    entity: response.data
                }, {'reload': "sales.sale.edit", 'cache': false});
            }, function (error) {
                console.log('ERROR');
                return false;
            });

        };

        $scope.detail = function (source) {
            delete $scope.allData;
            RESTService.get('sales/detail', source.id, function (response) {
                $state.transitionTo("sales.sale.detail", {
                    'id': source.id,
                    entity: response.data
                }, {'reload': "sales.sale.detail", 'cache': false});
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };

        $scope.pageChanged = function(page) {
            $scope.currentPage = page;
            delete $scope.allData;
            init();
        };

        $scope.delete = function (item) {
            var options = {
                title: "Cuidado!!",
                message: "El registro ' "+item.description+" ' será eliminado",
                cancel: "Cancelar",
                confirm: "Eliminar"
            };
            AlertFactory.confirm(options, function () {
                RESTService.deleted('sales/delete', item.id, function (response) {
                    notifyAlert.success("El item se ha eliminado con éxito!!");
                    var obj = {"text": $scope.text};
                    $state.transitionTo('sales.sale', {entity: obj}, {'reload': true});
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });

            })

        };

    }
})();



