
(function () {
    'use strict';

    angular.module('sys.app.sales').config(Config);

    Config.$inject = ['$stateProvider', '$urlRouterProvider'];


    function Config($stateProvider, $urlRouterProvider) {
        $stateProvider

            .state('sales.clients', {
                url: '/clientes',
                templateUrl: '../../templates/sales/client.html',
                controller: 'ClientCtrl',
                params: {
                    entity: null
                },
                title: "Clientes",
                module:"clients",
            })

            .state('sales.sale', {
                url: '/ventas',
                templateUrl: '../../templates/sales/sale.html',
                controller: 'SaleCtrl',
                params: {
                    entity: null
                },
                title: "Ventas",
                module:"sale",
            })

            .state('sales.orders', {
                url: '/pedidos',
                templateUrl: '../../templates/sales/order.html',
                controller: 'OrderCtrl',
                params: {
                    entity: null
                },
                title: "Pedidos",
                module:"orders",
            })

            .state('sales.proformas', {
                url: '/proformas',
                templateUrl: '../../templates/sales/proformas.html',
                controller: 'ProformaCtrl',
                params: {
                    entity: null
                },
                title: "Proformas",
                module:"proformas",
            })

            .state('sales.eatery', {
                url: '/comandas',
                templateUrl: '../../templates/sales/eatery.html',
                controller: 'EateryCtrl',
                params: {
                    entity: null
                },
                title: "Comandas",
                module:"eatery",
            })

            .state('sales.saleservices', {
                url: '/gestion_servicios',
                templateUrl: '../../templates/sales/saleservices.html',
                controller: 'SaleServicesCtrl',
                params: {
                    entity: null
                },
                title: "Gestión servicios",
                module:"saleservices",
            })

        ;

        $urlRouterProvider.otherwise('/clientes');
    }

})();




