(function () {
    'use strict';
    angular.module('sys.app.saleservices')
        .controller('SaleServicesCtrl', SaleServicesCtrl)
        // .controller('ArrivalboardCtrl', ArrivalboardCtrl)
    ;

    SaleServicesCtrl.$inject = ['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory', '$http', '$timeout', 'notifyAlert', 'SEARCH', 'loadingAlert', '$uibModal', 'ORDER'];

    // ArrivalboardCtrl.$inject = ['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory', '$timeout', 'notifyAlert', 'SEARCH', '$uibModal', 'EventsFactory'];

    function SaleServicesCtrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $http, $timeout, notifyAlert, SEARCH, loadingAlert, $uibModal, ORDER) {

        $scope.entity = {};
        $scope.text= null;
        $scope.currentPage = 1;

        $scope.status = ORDER.STATUS;
        $scope.statusSelected = ORDER.STATUS[0];

        var object = "";

        init();

        function init() {
            object = "search=" + $scope.text + '&page=' + $scope.currentPage+'&statusDelivered='+$scope.statusSelected.id;
            RESTService.all('order/list', object + '&export=0', function (response) {
                $scope.allData = response.results;
                $scope.totalItems = response.total;
                $scope.itemsPerPage = response.paginate_by;
            }, function (error) {
                console.log('ERROR');
                return false;
            });

        }

        $scope.edit = function (source) {
            delete $scope.allData;
            RESTService.get('order/edit', source.id, function (response) {
                $state.transitionTo("sales.orders.edit", {
                    'id': source.id,
                    entity: response.data
                }, {'reload': "sales.orders.edit", 'cache': false});
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };


        $scope.detail = function (source) {
            delete $scope.allData;
            RESTService.get('order/detail', source.id, function (response) {
                $state.transitionTo("sales.orders.detail", {
                    'id': source.id,
                    entity: response.data
                }, {'reload': "sales.orders.detail", 'cache': false});
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };


        $scope.searchAction = function (text) {
            $scope.text = text;
            $scope.currentPage = 1;
            if (text.length >= SEARCH.MIN_LETTERS || text.length == 0) {
                delete $scope.allData;
                init();
            }
        };

        $scope.pageChanged = function(page) {
            $scope.currentPage = page;
            delete $scope.allData;
            init();
        };

        $scope.selectedStatus = function (item) {
            $scope.statusSelected = item;
            init();
        };


        $scope.new = function () {
            var source = {'order': {'id':0 }};
            $state.transitionTo('sales.saleservices.new', {entity: source}, {
                'reload': 'sales.saleservices.new',
                'cache': false
            });
            delete $scope.allData;
        };

        $scope.refresh = function () {
            delete $scope.allData;
            $state.transitionTo('sales.orders', {entity: null}, {'reload': true});
        };

        $scope.delete = function (item) {
            var options = {
                title: "Cuidado!!",
                message: "El pedido ' "+item.code+" ' será eliminado",
                cancel: "Cancelar",
                confirm: "Eliminar"
            };
            AlertFactory.confirm(options, function () {
                RESTService.deleted('order/delete', item.id, function (response) {
                    notifyAlert.success("El item se ha eliminado con éxito!!");
                    var obj = {"text": $scope.text};
                    $state.transitionTo('sales.orders', {entity: obj}, {'reload': true});
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });

            })
        };


        $scope.openReport = function () {
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/helpers/order/modal_report_order.html',
                controller: 'ModalReportOrderCtrl',
                size: 'sm',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    VALS: function () {
                        var values = true;
                        return values;
                    }
                }
            }).result.then(function (result) {
                // console.log(result)
                console.log("test close modal")
            });

        };

        $scope.associateSale = function (sale_id) {
            RESTService.get('sales/detail', sale_id, function (response) {
                var obj = {'data': response.data};
                $uibModal.open({
                    animation: true,
                    templateUrl: '../../templates/sales/sale/modaldetail.html',
                    controller: 'ModalDetailSaleCtrl',
                    size: 'modal-dialog modal-lg',
                    backdrop: 'static',
                    appendTo: angular.element(document.querySelector('#wrapper')),
                    resolve: {
                        PARAM: function () {
                            return obj;
                        }
                    }
                });
            });
        };
    }

    // function ArrivalboardCtrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $timeout, notifyAlert, SEARCH, $uibModal, EventsFactory) {
    //     var object = "";
    //
    //     $scope.$on('onArrivalBoard', function (event, product) {
    //         delete $scope.allData;
    //         parent();
    //     });
    //
    //     function parent() {
    //         $scope.entity = {};
    //         $scope.text = null;
    //         $scope.currentPage = 1;
    //         var start_range = moment().startOf('month');
    //         var end_range = moment().endOf('month');
    //
    //         $scope.start_range = start_range;
    //         $scope.end_range = end_range;
    //
    //         $scope.page = 1;
    //         init();
    //         sync();
    //     }
    //
    //     function init() {
    //         object = "search=" + $scope.text + '&page=' + $scope.currentPage +
    //             "&start_range=" + $scope.start_range.format('YYYY-MM-DD') + '&end_range=' + $scope.end_range.format('YYYY-MM-DD');
    //
    //         RESTService.all('bookings/arrivals', object, function (response) {
    //             $scope.allData = response.results;
    //             $scope.totalItems = response.total;
    //             $scope.itemsPerPage = response.paginate_by;
    //         }, function (error) {
    //             console.log('ERROR');
    //             return false;
    //         });
    //     };
    //
    //     function sync() {
    //         $timeout(function () {
    //             $('#date_range').daterangepicker({
    //                     locale: {
    //                         format: 'MMM D, YYYY'
    //                     },
    //                     startDate: $scope.start_range,
    //                     endDate: $scope.end_range,
    //                     showDropdowns: true,
    //                 },
    //                 function (start, end, label) {
    //                     $scope.start_range = start;
    //                     $scope.end_range = end;
    //                     init();
    //                 }
    //             );
    //         }, 50);
    //     };
    //
    //     $scope.searchAction = function (text) {
    //         $scope.text = text;
    //         $scope.currentPage = 1;
    //         if (text.length >= SEARCH.MIN_LETTERS || text.length == 0) {
    //             delete $scope.allData;
    //             init();
    //         }
    //     };
    //
    //     $scope.refresh = function () {
    //         delete $scope.allData;
    //         parent();
    //     };
    // };

})();

