(function () {

    'use strict';
    angular.module('sys.app.users.new')
        .controller('NewUsersCtrl', NewUsersCtrl);

    NewUsersCtrl.$inject = ['$scope', '$stateParams', '$state', 'RESTService', 'EventsFactory', '$http', 'notifyAlert', '$rootScope', '_', 'HelperFactory', 'ConfigPagination', '$timeout'];

    function NewUsersCtrl($scope, $stateParams, $state, RESTService, EventsFactory, $http, notifyAlert, $rootScope, _, HelperFactory, ConfigPagination, $timeout) {

        $scope.change_password = true;
        $scope.employee = null;

        try {

            if (!_.isNull($stateParams.entity.id)) {
                $scope.entity = $stateParams.entity;
                $scope.user = $stateParams.entity;

                if ($scope.user.id != 0) {//$scope.unitElements
                    $scope.change_password = false;
                    $scope.txt_title = 'Editar'
                    $scope.user.name = $scope.entity.name;
                    $scope.user.username = $scope.entity.username;
                    $scope.user.surname = $scope.entity.surname;
                    $scope.user.document = $scope.entity.document;
                    $scope.user.telephone = $scope.entity.telephone;
                    $scope.user.email = $scope.entity.email;
                    $scope.user.address = $scope.entity.address;

                    employeeSelected($scope.user);
                }
                else
                {
                    $scope.txt_title = 'Registrar'
                    $scope.user = {
                        'name': null,
                        'username': null,
                        'surname': null,
                        'document': null,
                        'telephone': null,
                        'email': null,
                        'password': null,
                        'address':null
                    };
                }
            }
        }
        catch (e) {
            $state.transitionTo('security.users', null, {'reload': true});
            console.log(e);
            return false;
        }

        init();

        function init() {
            RESTService.all('user/list_profile', null, function (response) {
                $scope.profiles = response.results;
                $scope.profileSelected = response.results[0];
                profileSelected($scope.user.profile_id);
            });

            $timeout(function () {
                angular.element(document.querySelector('#search_employee_value')).focus();
            }, 100);
        };


        function employeeSelected(data) {
            if(data.employee_id != null){
                $scope.employee = data.employee_id;
                $timeout(function () {
                    angular.element(document.querySelector('#search_employee_value')).attr('disabled', 'disabled');
                    angular.element(document.querySelector('#search_employee_value')).val(data.employee_fullname);
                }, 100);
            };
        };

        function profileSelected(id) {
            if(!_.isUndefined(id)){
                $scope.profileSelected = ConfigPagination.searchById(id,$scope.profiles);
            }
        }

        $scope.activeChangePassword = function (item) {
            $scope.change_password = item;
            if($scope.change_password == true){
                $timeout(function () {
                    angular.element(document.querySelector('#user_password')).focus();
                }, 50);
            }
        };

        $scope.selectedEmployee = function (response) {
            if (!_.isUndefined(response)) {
                var data = response.originalObject;
                $scope.employee = data.id;
                $scope.user.email = data.email;
                angular.element(document.querySelector('#search_employee_value')).attr('disabled', 'disabled');
                angular.element(document.querySelector('#user_username')).focus();
            }
        };

        $scope.removeEmployee = function () {
            angular.element(document.querySelector('#search_employee_value')).removeAttr('disabled').focus();
            $scope.employee = null;
            $scope.$broadcast('angucomplete-alt:clearInput', 'search_employee');
        };

        $scope.save = function () {
            if (validate()) {
                $scope.user['employee_id'] = $scope.employee;
                $scope.user['profile_id'] = $scope.profileSelected.id;
                RESTService.save('user/save', $scope.user, function (result) {
                    notifyAlert.success("Registro realizado con éxito!!");
                    $state.transitionTo('security.users', null, {'reload': true});
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });
            }
        };


        $scope.edit = function () {
            if (validate()) {

                $scope.user['employee_id'] = $scope.employee;
                $scope.user['profile_id'] = $scope.profileSelected.id;
                $scope.user['change_password'] = $scope.change_password;

                RESTService.updated('user/update', $scope.user.id, $scope.user, function (result) {
                    notifyAlert.success("Registro actualizado con éxito!!");
                    $state.transitionTo('security.users', null, {'reload': true});
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });
            }
        }

        function validate() {

            if (_.isNull($scope.profileSelected) || _.isEmpty($scope.profileSelected)) {
                HelperFactory.show_AlertFactory('Debe ingresar el perfil del usuario');
                angular.element(document.querySelector('#profileSelected')).focus();
                return false;
            }

            if(_.isNull($scope.employee)){
                HelperFactory.show_AlertFactory('Debe asociar un empleado al usuario');
                angular.element(document.querySelector('#search_employee_value')).focus();
                return false;
            }

            if (_.isNull($scope.user.username) || _.isEmpty($scope.user.username)) {
                HelperFactory.show_AlertFactory('Debe ingresar un identificador de nombre de usuario');
                angular.element(document.querySelector('#user_username')).focus();
                return false;
            }

            if (_.isNull($scope.user.email) || _.isEmpty($scope.user.email)) {
                HelperFactory.show_AlertFactory('Debe ingresar el correo del usuario');
                angular.element(document.querySelector('#user_email')).focus();
                return false;
            }

            if($scope.change_password == true){
                if (_.isNull($scope.user.password) || _.isEmpty($scope.user.password)) {
                    HelperFactory.show_AlertFactory('Debe ingresar la contraseña del usuario');
                    angular.element(document.querySelector('#user_password')).focus();
                    return false;
                }
            }

            return true;
        };


        $scope.close = function () {
            $state.transitionTo('security.users', null, {'reload': true});
        };

    }

})();

