(function () {
    'use strict';
    angular.module('sys.app.users')
        .controller('UsersCtrl', UsersCtrl);

    UsersCtrl.$inject = ['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory', '$http', '$timeout', 'notifyAlert', 'SEARCH', 'USER'];

    function UsersCtrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $http, $timeout, notifyAlert, SEARCH, USER) {

        $scope.entity = {};
        $scope.text = null;
        $scope.currentPage = 1;
        var object = "";

        $scope.status = USER.STATUS;
        $scope.statusSelected = USER.STATUS[0];

        var default_profile = {id: null, description: 'TODOS', value: null};
        $scope.profileSelected = default_profile;

        init();
        sync();

        function init() {
            object = "search=" + $scope.text + '&page=' + $scope.currentPage + '&status=' + $scope.statusSelected.id
                + '&profile=' + $scope.profileSelected.id;

            RESTService.all('user/list', object + '&export=0', function (response) {
                $scope.allData = response.results;
                $scope.totalItems = response.total;
                $scope.itemsPerPage = response.paginate_by;
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };

        function sync() {
            RESTService.all('user/list_profile', null, function (response) {
                var last = response.results.length;
                $scope.profiles = response.results;
                response.results[last] = {id: null, description: 'TODOS', value: null};
                $scope.profileSelected = response.results[last];
            });
        };

        $scope.changeProfile = function (item) {
            $scope.profileSelected = item;
            $("#searchInput").val('');
            $scope.text = null;
            init();
        };

        $scope.changeStatus = function (item) {
            $scope.statusSelected = item;
            $("#searchInput").val('');
            $scope.text = null;
            init();
        };

        $scope.searchAction = function (text) {
            $scope.text = text;
            $scope.currentPage = 1;
            if (text.length >= SEARCH.MIN_LETTERS || text.length == 0) {
                delete $scope.allData;
                init();
            }
        };

        $scope.refresh = function () {
            delete $scope.allData;
            $state.transitionTo('security.users', {entity: null}, {'reload': true});
        };

        // functions new product
        $scope.new = function () {
            var source = {'id': 0};
            $state.transitionTo('security.users.new', {entity: source}, {
                'reload': 'security.users.new',
                'cache': false
            });
            delete $scope.allData;
        };

        $scope.edit = function (source) {
            delete $scope.allData;
            RESTService.get('user/edit', source.id, function (response) {
                $state.transitionTo("security.users.edit",
                    {
                        'id': source.id,
                        entity: response.data
                    }, {'reload': "security.users.edit", 'cache': false});
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };

        $scope.pageChanged = function (page) {
            $scope.currentPage = page;
            delete $scope.allData;
            init();
        };

        $scope.delete = function (item) {
            var options = {
                title: "Cuidado!!",
                message: "El usuario ' " + item.username + " ' será dado de baja",
                cancel: "Cancelar",
                confirm: "Dar de baja"
            };
            AlertFactory.confirm(options, function () {
                RESTService.deleted('user/delete', item.id, function (response) {
                    notifyAlert.success("El usuario ha sido dado de baja!!");
                    var obj = {"text": $scope.text};
                    $state.transitionTo('security.users', {entity: obj}, {'reload': true});
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });

            })
        };

        $scope.activedUser = function (user) {
            var options = {
                title: "¡Atención!",
                message: "¿Esta seguro(a) de activar al usuario " + user.username + " ?",
                cancel: "Cancelar",
                confirm: "Activar usuario"
            };
            AlertFactory.confirmWarning(options, function () {
                RESTService.updated('user/activated', user.id, user, function (result) {
                    notifyAlert.success("Usuario activado!!");
                    init();
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });

            });
        };

        $scope.assignPermissions = function (user_id) {
            console.log(user_id);
            RESTService.get('user/edit', source.id, function (response) {
                $state.transitionTo("security.users.permissions",
                    {
                        'id': source.id,
                        entity: response.data
                    }, {'reload': "security.users.permissions", 'cache': false});
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };
    }
})();




