(function () {
    'use strict';
    angular.module('sys.app.settinggeneral')
        .controller('SettingGeneralCtrl', SettingGeneralCtrl);

    SettingGeneralCtrl.$inject = ['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory','$timeout', 'notifyAlert', 'SEARCH', 'SETTING'];

    function SettingGeneralCtrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $timeout, notifyAlert, SEARCH, SETTING) {

        $scope.prints = SETTING.PRINT;

        init();

        function init() {
            $scope.printBoleta = $scope.prints[0];
            $scope.printFactura = $scope.prints[0];

            RESTService.all('branch/setting/general', null, function (response) {
                $scope.general = response.general;
                $scope.is_barcode = response.is_barcode;
                $scope.is_default_client = $scope.general.is_default_client;

                boletaSelected($scope.general.print_boleta);
                facturaSelected($scope.general.print_factura);
                refresh();
            });
        }

        function refresh (){
            RESTService.all('config/typevoucher/sale', null, function (response) {
                $scope.typevouchers = response.results;
                $scope.typeVoucherSelected = response.results[0];
                if($scope.general.typevoucher_default != null){
                    $timeout(function () {
                        typeVoucherDefaultSelected($scope.general.typevoucher_default);
                    }, 50);
                }
            });
        }

        function boletaSelected(id) {
            if(!_.isUndefined(id)){
                $scope.printBoleta = ConfigPagination.searchById(id,$scope.prints);
            }
        };

        function typeVoucherDefaultSelected(id) {
            if(!_.isUndefined(id)){
                $scope.typeVoucherSelected = ConfigPagination.searchById(id,$scope.typevouchers);
            }
        };

        function facturaSelected(id) {
            if(!_.isUndefined(id)){
                $scope.printFactura = ConfigPagination.searchById(id,$scope.prints);
            }
        };

        $scope.changePrintBoleta = function (item) {
            $scope.printBoleta = item;
        };

        $scope.changePrintFactura = function (item) {
            $scope.printFactura = item;
        };

        $scope.changeIsBarcode = function (is_barcode) {
            $scope.is_barcode = is_barcode;
        }

        $scope.changeClientDefault = function (is_default_client) {
            $scope.is_default_client = is_default_client;
        }

        $scope.changeTypeVoucher = function (type_voucher) {
            $scope.typeVoucherSelected = type_voucher;
        }

        $scope.save = function () {
            if(validate()){
                $scope.general.print_boleta = $scope.printBoleta.id;
                $scope.general.print_factura = $scope.printFactura.id;
                $scope.general.is_default_client = $scope.is_default_client;
                $scope.general.typevoucher_default = $scope.typeVoucherSelected.id;

                var data = {
                    'general':$scope.general,
                    'is_barcode':$scope.is_barcode,
                }

                RESTService.save('branch/setting/general/save', data, function (result) {
                    notifyAlert.success("Cambios realizados con éxito!!");
                    $state.transitionTo('setting.settinggeneral', null, {'reload': true});

                }, function (error) {
                    console.log('ERROR');
                    return false;
                });
            }
        };

        function validate() {
            return true;
        };

        $scope.refresh = function (){
            init();
        }

    }

})();
