(function () {

    'use strict';
    angular.module('sys.app.poll.file')
        .controller('FilePollCtrl', FilePollCtrl);

    FilePollCtrl.$inject = ['$scope', '$stateParams', '$state', 'RESTService','notifyAlert', '$rootScope', '_', '$uibModal'];

    function FilePollCtrl($scope, $stateParams, $state, RESTService, notifyAlert, $rootScope, _, $uibModal) {

        try {

            $scope.check_survey = $stateParams.entity.survey;

            if (!_.isNull($scope.check_survey.id)) {
                $scope.entity = $stateParams.entity;
                $scope.survey = $stateParams.entity.survey;
                $scope.responses = $stateParams.entity.responses;
            }
        }
        catch (e) {
            $state.transitionTo('survey.poll', null, {'reload': true});
            console.log(e);
            return false;
        }


        $scope.addPoll = function () {
            var obj = {'id': $scope.survey.id};

            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/survey/poll/modal_new_poll.html',
                controller: 'ExtendPollCtrl',
                size: 'lg',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
            });
        }

        $scope.close = function () {
            $state.transitionTo('survey.poll', null, {'reload': true});
        }

    }
})();

