(function () {
    'use strict';

    angular.module('sys.utils.utils')
        .controller('ExtendPollCtrl', ExtendPollCtrl);

    ExtendPollCtrl.$inject = ['$scope', '$state', 'RESTService', 'notifyAlert', '_', 'HelperFactory', 'ConfigPagination', '$uibModalInstance', '$timeout', 'PARAM',];

    function ExtendPollCtrl($scope, $state, RESTService, notifyAlert, _, HelperFactory, ConfigPagination, $uibModalInstance, $timeout, PARAM) {

        $scope.get_param = PARAM;
        $scope.client = null;
        $scope.user = null;
        $scope.poll = {
            'survey_id': $scope.get_param.id,
            'date_response': moment().format('YYYY-MM-DD'),
        };

        $scope.questions = {
            'question1':{
                'response':null,
                'response_text':null,
                'is_text_rquired':false
            },
            'question2':{
                'response':null,
                'response_text':null,
                'is_text_rquired':true
            },
            'question3':{
                'response':null,
                'response_text':null,
                'is_text_rquired':true
            }
        };

        init()

        function init() {

            $timeout(function () {

                $('#date_response').daterangepicker({
                    locale: {
                        format: 'YYYY-MM-DD'
                    },
                    singleDatePicker: true,
                    showDropdowns: true,
                    minDate: new Date()
                });

                angular.element(document.querySelector('#search_user_value')).focus();

            }, 100);
        }


        $scope.selectedClient = function (response) {
            if (!_.isUndefined(response)) {
                var data = response.originalObject;
                $scope.client = data.id;
                angular.element(document.querySelector('#search_client_value')).attr('disabled', 'disabled');
            }
        }

        $scope.removeClient = function () {
            angular.element(document.querySelector('#search_client_value')).removeAttr('disabled').focus();
            $scope.client = null;
            $scope.$broadcast('angucomplete-alt:clearInput', 'search_client');
        }

        $scope.selectedUser = function (response) {
            if (!_.isUndefined(response)) {
                var data = response.originalObject;
                $scope.user = data.id;
                angular.element(document.querySelector('#search_user_value')).attr('disabled', 'disabled');
            }
        }

        $scope.removeUser = function () {
            angular.element(document.querySelector('#search_user_value')).removeAttr('disabled').focus();
            $scope.user = null;
            $scope.$broadcast('angucomplete-alt:clearInput', 'search_user');
        }

        $scope.save = function () {

            if (validate()) {

                $scope.poll['client_id'] = $scope.client;
                $scope.poll['employed_id'] = $scope.user;
                var data = {};
                data.poll = $scope.poll;
                data.questions = $scope.questions;
                RESTService.save('poll/save', data, function (result) {
                    notifyAlert.success("Registro realizado con éxito!!");
                    RESTService.get('survey/file', $scope.poll.survey_id, function (response) {
                        $state.transitionTo("survey.poll.file", {
                            'id': $scope.poll.survey_id,
                            entity: response.data
                        }, {'reload': "survey.poll.file", 'cache': false});

                        $uibModalInstance.close(result);
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });
            }
        };

        function validate() {

            if (_.isNull($scope.user) || _.isUndefined($scope.user)) {
                HelperFactory.show_AlertFactory('Debe seleccionar un usuario vendedor');
                angular.element(document.querySelector('#search_user_value')).focus();
                return false;
            }

            if (_.isNull($scope.client) || _.isUndefined($scope.client)) {
                HelperFactory.show_AlertFactory('Debe seleccionar al cliente');
                angular.element(document.querySelector('#search_client_value')).focus();
                return false;
            }

            var question = 1;
            for (var i in $scope.questions) {

                if($scope.questions[i].is_text_rquired){
                    if($scope.questions[i].response_text == '' || _.isNull($scope.questions[i].response_text)){
                        HelperFactory.show_AlertFactory('Debe seleccionar un valor para la pregunta N° '+question);
                        angular.element(document.querySelector('#'+i+'_response_text')).focus();
                        return false;
                    }
                }else{
                    if($scope.questions[i].response == '' || _.isNull($scope.questions[i].response)){
                        HelperFactory.show_AlertFactory('Debe seleccionar un valor para la pregunta N° '+question);
                        angular.element(document.querySelector('#'+i+'_response')).focus();
                        return false;
                    }
                }

                question = question + 1;
            }

            return true;
        };

        $scope.closeModal = function () {
            $uibModalInstance.dismiss('cancel');
        };
    }
})();


