(function () {
    'use strict';
    angular.module('sys.app.poll')
        .controller('PollCtrl', PollCtrl);

    PollCtrl.$inject = ['$scope', '$state', 'RESTService','SEARCH'];

    function PollCtrl($scope, $state, RESTService,SEARCH){

        $scope.entity = {};
        $scope.text= null;
        $scope.currentPage = 1;
        var object = "";

        init();

        function init() {
            object = "search=" + $scope.text + '&page=' + $scope.currentPage;
            RESTService.all('survey/list', object + '&export=0', function (response) {
                $scope.allData = response.results;
                $scope.totalItems = response.total;
                $scope.itemsPerPage = response.paginate_by;

            }, function (error) {
                console.log('ERROR');
                return false;
            });

        }

        $scope.searchAction = function (text) {
            $scope.text = text;
            // if (text.length >= SALE.MIN_LETTERS || text.length == 0) {
            $scope.currentPage = 1;
            if (text.length >= SEARCH.MIN_LETTERS || text.length == 0) {
                delete $scope.allData;
                init();
            }
        };

        $scope.refresh = function () {
            delete $scope.allData;
            $state.transitionTo('inventory.products', {entity: null}, {'reload': true});
        };

        $scope.pageChanged = function(page) {
            $scope.currentPage = page;
            delete $scope.allData;
            // console.log('Page changed to: ' + $scope.currentPage);
            init();
        };

        $scope.file = function (source) {

            delete $scope.allData;
            RESTService.get('survey/file', source.id, function (response) {
                $state.transitionTo("survey.poll.file", {
                    'id': source.id,
                    entity: response.data
                }, {'reload': "survey.poll.file", 'cache': false});
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };
    }

})();