(function () {
    'use strict';

    angular.module('sys.app.entry', [
        'sys.app.entry.new',
        'sys.app.entry.detail',
    ]);

    angular.module('sys.app.entry').config(Config);

    Config.$inject = ['$stateProvider', '$urlRouterProvider'];

    function Config($stateProvider, $urlRouterProvider) {
        $stateProvider
            .state('warehouse.entry.new', {
                url: '/nuevo',
                templateUrl: '../../templates/warehouse/entry/new.html',
                controller: 'NewEntryCtrl',
                cache: false,
                params: {
                    entity: null
                },
                title: 'Crear entrada',
                module: "entry"
            })

            .state('warehouse.entry.edit', {
                url: '/editar',
                templateUrl: '../../templates/warehouse/entry/new.html',
                controller: 'NewEntryCtrl',
                cache: false,
                params: {
                    entity: null
                },
                title: 'Editar entrada',
                module: "entry"
            })

            .state('warehouse.entry.detail', {
                url: '/detalle',
                templateUrl: '../../templates/warehouse/entry/detail.html',
                controller: 'DetailEntryCtrl',
                params: {
                    entity: null
                },
                title:'Detalle movimiento',
                module:"entry"
            })

        ;

        $urlRouterProvider.otherwise('/productos');

    }

    //endregion
})();