(function () {

    'use strict';
    angular.module('sys.app.entry.new')
        .controller('NewEntryCtrl', NewEntryCtrl);

    NewEntryCtrl.$inject = ['$scope', '$stateParams', '$state', 'RESTService', 'notifyAlert', '$rootScope', '_', 'HelperFactory', '$timeout', '$uibModal'];

    function NewEntryCtrl($scope, $stateParams, $state, RESTService, notifyAlert, $rootScope, _, HelperFactory, $timeout, $uibModal) {
        try {
            if (!_.isNull($stateParams.entity.id)) {
                $scope.entity = $stateParams.entity;
                $scope.entry = $stateParams.entity;
                if ($scope.entry.id != 0) {//$scope.unitElements
                    $scope.txt_title = 'Editar'
                    $scope.action = 'edit';
                    $scope.entry.reason = $scope.entity.reason;
                }
                else {
                    $scope.txt_title = 'Registrar';
                    $scope.action = 'create';

                    $scope.products = [];

                    $scope.entry = {
                        'reason': null,
                        'date_movement': moment().format('YYYY-MM-DD'),
                    };
                }
            }
        }
        catch (e) {
            $state.transitionTo('warehouse.entry', null, {'reload': true});
            console.log(e);
            return false;
        }

        init()

        function init() {

            RESTService.all('warehouses/branchoffice', null, function (response) {
                $scope.warehouses = response.results;
                $scope.warehousesSelected = response.results[0];
            });

            RESTService.all('warehouse/concepts/entry', null, function (response) {
                $scope.concepts = response.results;
                var last = $scope.concepts.length;
                $scope.concepts[last] = {id: null, description:'Seleccione motivo', value:null};
                $scope.conceptSelected = response.results[last];
            });


            $timeout(function () {
                $('#date_response').daterangepicker({
                    locale: {
                        format: 'YYYY-MM-DD'
                    },
                    singleDatePicker: true,
                    showDropdowns: true,
                    minDate: new Date()
                });

                $('[data-toggle="tooltip"]').tooltip();

            }, 100);
        }


        $scope.recalculate_quantity = function (count, product, $index) {
            var check_quantity = angular.element(document.querySelector('#quantity' + $index)).val();
            var q_ = check_quantity;

            angular.element(document.querySelector('#quantity' + $index)).val(q_);

            var quantity = angular.element(document.querySelector('#quantity' + $index)).val();

            if (!_.isNaN(quantity * 1)) {
                var index = $scope.products.indexOf(product);
                var subtotal = (Number(quantity) * Number($scope.products[index].price))
                $scope.products[index].quantity = quantity;
                $scope.products[index].subtotal = subtotal;
            }
        };

        $scope.recalculate_price = function (price, product, $index) {
            var check_price = angular.element(document.querySelector('#price' + $index)).val();
            var q_ = check_price;

            angular.element(document.querySelector('#price' + $index)).val(q_);

            var price_get = angular.element(document.querySelector('#price' + $index)).val();

            if (!_.isNaN(price_get * 1)) {
                var index = $scope.products.indexOf(product);
                $scope.products[index].subtotal = (Number(product.quantity) * Number(price_get)).toFixed(2);
                $scope.products[index].price = Number(price_get);
            }
        };

        $scope.change_unitmeasure = function (unitSelected, product, $index) {
            var check_unit = angular.element(document.querySelector('#unitSelected' + $index)).val();
            var pos = $scope.products.indexOf(product);
            $scope.products[pos].unit_id = check_unit;
        };

        $scope.change_date_expiration = function (check, product, $index) {
            var pos = $scope.products.indexOf(product);
            $scope.products[pos].date_expiration = null;
            $("#expiration_date"+$index).val('');
            if(check){
                $("#expiration_date"+$index).removeAttr('disabled');
                $scope.products[pos].check_date_expiration = true;
                $timeout(function () {
                    dateExpiration(product);
                }, 100);
            }
            else{
                $("#expiration_date"+$index).attr('disabled', 'disabled');
                $scope.products[pos].check_date_expiration = false;
            }
        }

        $scope.removeItem = function ($event, product, $index) {
            $event.preventDefault();
            var index = $scope.products.indexOf(product);
            $scope.products.splice(index, 1)
            notifyAlert.info("El producto " + product.description + ' ha sido removido del detalle');
        };

        $scope.selectedProduct = function (response) {
            if (!_.isUndefined(response)) {
                var item = response.originalObject;

                var unique = ifExistProduct(item);
                if (unique) {
                    item.quantity = null;
                    item.price = null;
                    item.subtotal = 0;
                    item.unit_id = 0;

                    item.check_date_expiration = false;
                    if(item.is_control_expiration){
                        item.check_date_expiration = true;
                    }

                    $scope.products.push(item);

                    var last = $scope.products.length;
                    $timeout(function () {
                        angular.element(document.querySelector('#quantity' + Number(last - 1))).focus();
                        listUnitMeasureProduct(last, item);

                        // set expiration date
                        dateExpiration(item);

                    }, 50);
                    $scope.$broadcast('angucomplete-alt:clearInput', 'search_product');
                }
                else {
                    notifyAlert.warning('El producto ' + item.description + ' ya se encuentra agregado');
                }
            }
        }

        function dateExpiration(item) {
            var index = $scope.products.indexOf(item);
            $scope.products[index].date_expiration = null;
            $('#expiration_date'+index).daterangepicker({
                singleDatePicker: true,
                autoUpdateInput: false,
                showDropdowns: true,
                minDate: new Date(),
                locale: {
                    format: 'YYYY-MM-DD'
                }
            }, function (chosen_date) {
                $(this.element[0]).val(chosen_date.format('YYYY-MM-DD'));
                var check_index = $scope.products.indexOf(item);
                $scope.products[check_index].date_expiration = chosen_date.format('YYYY-MM-DD');
            });

        };

        function listUnitMeasureProduct(pos, product) {
            var index = pos - 1;
            var units = product.unitsmeasure;

            $("#unitSelected"+index).html('');
            $.each(units, function (i, item) {
                $("#unitSelected"+index).append($('<option>', {
                    value: item.id,
                    text : item.description + ' ('+item.equivalence+')'
                }));
            });

            $("#unitSelected"+index).val(units[0].id);
            // $("#unitSelected"+index).attr('disabled', 'disabled');
            var pos = $scope.products.indexOf(product);
            $scope.products[pos].unit_id = units[0].id;
        }

        function ifExistProduct(obj) {
            var cart = $scope.products;
            var is_unique = true;
            for (var key in cart) {
                if (cart[key].id === Number(obj.id)) {
                    is_unique = false;
                    break;
                }
            }
            return is_unique;
        }

        $scope.click_input_quantity = function (msg, $event) {
            var el = event.target;
            el.select();
        };

        $scope.click_input_price = function (msg, $event) {
            var el = event.target;
            el.select();
        };

        $scope.save = function () {
            if (validate()) {
                var data = {};
                $scope.entry['warehouse_id'] = $scope.warehousesSelected.id;
                $scope.entry['warehouseconcept_id'] = $scope.conceptSelected.id;

                data.entry = $scope.entry;
                data.detail = $scope.products;

                if ($scope.action == 'create') {
                    RESTService.save('entry/save', data, function (result) {
                        notifyAlert.success("Registro realizado con éxito!!");
                        $state.transitionTo('warehouse.entry', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
                else if ($scope.action == 'edit') {
                    RESTService.updated('entry/update', $scope.entry.id, $scope.entry, function (result) {
                        notifyAlert.success("Registro actualizado con éxito!!");
                        $state.transitionTo('warehouse.entry', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
            }
        };


        function validate() {
            if (_.isNull($scope.conceptSelected.id)) {
                HelperFactory.show_AlertFactory('Debe seleccionar un motivo.');
                angular.element(document.querySelector('#conceptSelected')).focus();
                return false;
            }

            if ($scope.products.length === 0) {
                HelperFactory.show_AlertFactory('Debe ingresar por lo menos un producto al detalle');
                return false;
            }

            // check quantity
            for (var i in $scope.products) {
                if(Number($scope.products[i].quantity) == 0 || _.isNull($scope.products[i].quantity)){
                    HelperFactory.show_AlertFactory('La cantidad del producto '+$scope.products[i].description+' no puede ser igual a cero o estar vacío.');
                    angular.element(document.querySelector('#quantity'+i)).focus();
                    return false;
                }
            }

            // check price
            for (var i in $scope.products) {
                if(Number($scope.products[i].price) == 0 || _.isNull($scope.products[i].price)){
                    HelperFactory.show_AlertFactory('El precio de compra del producto '+$scope.products[i].description+' no puede ser igual a cero o estar vacío.');
                    angular.element(document.querySelector('#price'+i)).focus();
                    return false;
                }
            }

            // check date expiration
            for (var i in $scope.products) {
                if($scope.products[i].check_date_expiration == true){
                    if(_.isNull($scope.products[i].date_expiration)){
                        HelperFactory.show_AlertFactory('La fecha de vencimiento del producto '+$scope.products[i].description+' no puede estar vacío.');
                        angular.element(document.querySelector('#expiration_date'+i)).focus();
                        return false;
                    }
                }
            }

            return true;
        };

        $scope.addProduct = function (actionCreate) {
            var obj = {'id': 0};
            if (!actionCreate){
                obj = {
                    'id': 0,
                    entity: null
                };
            }
            $uibModal.open({
                animation: true,
                templateUrl: '../../templates/catalog/product/extends.html',
                controller: 'ExtendCatalogProductCtrl',
                size: 'lg',
                backdrop: 'static',
                appendTo: angular.element(document.querySelector('#wrapper')),
                resolve: {
                    PARAM: function () {
                        return obj;
                    }
                }
            }).result.then(function (result) {
                if (!_.isUndefined(result)) {
                    var response = {};
                    response.originalObject = result.data;
                    $scope.selectedProduct(response);
                }
            });
        };

        $scope.close = function () {
            $state.transitionTo('warehouse.entry', null, {'reload': true});
        };
    }

})();

