(function () {

    'use strict';
    angular.module('sys.app.output.detail')
        .controller('DetailOutputCtrl', DetailOutputCtrl);

    DetailOutputCtrl.$inject = ['$scope', '$stateParams', '$state', 'RESTService', 'EventsFactory', '$http', 'notifyAlert','_', 'HelperFactory', '$timeout', 'ORDER', 'SEARCH', 'AlertFactory', 'ConfigPagination', '$uibModal'];

    function DetailOutputCtrl($scope, $stateParams, $state, RESTService, EventsFactory, $http, notifyAlert,_, HelperFactory, $timeout, ORDER, SEARCH, AlertFactory, ConfigPagination, $uibModal) {

        try {

            $scope.check_movement = $stateParams.entity.movement;

            if (!_.isNull($scope.check_movement.id)) {
                $scope.entity = $stateParams.entity.movement;
                $scope.movement = $stateParams.entity.movement;

                if ($scope.movement.id != 0) {
                    $scope.products = $stateParams.entity.detail;
                    $scope.movement.date_movement = $scope.entity.date_movement;
                    $scope.movement.reason = $scope.entity.reason;
                }
            }
        }
        catch (e) {
            $state.transitionTo('warehouse.output', null, {'reload': true});
            console.log(e);
            return false;
        }


        // $scope.edit = function (source) {
        //     delete $scope.allData;
        //     RESTService.get('order/edit', source.id, function (response) {
        //         $state.transitionTo("sales.orders.edit", {
        //             'id': source.id,
        //             entity: response.data
        //         }, {'reload': "order.orders.edit", 'cache': false});
        //     }, function (error) {
        //         console.log('ERROR');
        //         return false;
        //     });
        // };

        $scope.delete = function (item) {
            var options = {
                title: "Cuidado!!",
                message: "La salida de almacén N° ' "+item.nro_voucher+" ' será eliminado",
                cancel: "Cancelar",
                confirm: "Eliminar"
            };
            AlertFactory.confirm(options, function () {
                RESTService.deleted('output/delete', item.id, function (response) {
                    notifyAlert.success("El item se ha eliminado con éxito!!");
                    var obj = {"text": $scope.text};
                    $state.transitionTo('warehouse.output', {entity: obj}, {'reload': true});

                }, function (error) {
                    console.log('ERROR');
                    return false;
                });

            })
        };

        $scope.close = function () {
            $state.transitionTo('warehouse.output', null, {'reload': true});
        }


    }

})();

