(function () {

    'use strict';
    angular.module('sys.app.output.new')
        .controller('NewOutputCtrl', NewOutputCtrl);

    NewOutputCtrl.$inject = ['$scope', '$stateParams', '$state', 'RESTService', 'notifyAlert', '$rootScope', '_', 'HelperFactory', '$timeout', 'ConfigPagination'];

    function NewOutputCtrl($scope, $stateParams, $state, RESTService, notifyAlert, $rootScope, _, HelperFactory, $timeout, ConfigPagination) {
        try {
            if (!_.isNull($stateParams.entity.id)) {
                $scope.entity = $stateParams.entity;
                $scope.output = $stateParams.entity;
                if ($scope.output.id != 0) {//$scope.unitElements
                    $scope.txt_title = 'Editar'
                    $scope.action = 'edit';
                    $scope.output.reason = $scope.entity.reason;
                }
                else {
                    $scope.txt_title = 'Registrar';
                    $scope.action = 'create';

                    $scope.products = [];

                    $scope.output = {
                        'reason': null,
                        'date_movement': moment().format('YYYY-MM-DD'),
                    };
                }
            }
        }
        catch (e) {
            $state.transitionTo('warehouse.output', null, {'reload': true});
            console.log(e);
            return false;
        }

        init()

        function init() {

            RESTService.all('warehouses/branchoffice', null, function (response) {
                $scope.warehouses = response.results;
                $scope.warehousesSelected = response.results[0];
            });

            RESTService.all('warehouse/concepts/output', null, function (response) {
                $scope.concepts = response.results;
                var last = $scope.concepts.length;
                $scope.concepts[last] = {id: null, description:'Seleccione motivo', value:null};
                $scope.conceptSelected = response.results[last];
            });

            $timeout(function () {
                $('#date_response').daterangepicker({
                    locale: {
                        format: 'YYYY-MM-DD'
                    },
                    singleDatePicker: true,
                    showDropdowns: true,
                    minDate: new Date()
                });

                $('[data-toggle="tooltip"]').tooltip();

            }, 100);
        }


        $scope.changeWarehousesSelected = function (item) {
            $scope.warehousesSelected = item;
            changeInformationProductStock();
        }

        function changeInformationProductStock() {
            $.each($scope.products, function (i, product) {
                var index = $scope.products.indexOf(product);
                $.each(product.productstock, function (i, stock_val) {
                    if($scope.warehousesSelected.id == stock_val.warehouse_id) {
                        $scope.products[index].stock_information = stock_val;
                    }
                });
            });

            notifyAlert.warning("Se actualizo el mínimo disponible de cada producto, acorde al almacen seleccionado.");
        }

        function getBatchExpiration(product) {
            var params;
            params = "product_id=" + product.id + '&warehouse_id=' + $scope.warehousesSelected.id;
            RESTService.all('product/batch/expiration', params, function (response) {
                var index = $scope.products.indexOf(product);
                if(response.results.length > 0){
                    var batchs = response.results;
                    $("#batchExpiration"+index).html('');
                    $.each(batchs, function (i, item) {
                        $("#batchExpiration"+index).append($('<option>', {
                            value: item.id,
                            text : moment(item.date_expiration).format('MMMM D, YYYY')
                        }));
                    });
                    $("#batchExpiration"+index).val(batchs[0].id);
                    $scope.products[index].batch_id = batchs[0].id;
                }else{
                    $("#short_batchExpiration"+index).show();
                    $("#batchExpiration"+index).hide();
                }
            });
        };

        $scope.recalculate_quantity = function (count, product, $index) {
            var check_quantity = angular.element(document.querySelector('#quantity' + $index)).val();
            var q_ = check_quantity;

            angular.element(document.querySelector('#quantity' + $index)).val(q_);

            var quantity = angular.element(document.querySelector('#quantity' + $index)).val();

            if (!_.isNaN(quantity * 1)) {
                var index = $scope.products.indexOf(product);
                var subtotal = (Number(quantity) * Number($scope.products[index].price))
                $scope.products[index].quantity = quantity;
                $scope.products[index].subtotal = subtotal;
            }
        };

        $scope.recalculate_price = function (price, product, $index) {
            var check_price = angular.element(document.querySelector('#price' + $index)).val();
            var q_ = check_price;

            angular.element(document.querySelector('#price' + $index)).val(q_);

            var price_get = angular.element(document.querySelector('#price' + $index)).val();

            if (!_.isNaN(price_get * 1)) {
                var index = $scope.products.indexOf(product);
                $scope.products[index].subtotal = (Number(product.quantity) * Number(price_get)).toFixed(2);
                $scope.products[index].price = Number(price_get);
            }
        };

        $scope.change_unitmeasure = function (unitSelected, product, $index) {
            var check_unit = angular.element(document.querySelector('#unitSelected' + $index)).val();
            var pos = $scope.products.indexOf(product);
            $scope.products[pos].unit_id = check_unit;
        };

        $scope.change_batchexpiration = function (unitSelected, product, $index) {
            var check_unit = angular.element(document.querySelector('#batchExpiration' + $index)).val();
            var pos = $scope.products.indexOf(product);
            $scope.products[pos].batch_id = check_unit;
        };

        $scope.removeItem = function ($event, product, $index) {
            $event.preventDefault();
            var index = $scope.products.indexOf(product);
            $scope.products.splice(index, 1)
            notifyAlert.info("El producto " + product.description + ' ha sido removido del detalle');
        };

        $scope.selectedProduct = function (response) {
            if (!_.isUndefined(response)) {
                var item = response.originalObject;

                var unique = ifExistProduct(item);
                if (unique) {
                    item.quantity = null;
                    item.price = null;
                    item.subtotal = 0;
                    item.unit_id = 0;
                    item.batch_id = null;
                    $.each(item.productstock, function (i, stock_val) {
                        if($scope.warehousesSelected.id == stock_val.warehouse_id){
                            item.stock_information = stock_val;
                        }
                    });

                    $scope.products.push(item);

                    var last = $scope.products.length;
                    $timeout(function () {
                        angular.element(document.querySelector('#quantity' + Number(last - 1))).focus();
                        listUnitMeasureProduct(last, item);

                        // get batch information
                        getBatchExpiration(item);
                    }, 50);
                    $scope.$broadcast('angucomplete-alt:clearInput', 'search_product');
                }
                else {
                    notifyAlert.warning('El producto ' + item.description + ' ya se encuentra agregado');
                }
            }
        }

        function listUnitMeasureProduct(pos, product) {
            var index = pos - 1;
            var units = product.unitsmeasure;

            $("#unitSelected"+index).html('');
            $.each(units, function (i, item) {
                $("#unitSelected"+index).append($('<option>', {
                    value: item.id,
                    text : item.description + ' ('+item.equivalence+')'
                }));
            });

            $("#unitSelected"+index).val(units[0].id);
            // $("#unitSelected"+index).attr('disabled', 'disabled');
            var pos = $scope.products.indexOf(product);
            $scope.products[pos].unit_id = units[0].id;
        }

        function ifExistProduct(obj) {
            var cart = $scope.products;
            var is_unique = true;
            for (var key in cart) {
                if (cart[key].id === Number(obj.id)) {
                    is_unique = false;
                    break;
                }
            }
            return is_unique;
        }

        $scope.click_input_quantity = function (msg, $event) {
            var el = event.target;
            el.select();
        };

        $scope.click_input_price = function (msg, $event) {
            var el = event.target;
            el.select();
        };

        $scope.save = function () {
            if (validate()) {
                var data = {};
                $scope.output['warehouse_id'] = $scope.warehousesSelected.id;
                $scope.output['warehouseconcept_id'] = $scope.conceptSelected.id;

                data.output = $scope.output;
                data.detail = $scope.products;

                if ($scope.action == 'create') {
                    RESTService.save('output/save', data, function (result) {
                        notifyAlert.success("Registro realizado con éxito!!");
                        $state.transitionTo('warehouse.output', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
                else if ($scope.action == 'edit') {
                    RESTService.updated('output/update', $scope.output.id, $scope.output, function (result) {
                        notifyAlert.success("Registro actualizado con éxito!!");
                        $state.transitionTo('warehouse.output', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
            }
        };


        function validate() {
            if (_.isNull($scope.conceptSelected.id)) {
                HelperFactory.show_AlertFactory('Debe seleccionar un motivo');
                angular.element(document.querySelector('#conceptSelected')).focus();
                return false;
            }

            if ($scope.products.length === 0) {
                HelperFactory.show_AlertFactory('Debe ingresar por lo menos un producto al detalle');
                return false;
            }

            // check quantity
            for (var i in $scope.products) {
                if(Number($scope.products[i].quantity) == 0 || _.isNull($scope.products[i].quantity)){
                    HelperFactory.show_AlertFactory('La cantidad del producto '+$scope.products[i].description+' no puede ser igual a cero o estar vacío.');
                    angular.element(document.querySelector('#quantity'+i)).focus();
                    return false;
                }
            }

            // check price
            for (var i in $scope.products) {
                if(Number($scope.products[i].price) == 0 || _.isNull($scope.products[i].price)){
                    HelperFactory.show_AlertFactory('El precio del producto '+$scope.products[i].description+' no puede ser igual a cero o estar vacío.');
                    angular.element(document.querySelector('#price'+i)).focus();
                    return false;
                }
            }

            return true;
        };

        $scope.close = function () {
            $state.transitionTo('warehouse.output', null, {'reload': true});
        };
    }

})();

