(function () {
    'use strict';

    angular.module('sys.app.output', [
        'sys.app.output.new',
        'sys.app.output.detail',
    ]);

    angular.module('sys.app.entry').config(Config);

    Config.$inject = ['$stateProvider', '$urlRouterProvider'];

    function Config($stateProvider, $urlRouterProvider) {
        $stateProvider
            .state('warehouse.output.new', {
                url: '/nuevo',
                templateUrl: '../../templates/warehouse/output/new.html',
                controller: 'NewOutputCtrl',
                cache: false,
                params: {
                    entity: null
                },
                title: 'Crear salida',
                module: "output"
            })

            .state('warehouse.output.edit', {
                url: '/editar',
                templateUrl: '../../templates/warehouse/output/new.html',
                controller: 'NewOutputCtrl',
                cache: false,
                params: {
                    entity: null
                },
                title: 'Editar salida',
                module: "output"
            })

            .state('warehouse.output.detail', {
                url: '/detalle',
                templateUrl: '../../templates/warehouse/output/detail.html',
                controller: 'DetailOutputCtrl',
                params: {
                    entity: null
                },
                title:'Detalle movimiento',
                module:"output"
            })

        ;

        $urlRouterProvider.otherwise('/productos');
    }

    //endregion
})();