(function () {
    'use strict';
    angular.module('sys.app.output')
        .controller('OutputCtrl', OutputCtrl);

    OutputCtrl.$inject = ['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory','$timeout', 'notifyAlert', 'SEARCH'];

    function OutputCtrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $timeout, notifyAlert, SEARCH) {

        $scope.entity = {};
        $scope.text= null;
        $scope.currentPage = 1;
        var object = "";

        init();

        function init() {
            object = "search=" + $scope.text + '&page=' + $scope.currentPage+'&type_movement=S';

            RESTService.all('output/list', object, function (response) {

                $scope.allData = response.results;
                $scope.totalItems = response.total;
                $scope.itemsPerPage = response.paginate_by;

            }, function (error) {
                console.log('ERROR');
                return false;
            });

        }


        $scope.searchAction = function (text) {
            $scope.text = text;
            $scope.currentPage = 1;
            if (text.length >= SEARCH.MIN_LETTERS || text.length == 0) {
                delete $scope.allData;
                init();
            }
        };

        $scope.refresh = function () {
            delete $scope.allData;
            $state.transitionTo('warehouse.output', {entity: null}, {'reload': true});
        };

        // functions new product
        $scope.new = function () {
            var source = {'id': 0};
            $state.transitionTo('warehouse.output.new', {entity: source}, {
                'reload': 'warehouse.output.new',
                'cache': false
            });
            delete $scope.allData;
        };

        $scope.edit = function (source) {
            delete $scope.allData;
            RESTService.get('output/edit', source.id, function (response) {
                $state.transitionTo("warehouse.output.edit", {
                    'id': source.id,
                    entity: response.data
                }, {'reload': "warehouse.output.edit", 'cache': false});
            }, function (error) {
                console.log('ERROR');
                return false;
            });

        };

        $scope.detail = function (source) {

            delete $scope.allData;
            RESTService.get('output/detail', source.id, function (response) {
                $state.transitionTo("warehouse.output.detail", {
                    'id': source.id,
                    entity: response.data
                }, {'reload': "warehouse.output.detail", 'cache': false});
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        };

        $scope.pageChanged = function(page) {
            $scope.currentPage = page;
            delete $scope.allData;
            // console.log('Page changed to: ' + $scope.currentPage);
            init();
        };

        $scope.delete = function (item) {
            var options = {
                title: "Cuidado!!",
                message: "El registro ' "+item.description+" ' será eliminado",
                cancel: "Cancelar",
                confirm: "Eliminar"
            };
            AlertFactory.confirm(options, function () {
                RESTService.deleted('output/delete', item.id, function (response) {
                    notifyAlert.success("El item se ha eliminado con éxito!!");
                    var obj = {"text": $scope.text};
                    $state.transitionTo('warehouse.warehouses', {entity: obj}, {'reload': true});
                }, function (error) {
                    console.log('ERROR');
                    return false;
                });

            })

        };


    }
})();



