(function () {
    'use strict';
    angular.module('sys.app.stockgeneral')
        .controller('StockGeneralCtrl', StockGeneralCtrl);

    StockGeneralCtrl.$inject = ['$scope', '$state', 'RESTService', 'ConfigPagination', 'AlertFactory','$timeout', 'notifyAlert', 'SEARCH', 'PRODUCT', 'EXPORT'];

    function StockGeneralCtrl($scope, $state, RESTService, ConfigPagination, AlertFactory, $timeout, notifyAlert, SEARCH, PRODUCT, EXPORT) {

        $scope.entity = {};
        $scope.text= null;
        $scope.currentPage = 1;
        var object = "";

        var typeprice = PRODUCT.TYPEPRICE;
        $scope.is_price_unit = typeprice[1];

        // $scope.warehousesSelected = {
        //     'id':1
        // };
        // init();

        sync();

        function sync() {
            RESTService.all('warehouses/branchoffice', null, function (response) {
                $scope.warehouses = response.results;
                $scope.warehousesSelected = response.results[0];
                init();
            });            
        };

        function init() {
            object = "search=" + $scope.text + '&page=' + $scope.currentPage+'&warehouse='+$scope.warehousesSelected.id;
            RESTService.all('stockgeneral/list', object, function (response) {
                $scope.allData = response.results;
                $scope.totalItems = response.total;
                $scope.itemsPerPage = response.paginate_by;
            }, function (error) {
                console.log('ERROR');
                return false;
            });
        }
        
        $scope.changeWarehousesSelected = function (item) {
            $scope.warehousesSelected = item;
            init();
        }

        $scope.searchAction = function (text) {
            $scope.text = text;
            $scope.currentPage = 1;
            if (text.length >= SEARCH.MIN_LETTERS || text.length == 0) {
                delete $scope.allData;
                init();
            }
        };
        
        $scope.refresh = function () {
            delete $scope.allData;
            $state.transitionTo('warehouse.stockgeneral', {entity: null}, {'reload': true});
        };

        $scope.pageChanged = function(page) {
            $scope.currentPage = page;
            delete $scope.allData;
            init();
        };

        $scope.export = function () {
            $scope.formatSelected = EXPORT.FORMAT[0];

            var url_export = '&format='+ $scope.formatSelected.id + '&warehouse=' + $scope.warehousesSelected.id;

            window.open('/report/warehouse/stockgeneral?' + url_export);
        }


    }
})();



