
(function () {
    'use strict';

    angular.module('sys.app.warehouse').config(Config);

    Config.$inject = ['$stateProvider', '$urlRouterProvider'];


    function Config($stateProvider, $urlRouterProvider) {
        $stateProvider

            .state('warehouse.warehouses', {
                url: '/almacenes',
                templateUrl: '../../templates/warehouse/warehouses.html',
                controller: 'WarehousesCtrl',
                params: {
                    entity: null
                },
                title: "Almacenes",
                module:"warehouses"
            })

            .state('warehouse.entry', {
                url: '/ingresos',
                templateUrl: '../../templates/warehouse/entry.html',
                controller: 'EntryCtrl',
                params: {
                    entity: null
                },
                title: "Ingresos almacén",
                module:"entry"
            })

            .state('warehouse.output', {
                url: '/salidas',
                templateUrl: '../../templates/warehouse/output.html',
                controller: 'OutputCtrl',
                params: {
                    entity: null
                },
                title: "Salidas almacén",
                module:"output"
            })

            .state('warehouse.transfers', {
                url: '/traspasos',
                templateUrl: '../../templates/warehouse/transfers.html',
                controller: 'TransfersCtrl',
                params: {
                    entity: null
                },
                title: "Traspasos almacén",
                module:"transfers"
            })

            .state('warehouse.stockgeneral', {
                url: '/stockgeneral',
                templateUrl: '../../templates/warehouse/stockgeneral.html',
                controller: 'StockGeneralCtrl',
                params: {
                    entity: null
                },
                title: "Stock general",
                module:"stockgeneral"
            });

        $urlRouterProvider.otherwise('/almacenes');
    }

})();
