(function () {

    'use strict';
    angular.module('sys.app.warehouses.new')
        .controller('NewWarehousesCtrl', NewWarehousesCtrl);

    NewWarehousesCtrl.$inject = ['$scope', '$stateParams', '$state', 'RESTService', 'notifyAlert', '$rootScope', '_', 'HelperFactory'];

    function NewWarehousesCtrl($scope, $stateParams, $state, RESTService, notifyAlert, $rootScope, _, HelperFactory) {
        try {
            if (!_.isNull($stateParams.entity.id)) {
                $scope.entity = $stateParams.entity;
                $scope.warehouses = $stateParams.entity;
                if ($scope.warehouses.id != 0) {//$scope.unitElements
                    $scope.txt_title = 'Editar'
                    $scope.action = 'edit';
                    $scope.warehouses.description = $scope.entity.description;
                }
                else {
                    $scope.txt_title = 'Registrar';
                    $scope.action = 'create';
                    $scope.warehouses = {
                        'description': null
                    };
                }
            }
        }
        catch (e) {
            $state.transitionTo('warehouse.warehouses', null, {'reload': true});
            console.log(e);
            return false;
        }

        init()

        function init() {
            angular.element(document.querySelector('#warehouses_description')).focus();
        }

        $scope.save = function () {
            if (validate()) {
                if($scope.action == 'create'){
                    RESTService.save('warehouses/save', $scope.warehouses, function (result) {
                        notifyAlert.success("Registro realizado con éxito!!");
                        $state.transitionTo('warehouse.warehouses', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
                else if($scope.action == 'edit'){
                    RESTService.updated('warehouses/update', $scope.warehouses.id, $scope.warehouses, function (result) {
                        notifyAlert.success("Registro actualizado con éxito!!");
                        $state.transitionTo('warehouse.warehouses', null, {'reload': true});
                    }, function (error) {
                        console.log('ERROR');
                        return false;
                    });
                }
            }
        };

        function validate() {
            if (_.isNull($scope.warehouses.description) || _.isEmpty($scope.warehouses.description)) {
                HelperFactory.show_AlertFactory('Debe ingresar el nombre del almacén');
                angular.element(document.querySelector('#warehouses_description')).focus();
                return false;
            }

            return true;
        };

        $scope.close = function () {
            $state.transitionTo('warehouse.warehouses', null, {'reload': true});
        };

    }

})();

