(function () {
    'use strict';

    angular.module('sys.utils.libraries')
        .factory('AlertFactory', AlertFactory);

    AlertFactory.$inject = ['SweetAlert', '_',  '$timeout'];

    function AlertFactory(SweetAlert, _, $timeout) {
        var alerts = {
            confirm: confirm,
            confirmSuccess: confirmSuccess,
            confirmWarning: confirmWarning,
            confirmInfo: confirmInfo,
            confirmImg: confirmImg,
            confirmImg2: confirmImg2,
            prompt: prompt,
            prompt2: prompt2,
            text: text,
            textType: textType,
            showWarning: showWarning,
            showErrors: showErrors
        };
        return alerts;


        function showWarning(options, confirm) {
            $timeout(function () {
                SweetAlert.swal({
                    title: options.title,
                    text: options.message,
                    // html: options.message,
                    type: 'warning',
                    // closeOnConfirm: true,
                    customClass: (_.isUndefined(options.customClass)) ? '' : options.customClass,
                }, function (isConfirm) {
                    if (typeof confirm === "function") {
                        confirm(isConfirm);
                    }
                });
            }, 200);

        }

        function showErrors(options, confirm) {
            $timeout(function () {
                SweetAlert.swal({
                    title: options.title,
                    text: options.message,
                    // html: options.message,
                    type: "error",
                    // closeOnConfirm: true
                }, function (isConfirm) {
                    if (typeof confirm === "function") {
                        confirm(isConfirm);
                    }
                });
            }, 200);

        }

        function confirmImg(options, confirm, cancel) {
            var status = true;
            options.title = options.title || 'Está seguro?';

            $timeout(function () {
                SweetAlert.swal({
                        title: options.title,
                        text: options.message,
                        type: 'warning',
                        showCancelButton: false,
                        confirmButtonColor: "#DD6B55", confirmButtonText: options.confirm,
                        cancelButtonText: options.cancel,
                        closeOnConfirm: true,
                        closeOnCancel: true,
                        status: status
                    },
                    function (isConfirm) {
                        if (isConfirm) {
                            //SweetAlert.swal("Excelente !", "Felicitaciones la acción se ejecuto correctamente :)", "success");
                            if (typeof confirm === "function") {
                                confirm(options);
                            }
                        }
                    });
            }, 200);

        }

        function confirmImg2(options, confirm, cancel) {
            var status = true;
            options.title = options.title || 'Está seguro?';

            $timeout(function () {
                SweetAlert.swal({
                        title: options.title,
                        text: options.message,
                        type: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: "#DD6B55", confirmButtonText: options.confirm,
                        cancelButtonText: options.cancel,
                        closeOnConfirm: true,
                        closeOnCancel: true,
                        status: status
                    },
                    function (isConfirm) {
                        if (isConfirm) {
                            //SweetAlert.swal("Excelente !", "Felicitaciones la acción se ejecuto correctamente :)", "success");
                            if (typeof confirm === "function") {
                                confirm(options);
                            }
                        } else {
                            cancel();
                        }
                    });
            }, 200);

        }


        function confirmSuccess(options, confirm, cancel) {
            options.title = options.title || 'Está seguro?';

            $timeout(function () {
                swal({
                    title: options.title,
                    text: options.message,
                    type: 'success',
                    showCancelButton: true,
                    confirmButtonColor: "#30419b",
                    confirmButtonClass: 'btn btn-danger',
                    cancelButtonClass: 'btn btn-secondary ml-2',
                    confirmButtonText: options.confirm,
                    cancelButtonText: options.cancel
                }).then(function (isConfirm) {
                    if (isConfirm.value==true) {
                        //SweetAlert.swal("Excelente !", "Felicitaciones la acción se ejecuto correctamente :)", "success");
                        if (typeof confirm === "function") {
                            confirm(options);
                        }
                    } else {
                        // swal("Cancelado", "Acción cancelada", "error");
                        if (typeof cancel === "function") {
                            cancel();
                        }
                    }
                });

                // SweetAlert.swal({
                //         title: options.title,
                //         text: options.message,
                //         type: 'warning',
                //         showCancelButton: true,
                //         confirmButtonColor: "#dd241b",
                //         confirmButtonText: options.confirm,
                //         cancelButtonText: options.cancel,
                //         closeOnConfirm : (_.isUndefined(options.closeOnConfirm )) ? true : options.closeOnConfirm,
                //         showLoaderOnConfirm: (_.isUndefined(options.showLoaderOnConfirm)) ?
                //             false : options.showLoaderOnConfirm,
                //         // closeOnCancel: true
                //     },
                //     function (isConfirm) {
                //         if (isConfirm) {
                //
                //             //SweetAlert.swal("Excelente !", "Felicitaciones la acción se ejecuto correctamente :)", "success");
                //             if (typeof confirm === "function") {
                //                 confirm(options);
                //             }
                //         } else {
                //             //SweetAlert.swal("Cancelado", "Acción cancelada", "error");
                //             if (typeof cancel === "function") {
                //                 cancel();
                //             }
                //         }
                //     });

            }, 200);
        }

        function confirmWarning(options, confirm, cancel) {
            options.title = options.title || 'Está seguro?';

            $timeout(function () {
                swal({
                    title: options.title,
                    html: options.message,
                    type: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: "#30419b",
                    cancelButtonClass: 'btn btn-secondary ml-2',
                    confirmButtonText: options.confirm,
                    cancelButtonText: options.cancel
                }).then(function (isConfirm) {
                    if (isConfirm.value==true) {
                        if (typeof confirm === "function") {
                            confirm(options);
                        }
                    } else {
                        if (typeof cancel === "function") {
                            cancel();
                        }
                    }
                });
            }, 200);
        }

        function confirmInfo(options, confirm, cancel) {
            options.title = options.title || 'Está seguro?';

            $timeout(function () {
                swal({
                    title: options.title,
                    text: options.message,
                    type: 'info',
                    showCancelButton: true,
                    confirmButtonColor: "#30419b",
                    confirmButtonClass: 'btn btn-danger',
                    cancelButtonClass: 'btn btn-secondary ml-2',
                    confirmButtonText: options.confirm,
                    cancelButtonText: options.cancel
                }).then(function (isConfirm) {
                    if (isConfirm.value==true) {
                        //SweetAlert.swal("Excelente !", "Felicitaciones la acción se ejecuto correctamente :)", "success");
                        if (typeof confirm === "function") {
                            confirm(options);
                        }
                    } else {
                        // swal("Cancelado", "Acción cancelada", "error");
                        if (typeof cancel === "function") {
                            cancel();
                        }
                    }
                });

                // SweetAlert.swal({
                //         title: options.title,
                //         text: options.message,
                //         type: 'warning',
                //         showCancelButton: true,
                //         confirmButtonColor: "#dd241b",
                //         confirmButtonText: options.confirm,
                //         cancelButtonText: options.cancel,
                //         closeOnConfirm : (_.isUndefined(options.closeOnConfirm )) ? true : options.closeOnConfirm,
                //         showLoaderOnConfirm: (_.isUndefined(options.showLoaderOnConfirm)) ?
                //             false : options.showLoaderOnConfirm,
                //         // closeOnCancel: true
                //     },
                //     function (isConfirm) {
                //         if (isConfirm) {
                //
                //             //SweetAlert.swal("Excelente !", "Felicitaciones la acción se ejecuto correctamente :)", "success");
                //             if (typeof confirm === "function") {
                //                 confirm(options);
                //             }
                //         } else {
                //             //SweetAlert.swal("Cancelado", "Acción cancelada", "error");
                //             if (typeof cancel === "function") {
                //                 cancel();
                //             }
                //         }
                //     });

            }, 200);
        }

        function confirm(options, confirm, cancel) {
            options.title = options.title || 'Está seguro?';

            $timeout(function () {

                swal({
                    title: options.title,
                    text: options.message,
                    type: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: "#dd241b",
                    confirmButtonClass: 'btn btn-danger',
                    cancelButtonClass: 'btn btn-secondary ml-2',
                    confirmButtonText: options.confirm,
                    cancelButtonText: options.cancel
                }).then(function (isConfirm) {
                    if (isConfirm.value==true) {
                        //SweetAlert.swal("Excelente !", "Felicitaciones la acción se ejecuto correctamente :)", "success");
                        if (typeof confirm === "function") {
                            confirm(options);
                        }
                    } else {
                        // swal("Cancelado", "Acción cancelada", "error");
                        if (typeof cancel === "function") {
                            cancel();
                        }
                    }
                });

                // SweetAlert.swal({
                //         title: options.title,
                //         text: options.message,
                //         type: 'warning',
                //         showCancelButton: true,
                //         confirmButtonColor: "#dd241b",
                //         confirmButtonText: options.confirm,
                //         cancelButtonText: options.cancel,
                //         closeOnConfirm : (_.isUndefined(options.closeOnConfirm )) ? true : options.closeOnConfirm,
                //         showLoaderOnConfirm: (_.isUndefined(options.showLoaderOnConfirm)) ?
                //             false : options.showLoaderOnConfirm,
                //         // closeOnCancel: true
                //     },
                //     function (isConfirm) {
                //         if (isConfirm) {
                //
                //             //SweetAlert.swal("Excelente !", "Felicitaciones la acción se ejecuto correctamente :)", "success");
                //             if (typeof confirm === "function") {
                //                 confirm(options);
                //             }
                //         } else {
                //             //SweetAlert.swal("Cancelado", "Acción cancelada", "error");
                //             if (typeof cancel === "function") {
                //                 cancel();
                //             }
                //         }
                //     });

            }, 200);
        }

        function prompt(options, confirm, cancel) {
            $timeout(function () {
                SweetAlert.swal({
                    title: options.title,
                    text: options.message,
                    type: (_.isUndefined(options.type)) ? 'input' : options.type,
                    inputType: (_.isUndefined(options.inputType)) ? 'text' : options.inputType,
                    showCancelButton: true,
                    closeOnConfirm: (_.isUndefined(options.closeOnConfirm)) ? true : options.closeOnConfirm,
                    animation: "slide-from-top",
                    inputPlaceholder: (_.isUndefined(options.placeholder)) ? '' : options.placeholder,
                    inputValue: (_.isUndefined(options.inputValue)) ? '' : options.inputValue,
                    confirmButtonText: (_.isUndefined(options.confirmButtonText)) ? 'Ok' : options.confirmButtonText,
                    cancelButtonText: (_.isUndefined(options.cancelButtonText)) ? 'Cancel' : options.cancelButtonText,
                    showLoaderOnConfirm: (_.isUndefined(options.showLoaderOnConfirm)) ? false : options.showLoaderOnConfirm
                }, function (inputValue) {
                    if (inputValue === false) {
                        if (typeof cancel === "function") {
                            cancel();
                        }
                        return false;
                    }

                    if (inputValue == "" || _.isNull(inputValue) || _.isUndefined(inputValue) || _.isNaN(inputValue)) {
                        swal.showInputError(options.error_message);
                        return false
                    }

                    if (!_.isUndefined(options.success_message)) {
                        SweetAlert.swal(options.success_message, "success");
                    }

                    if (typeof confirm === "function") {
                        confirm(inputValue);
                    }
                });
            }, 200);

        }

        function prompt2(options, confirm, cancel) {
            $timeout(function () {
                SweetAlert.swal({
                    title: options.title,
                    text: options.message,
                    type: "input",
                    showCancelButton: true,
                    closeOnConfirm: false,
                    animation: "slide-from-top",
                    inputPlaceholder: options.placeholder,
                    inputValue: options.inputValue
                }, function (inputValue) {
                    if (inputValue === false) {
                        if (typeof cancel === "function") {
                            cancel();
                        }
                        return false;
                    }

                    if (inputValue == "" || _.isNull(inputValue) || _.isUndefined(inputValue) || _.isNaN(inputValue)) {
                        swal.showInputError(options.error_message);
                        return false
                    }

                    // SweetAlert.swal("Bien echo!", "Usted ingreso el numero de serie " + inputValue, "success");

                    if (typeof confirm === "function") {
                        confirm(inputValue);
                    }
                });
            }, 200);

        }

        function text(options) {
            $timeout(function () {
                SweetAlert.swal(options.title, options.message)
            }, 200);

        }

        function textType(options) {
            $timeout(function () {
                SweetAlert.swal(options.title, options.message, options.type)
            }, 200);
        }
    }
})();
